/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.oe.client;

import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.derbyTesting.system.oe.client.Display;
import org.apache.derbyTesting.system.oe.client.Operations;
import org.apache.derbyTesting.system.oe.util.OERandom;

public class Submitter {
    public static final int STOCK_LEVEL = 0;
    public static final int ORDER_STATUS_BY_NAME = 1;
    public static final int ORDER_STATUS_BY_ID = 2;
    public static final int PAYMENT_BY_NAME = 3;
    public static final int PAYMENT_BY_ID = 4;
    public static final int DELIVERY_SCHEDULE = 5;
    public static final int NEW_ORDER = 6;
    public static final int NEW_ORDER_ROLLBACK = 7;
    private final Display display;
    private final Operations ops;
    private final OERandom rand;
    private final short maxW;
    private final int[] transactionCount;

    public static OERandom getRuntimeRandom(Connection connection) throws SQLException {
        int n;
        int n2;
        OERandom oERandom = new OERandom(-1);
        ResultSet resultSet = connection.createStatement().executeQuery("SELECT CLOAD FROM C");
        resultSet.next();
        int n3 = resultSet.getInt(1);
        resultSet.close();
        while ((n2 = Math.abs(n3 - (n = oERandom.randomInt(0, 255)))) == 96 || n2 == 112 || n2 < 65 || n2 > 119) {
        }
        oERandom = new OERandom(n);
        return oERandom;
    }

    public static Submitter stockLevelOnly(Display display, Operations operations, OERandom oERandom, short s) {
        return new Submitter(display, operations, oERandom, s){

            @Override
            protected int mixType(int n) {
                return 0;
            }
        };
    }

    public static Submitter orderStatusByIdOnly(Display display, Operations operations, OERandom oERandom, short s) {
        return new Submitter(display, operations, oERandom, s){

            @Override
            protected int mixType(int n) {
                return 2;
            }
        };
    }

    public static Submitter orderStatusByNameOnly(Display display, Operations operations, OERandom oERandom, short s) {
        return new Submitter(display, operations, oERandom, s){

            @Override
            protected int mixType(int n) {
                return 1;
            }
        };
    }

    public static Submitter paymentByIdOnly(Display display, Operations operations, OERandom oERandom, short s) {
        return new Submitter(display, operations, oERandom, s){

            @Override
            protected int mixType(int n) {
                return 4;
            }
        };
    }

    public static Submitter paymentByNameOnly(Display display, Operations operations, OERandom oERandom, short s) {
        return new Submitter(display, operations, oERandom, s){

            @Override
            protected int mixType(int n) {
                return 3;
            }
        };
    }

    public static Submitter newOrderOnly(Display display, Operations operations, OERandom oERandom, short s) {
        return new Submitter(display, operations, oERandom, s){

            @Override
            protected int mixType(int n) {
                return 6;
            }
        };
    }

    public Submitter(Display display, Operations operations, OERandom oERandom, short s) {
        this.display = display;
        this.ops = operations;
        this.rand = oERandom;
        this.maxW = s;
        this.transactionCount = new int[8];
    }

    public void clearTransactionCount() {
        Arrays.fill(this.transactionCount, 0);
    }

    public long runTransactions(Object object, int n) throws Exception {
        long l = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            this.runTransaction(object);
        }
        long l2 = System.currentTimeMillis();
        return l2 - l;
    }

    public void runTransaction(Object object) throws Exception {
        int n = this.rand.randomInt(1, 100);
        int n2 = this.mixType(n);
        switch (n2) {
            case 5: {
                this.runScheduleDelivery(object);
                break;
            }
            case 6: {
                this.runNewOrder(object, false);
                break;
            }
            case 7: {
                this.runNewOrder(object, true);
                break;
            }
            case 2: {
                this.runOrderStatus(object, false);
                break;
            }
            case 1: {
                this.runOrderStatus(object, true);
                break;
            }
            case 4: {
                this.runPayment(object, false);
                break;
            }
            case 3: {
                this.runPayment(object, true);
                break;
            }
            case 0: {
                this.runStockLevel(object);
            }
        }
        int n3 = n2;
        this.transactionCount[n3] = this.transactionCount[n3] + 1;
    }

    protected int mixType(int n) {
        if (n <= 43) {
            boolean bl = this.rand.randomInt(1, 100) <= 60;
            return bl ? 3 : 4;
        }
        if (n <= 47) {
            boolean bl = this.rand.randomInt(1, 100) <= 60;
            return bl ? 1 : 2;
        }
        if (n <= 51) {
            return 5;
        }
        if (n <= 55) {
            return 0;
        }
        boolean bl = this.rand.randomInt(1, 100) == 1;
        return bl ? 7 : 6;
    }

    protected void runNewOrder(Object object, boolean bl) throws Exception {
        short s = this.warehouse();
        int n = this.rand.randomInt(5, 15);
        int[] nArray = new int[n];
        short[] sArray = new short[n];
        short[] sArray2 = new short[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.rand.NURand8191();
            if (this.maxW == 1 || this.rand.randomInt(1, 100) > 1) {
                sArray2[i] = s;
            } else {
                short s2 = this.warehouse();
                while (s2 == s) {
                    s2 = this.warehouse();
                }
                sArray2[i] = s2;
            }
            sArray2[i] = this.rand.randomInt(1, 100) > 1 ? s : this.warehouse();
            sArray[i] = (short)this.rand.randomInt(1, 10);
        }
        if (bl) {
            nArray[n - 1] = 2334432;
        }
        this.ops.newOrder(this.display, object, s, this.rand.district(), this.rand.NURand1023(), nArray, sArray, sArray2);
    }

    protected void runScheduleDelivery(Object object) {
    }

    protected void runPayment(Object object, boolean bl) throws Exception {
        if (bl) {
            this.ops.payment(this.display, object, this.warehouse(), this.rand.district(), this.warehouse(), this.rand.district(), this.rand.randomCLast(), this.rand.payment().toString());
        } else {
            this.ops.payment(this.display, object, this.warehouse(), this.rand.district(), this.warehouse(), this.rand.district(), this.rand.NURand1023(), this.rand.payment().toString());
        }
    }

    private final short warehouse() {
        if (this.maxW == 1) {
            return 1;
        }
        return (short)this.rand.randomInt(1, this.maxW);
    }

    protected void runStockLevel(Object object) throws Exception {
        this.ops.stockLevel(this.display, object, this.warehouse(), this.rand.district(), this.rand.threshold());
    }

    protected void runOrderStatus(Object object, boolean bl) throws Exception {
        if (bl) {
            this.ops.orderStatus(this.display, object, this.warehouse(), this.rand.district(), this.rand.randomCLast());
        } else {
            this.ops.orderStatus(this.display, object, this.warehouse(), this.rand.district(), this.rand.NURand1023());
        }
    }

    public void printReport(PrintStream printStream) {
        int n;
        int n2 = 0;
        for (n = 0; n < this.transactionCount.length; ++n) {
            n2 += this.transactionCount[n];
        }
        printStream.println("Total Transactions: " + n2);
        n = this.transactionCount[6] + this.transactionCount[7];
        int n3 = this.transactionCount[3] + this.transactionCount[4];
        int n4 = this.transactionCount[1] + this.transactionCount[2];
        if (n != 0) {
            printStream.println(this.transactionCount("New Order         ", n, n2));
        }
        if (n3 != 0) {
            printStream.println(this.transactionCount("Payment           ", n3, n2));
            printStream.println(this.transactionCount("    By Name       ", this.transactionCount[3], n2));
            printStream.println(this.transactionCount("    By Identifier ", this.transactionCount[4], n2));
        }
        if (n4 != 0) {
            printStream.println(this.transactionCount("Order Status      ", n4, n2));
            printStream.println(this.transactionCount("    By Name       ", this.transactionCount[1], n2));
            printStream.println(this.transactionCount("    By Identifier ", this.transactionCount[2], n2));
        }
        if (this.transactionCount[0] != 0) {
            printStream.println(this.transactionCount("Stock Level       ", this.transactionCount[0], n2));
        }
        if (this.transactionCount[5] != 0) {
            printStream.println(this.transactionCount("Schedule Delivery ", this.transactionCount[5], n2));
        }
    }

    private String transactionCount(String string, int n, int n2) {
        return string + " : " + this.percent(n, n2) + "(" + n + ")";
    }

    private String percent(int n, int n2) {
        BigDecimal bigDecimal = BigDecimal.valueOf((long)n * 100L);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(n2);
        BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2, 2, RoundingMode.DOWN);
        return bigDecimal3.toString().concat("%");
    }

    public int[] getTransactionCount() {
        return this.transactionCount;
    }
}

