/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.services;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.services.io.LimitInputStream;

public class MarkedLimitInputStream
extends LimitInputStream {
    protected boolean isLastBlock;
    protected int blockLength;

    public MarkedLimitInputStream(DataInputStream dataInputStream) throws IOException {
        super((InputStream)dataInputStream);
        this.start();
    }

    private void start() throws IOException {
        this.isLastBlock = ((DataInputStream)this.in).readBoolean();
        this.blockLength = ((DataInputStream)this.in).readInt();
        this.setLimit(this.blockLength);
    }

    public int read() throws IOException {
        int n = super.read();
        if (n == -1) {
            if (this.isLastBlock) {
                return -1;
            }
            this.start();
            return this.read();
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (this.isLastBlock) {
            int n5;
            int n6;
            for (n5 = 0; n5 < n2 && (n6 = super.read(byArray, n + n5, n2 - n5)) >= 0; n5 += n6) {
            }
            return n5;
        }
        for (n3 = 0; n3 < n2 && (n4 = super.read(byArray, n + n3, n2 - n3)) >= 0; n3 += n4) {
        }
        if (n3 == n2) {
            return n3;
        }
        this.start();
        if (n3 < 0) {
            return this.read(byArray, n, n2);
        }
        return n3 + this.read(byArray, n + n3, n2 - n3);
    }

    public long skip(long l) throws IOException {
        long l2;
        long l3;
        if (this.isLastBlock) {
            return super.skip(l);
        }
        for (l2 = 0L; l2 < l && (l3 = super.skip(l - l2)) > 0L; l2 += l3) {
        }
        if (l2 == l) {
            return l2;
        }
        this.start();
        if (l2 < 0L) {
            return this.skip(l);
        }
        return l2 + this.skip(l - l2);
    }
}

