/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.services;

import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_MultiIterations;
import org.apache.derbyTesting.unitTests.services.T_L1;
import org.apache.derbyTesting.unitTests.services.T_L2;
import org.apache.derbyTesting.unitTests.services.T_User;

public class T_LockFactory
extends T_MultiIterations {
    protected static final int ITERATIONS = 100;
    protected LockFactory lf;

    @Override
    protected String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.services.locks.LockFactory";
    }

    @Override
    protected void setupTest() throws T_Fail {
        try {
            this.lf = (LockFactory)T_LockFactory.startSystemModule(this.getModuleToTestProtocolName());
        }
        catch (StandardException standardException) {
            throw T_Fail.exceptionFail(standardException);
        }
        if (this.lf == null) {
            throw T_Fail.testFailMsg(this.getModuleToTestProtocolName() + " module not started.");
        }
    }

    @Override
    protected void runTestSet() throws T_Fail {
        try {
            this.S001();
            this.S002();
            this.S003();
            this.S004();
            this.S005();
            this.S007();
            this.M001();
            this.M002();
            this.M003();
            this.M004();
        }
        catch (StandardException standardException) {
            throw T_Fail.exceptionFail(standardException);
        }
    }

    void S001() throws StandardException, T_Fail {
        CompatibilitySpace compatibilitySpace = this.lf.createCompatibilitySpace(null);
        Object object = new Object();
        T_L1 t_L1 = new T_L1();
        this.checkLockCount(compatibilitySpace, 0);
        this.lf.lockObject(compatibilitySpace, object, (Lockable)t_L1, null, -1);
        this.checkLockCount(compatibilitySpace, 1);
        int n = this.lf.unlock(compatibilitySpace, object, (Lockable)t_L1, null);
        if (n != 1) {
            throw T_Fail.testFailMsg("invalid unlock count, expected 1, got " + n);
        }
        this.checkLockCount(compatibilitySpace, 0);
        this.lf.lockObject(compatibilitySpace, object, (Lockable)t_L1, null, -1);
        this.lf.lockObject(compatibilitySpace, object, (Lockable)t_L1, null, -1);
        this.checkLockCount(compatibilitySpace, 2);
        this.lf.unlock(compatibilitySpace, object, (Lockable)t_L1, null);
        this.lf.unlock(compatibilitySpace, object, (Lockable)t_L1, null);
        this.checkLockCount(compatibilitySpace, 0);
        this.lf.lockObject(compatibilitySpace, object, (Lockable)t_L1, null, -1);
        this.lf.lockObject(compatibilitySpace, object, (Lockable)t_L1, null, -1);
        this.lf.lockObject(compatibilitySpace, object, (Lockable)t_L1, null, -1);
        this.checkLockCount(compatibilitySpace, 3);
        this.lf.unlockGroup(compatibilitySpace, object);
        this.checkLockCount(compatibilitySpace, 0);
        this.lf.lockObject(compatibilitySpace, object, (Lockable)t_L1, null, -1);
        this.lf.lockObject(compatibilitySpace, object, (Lockable)t_L1, null, -1);
        this.lf.lockObject(compatibilitySpace, object, (Lockable)t_L1, null, -1);
        this.checkLockCount(compatibilitySpace, 3);
        this.lf.unlock(compatibilitySpace, object, (Lockable)t_L1, null);
        this.checkLockCount(compatibilitySpace, 2);
        this.lf.unlock(compatibilitySpace, object, (Lockable)t_L1, null);
        this.checkLockCount(compatibilitySpace, 1);
        this.lf.unlock(compatibilitySpace, object, (Lockable)t_L1, null);
        this.checkLockCount(compatibilitySpace, 0);
        this.lf.lockObject(compatibilitySpace, object, (Lockable)t_L1, null, 1000);
        this.checkLockCount(compatibilitySpace, 1);
        n = this.lf.unlock(compatibilitySpace, object, (Lockable)t_L1, null);
        if (n != 1) {
            throw T_Fail.testFailMsg("invalid unlock count, expected 1, got " + n);
        }
        this.PASS("S001");
    }

    void S002() throws StandardException, T_Fail {
        CompatibilitySpace compatibilitySpace = this.lf.createCompatibilitySpace(null);
        Object object = new Object();
        Object object2 = new Object();
        T_L1 t_L1 = new T_L1();
        this.checkLockCount(compatibilitySpace, 0);
        this.lf.lockObject(compatibilitySpace, object, (Lockable)t_L1, null, -1);
        this.lf.lockObject(compatibilitySpace, object2, (Lockable)t_L1, null, -1);
        this.checkLockGroupCount(compatibilitySpace, object, 1);
        this.checkLockGroupCount(compatibilitySpace, object2, 1);
        this.checkLockCount(compatibilitySpace, 2);
        int n = this.lf.unlock(compatibilitySpace, object, (Lockable)t_L1, null);
        if (n != 1) {
            throw T_Fail.testFailMsg("invalid unlock count, expected 1, got " + n);
        }
        this.checkLockGroupCount(compatibilitySpace, object, 0);
        this.checkLockGroupCount(compatibilitySpace, object2, 1);
        this.checkLockCount(compatibilitySpace, 1);
        n = this.lf.unlock(compatibilitySpace, object2, (Lockable)t_L1, null);
        if (n != 1) {
            throw T_Fail.testFailMsg("invalid unlock count, expected 1, got " + n);
        }
        this.checkLockGroupCount(compatibilitySpace, object, 0);
        this.checkLockGroupCount(compatibilitySpace, object2, 0);
        this.checkLockCount(compatibilitySpace, 0);
        this.lf.lockObject(compatibilitySpace, object, (Lockable)t_L1, null, -1);
        this.lf.lockObject(compatibilitySpace, object2, (Lockable)t_L1, null, -1);
        this.checkLockCount(compatibilitySpace, 2);
        this.lf.unlockGroup(compatibilitySpace, object2);
        this.checkLockGroupCount(compatibilitySpace, object, 1);
        this.checkLockGroupCount(compatibilitySpace, object2, 0);
        this.checkLockCount(compatibilitySpace, 1);
        this.lf.unlockGroup(compatibilitySpace, object);
        this.checkLockGroupCount(compatibilitySpace, object, 0);
        this.checkLockGroupCount(compatibilitySpace, object2, 0);
        this.checkLockCount(compatibilitySpace, 0);
        this.PASS("S002");
    }

    void S003() throws StandardException, T_Fail {
        CompatibilitySpace compatibilitySpace = this.lf.createCompatibilitySpace(null);
        Object object = new Object();
        Object object2 = new Object();
        T_L1 t_L1 = new T_L1();
        T_L1 t_L12 = new T_L1();
        T_L1 t_L13 = new T_L1();
        this.checkLockCount(compatibilitySpace, 0);
        this.lf.lockObject(compatibilitySpace, object, (Lockable)t_L1, null, -1);
        this.lf.lockObject(compatibilitySpace, object2, (Lockable)t_L1, null, -1);
        this.lf.lockObject(compatibilitySpace, object2, (Lockable)t_L12, null, -1);
        this.lf.lockObject(compatibilitySpace, object2, (Lockable)t_L13, null, -1);
        this.checkLockGroupCount(compatibilitySpace, object, 1);
        this.checkLockGroupCount(compatibilitySpace, object2, 3);
        this.checkLockCount(compatibilitySpace, 4);
        if (this.lf.anyoneBlocked()) {
            throw T_Fail.testFailMsg("anyoneBlocked() returned true on a set of private locks");
        }
        this.lf.unlock(compatibilitySpace, object2, (Lockable)t_L12, null);
        this.checkLockGroupCount(compatibilitySpace, object, 1);
        this.checkLockGroupCount(compatibilitySpace, object2, 2);
        this.checkLockCount(compatibilitySpace, 3);
        this.lf.unlockGroup(compatibilitySpace, object2);
        this.checkLockGroupCount(compatibilitySpace, object, 1);
        this.checkLockGroupCount(compatibilitySpace, object2, 0);
        this.checkLockCount(compatibilitySpace, 1);
        this.lf.unlockGroup(compatibilitySpace, object);
        this.checkLockGroupCount(compatibilitySpace, object, 0);
        this.checkLockGroupCount(compatibilitySpace, object2, 0);
        this.checkLockCount(compatibilitySpace, 0);
        this.PASS("S003");
    }

    void S004() throws StandardException, T_Fail {
        CompatibilitySpace compatibilitySpace = this.lf.createCompatibilitySpace(null);
        Object object = new Object();
        Object object2 = new Object();
        Object object3 = new Object();
        T_L1 t_L1 = new T_L1();
        T_L1 t_L12 = new T_L1();
        T_L1 t_L13 = new T_L1();
        boolean bl = false;
        this.checkLockCount(compatibilitySpace, 0);
        this.lf.lockObject(compatibilitySpace, object, (Lockable)t_L1, null, -1);
        this.lf.lockObject(compatibilitySpace, object2, (Lockable)t_L1, null, -1);
        this.lf.lockObject(compatibilitySpace, object2, (Lockable)t_L12, null, -1);
        this.lf.lockObject(compatibilitySpace, object2, (Lockable)t_L13, null, -1);
        this.checkLockGroupCount(compatibilitySpace, object, 1);
        this.checkLockGroupCount(compatibilitySpace, object2, 3);
        this.checkLockCount(compatibilitySpace, 4);
        this.lf.transfer(compatibilitySpace, object, object2);
        this.checkLockGroupCount(compatibilitySpace, object, 0);
        this.checkLockGroupCount(compatibilitySpace, object2, 4);
        this.checkLockCount(compatibilitySpace, 4);
        this.lf.transfer(compatibilitySpace, object, object3);
        this.checkLockGroupCount(compatibilitySpace, object, 0);
        this.checkLockGroupCount(compatibilitySpace, object2, 4);
        this.checkLockGroupCount(compatibilitySpace, object3, 0);
        this.checkLockCount(compatibilitySpace, 4);
        this.lf.lockObject(compatibilitySpace, object3, (Lockable)t_L1, null, -1);
        this.checkLockGroupCount(compatibilitySpace, object3, 1);
        this.checkLockCount(compatibilitySpace, 5);
        this.lf.transfer(compatibilitySpace, object2, object3);
        this.checkLockGroupCount(compatibilitySpace, object2, 0);
        this.checkLockGroupCount(compatibilitySpace, object3, 5);
        this.checkLockCount(compatibilitySpace, 5);
        this.lf.transfer(compatibilitySpace, object3, object2);
        this.checkLockGroupCount(compatibilitySpace, object2, 5);
        this.checkLockGroupCount(compatibilitySpace, object3, 0);
        this.checkLockCount(compatibilitySpace, 5);
        this.lf.unlockGroup(compatibilitySpace, object3);
        this.checkLockGroupCount(compatibilitySpace, object2, 5);
        this.checkLockGroupCount(compatibilitySpace, object3, 0);
        this.checkLockCount(compatibilitySpace, 5);
        this.lf.unlockGroup(compatibilitySpace, object2);
        this.checkLockGroupCount(compatibilitySpace, object2, 0);
        this.checkLockGroupCount(compatibilitySpace, object3, 0);
        this.checkLockCount(compatibilitySpace, 0);
        this.PASS("S004");
    }

    void S005() throws StandardException, T_Fail {
        CompatibilitySpace compatibilitySpace = this.lf.createCompatibilitySpace(null);
        CompatibilitySpace compatibilitySpace2 = this.lf.createCompatibilitySpace(null);
        Object object = new Object();
        Object object2 = new Object();
        T_L1 t_L1 = new T_L1();
        T_L1 t_L12 = new T_L1();
        T_L1 t_L13 = new T_L1();
        this.checkLockCount(compatibilitySpace, 0);
        this.checkLockCount(compatibilitySpace2, 0);
        this.lf.lockObject(compatibilitySpace, object, (Lockable)t_L1, null, -1);
        this.lf.lockObject(compatibilitySpace2, object2, (Lockable)t_L12, null, -1);
        this.checkLockCount(compatibilitySpace, 1);
        this.checkLockCount(compatibilitySpace2, 1);
        this.lf.lockObject(compatibilitySpace, object, (Lockable)t_L13, null, -1);
        this.checkLockCount(compatibilitySpace, 2);
        this.checkLockCount(compatibilitySpace2, 1);
        try {
            this.lf.lockObject(compatibilitySpace2, object2, (Lockable)t_L13, null, 200);
            throw T_Fail.testFailMsg("lock succeeded on already locked object");
        }
        catch (StandardException standardException) {
            if (!standardException.getMessageId().equals("40XL1")) {
                throw standardException;
            }
            this.checkLockCount(compatibilitySpace, 2);
            this.checkLockCount(compatibilitySpace2, 1);
            this.lf.unlock(compatibilitySpace, object, (Lockable)t_L13, null);
            this.checkLockCount(compatibilitySpace, 1);
            this.checkLockCount(compatibilitySpace2, 1);
            this.lf.lockObject(compatibilitySpace2, object2, (Lockable)t_L13, null, -1);
            this.checkLockCount(compatibilitySpace, 1);
            this.checkLockCount(compatibilitySpace2, 2);
            this.lf.unlockGroup(compatibilitySpace, object);
            this.lf.unlockGroup(compatibilitySpace2, object2);
            this.checkLockCount(compatibilitySpace, 0);
            this.checkLockCount(compatibilitySpace2, 0);
            this.PASS("S005");
            return;
        }
    }

    void S007() throws StandardException, T_Fail {
        CompatibilitySpace compatibilitySpace = this.lf.createCompatibilitySpace(null);
        Object object = new Object();
        Object object2 = new Object();
        T_L1 t_L1 = new T_L1();
        this.checkLockCount(compatibilitySpace, 0);
        this.checkLockGroupCount(compatibilitySpace, object, 0);
        this.lf.unlockGroup(compatibilitySpace, object);
        this.lf.unlockGroup(compatibilitySpace, (Object)compatibilitySpace);
        this.lf.unlock(compatibilitySpace, object, (Lockable)t_L1, null);
        this.lf.transfer(compatibilitySpace, object, object2);
        this.lf.transfer(compatibilitySpace, object2, object);
        if (this.lf.anyoneBlocked()) {
            throw T_Fail.testFailMsg("anyoneBlocked() returned true on an empty space");
        }
        this.checkLockCount(compatibilitySpace, 0);
        this.checkLockGroupCount(compatibilitySpace, object, 0);
        this.checkLockGroupCount(compatibilitySpace, object2, 0);
        this.PASS("S007");
    }

    void M001() throws StandardException, T_Fail {
        Lockable[] lockableArray = new T_L1[]{new T_L1(), new T_L1()};
        T_User t_User = new T_User(1, this.lf, lockableArray, 100L, 1000L);
        T_User t_User2 = new T_User(1, this.lf, lockableArray, 100L, 2000L);
        Thread thread = new Thread(t_User);
        Thread thread2 = new Thread(t_User2);
        thread.start();
        thread2.start();
        try {
            thread.join();
            thread2.join();
        }
        catch (InterruptedException interruptedException) {
            throw T_Fail.exceptionFail(interruptedException);
        }
        if (t_User.error != null) {
            throw T_Fail.exceptionFail(t_User.error);
        }
        if (t_User2.error != null) {
            throw T_Fail.exceptionFail(t_User2.error);
        }
        this.PASS("M001");
    }

    void M002() throws StandardException, T_Fail {
        Lockable[] lockableArray = new T_L1[]{new T_L1()};
        T_User t_User = new T_User(2, this.lf, lockableArray, 100L, 1000L);
        T_User t_User2 = new T_User(2, this.lf, lockableArray, 100L, 2000L);
        T_User t_User3 = new T_User(2, this.lf, lockableArray, 100L, 3000L);
        Thread thread = new Thread(t_User);
        Thread thread2 = new Thread(t_User2);
        Thread thread3 = new Thread(t_User3);
        thread.start();
        thread2.start();
        thread3.start();
        try {
            thread.join();
            thread2.join();
            thread3.join();
        }
        catch (InterruptedException interruptedException) {
            throw T_Fail.exceptionFail(interruptedException);
        }
        if (t_User.error != null) {
            throw T_Fail.exceptionFail(t_User.error);
        }
        if (t_User2.error != null) {
            throw T_Fail.exceptionFail(t_User2.error);
        }
        if (t_User3.error != null) {
            throw T_Fail.exceptionFail(t_User3.error);
        }
        this.PASS("M002");
    }

    void M003() throws StandardException, T_Fail {
        Lockable[] lockableArray = new Lockable[]{new T_L2(2)};
        T_User t_User = new T_User(3, this.lf, lockableArray, 100L, 0L);
        T_User t_User2 = new T_User(3, this.lf, lockableArray, 100L, 0L);
        T_User t_User3 = new T_User(3, this.lf, lockableArray, 100L, 0L);
        Thread thread = new Thread(t_User);
        Thread thread2 = new Thread(t_User2);
        Thread thread3 = new Thread(t_User3);
        thread.start();
        thread2.start();
        thread3.start();
        try {
            thread.join();
            thread2.join();
            thread3.join();
        }
        catch (InterruptedException interruptedException) {
            throw T_Fail.exceptionFail(interruptedException);
        }
        if (t_User.error != null) {
            throw T_Fail.exceptionFail(t_User.error);
        }
        if (t_User2.error != null) {
            throw T_Fail.exceptionFail(t_User2.error);
        }
        if (t_User3.error != null) {
            throw T_Fail.exceptionFail(t_User3.error);
        }
        this.PASS("M003");
    }

    void M004() throws StandardException, T_Fail {
        Lockable[] lockableArray = new Lockable[]{new T_L2(2)};
        T_User t_User = new T_User(4, this.lf, lockableArray, 100L, 0L);
        T_User t_User2 = new T_User(4, this.lf, lockableArray, 100L, 0L);
        T_User t_User3 = new T_User(4, this.lf, lockableArray, 100L, 0L);
        Thread thread = new Thread(t_User);
        Thread thread2 = new Thread(t_User2);
        Thread thread3 = new Thread(t_User3);
        thread.start();
        thread2.start();
        thread3.start();
        try {
            thread.join();
            thread2.join();
            thread3.join();
        }
        catch (InterruptedException interruptedException) {
            throw T_Fail.exceptionFail(interruptedException);
        }
        if (t_User.error != null) {
            throw T_Fail.exceptionFail(t_User.error);
        }
        if (t_User2.error != null) {
            throw T_Fail.exceptionFail(t_User2.error);
        }
        if (t_User3.error != null) {
            throw T_Fail.exceptionFail(t_User3.error);
        }
        this.PASS("M004");
    }

    void checkLockCount(CompatibilitySpace compatibilitySpace, int n) throws T_Fail {
        boolean bl = n != 0;
        boolean bl2 = this.lf.areLocksHeld(compatibilitySpace);
        if (bl2 != bl) {
            throw T_Fail.testFailMsg("Expected lock count (" + bl + "), got (" + bl2 + ")");
        }
    }

    void checkLockGroupCount(CompatibilitySpace compatibilitySpace, Object object, int n) throws T_Fail {
        boolean bl = n != 0;
        boolean bl2 = this.lf.areLocksHeld(compatibilitySpace, object);
        if (bl2 != bl) {
            throw T_Fail.testFailMsg("Expected lock count (" + bl + "), got (" + bl2 + ")");
        }
    }

    private static Object startSystemModule(String string) throws StandardException {
        return Monitor.startSystemModule((String)string);
    }
}

