/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.services;

import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.services.T_L1;

class T_User
implements Runnable {
    private LockFactory lf;
    private Lockable[] refs;
    private long iterations;
    private long offset;
    private int test;
    Throwable error = null;

    T_User(int n, LockFactory lockFactory, Lockable[] lockableArray, long l, long l2) {
        this.lf = lockFactory;
        this.refs = lockableArray;
        this.iterations = l;
        this.test = n;
        this.offset = l2;
    }

    @Override
    public void run() {
        try {
            switch (this.test) {
                case 1: {
                    this.T001();
                    break;
                }
                case 2: {
                    this.T002();
                    break;
                }
                case 3: {
                    this.T003();
                }
            }
        }
        catch (Throwable throwable) {
            this.error = throwable;
        }
    }

    private void T001() throws StandardException, T_Fail {
        CompatibilitySpace compatibilitySpace = this.lf.createCompatibilitySpace(null);
        Integer n = 1;
        this.checkLockCount(compatibilitySpace, 0);
        while (--this.iterations > 0L) {
            long l = this.offset + this.iterations;
            this.lf.lockObject(compatibilitySpace, (Object)n, this.refs[0], null, -1);
            T_L1 t_L1 = (T_L1)this.refs[0];
            t_L1.value = l;
            this.checkLockCount(compatibilitySpace, 1);
            Thread.yield();
            this.checkValue(t_L1, l);
            this.lf.lockObject(compatibilitySpace, (Object)n, this.refs[1], null, -1);
            t_L1 = (T_L1)this.refs[1];
            t_L1.value = l;
            Thread.yield();
            this.checkValue((T_L1)this.refs[0], l);
            this.checkValue((T_L1)this.refs[1], l);
            this.lf.unlock(compatibilitySpace, (Object)n, this.refs[0], null);
            this.checkValue((T_L1)this.refs[1], l);
            Thread.yield();
            this.lf.unlock(compatibilitySpace, (Object)n, this.refs[1], null);
            this.checkLockCount(compatibilitySpace, 0);
            Thread.yield();
        }
    }

    private void T002() throws StandardException, T_Fail {
        CompatibilitySpace compatibilitySpace = this.lf.createCompatibilitySpace(null);
        Integer n = 1;
        this.checkLockCount(compatibilitySpace, 0);
        while (--this.iterations > 0L) {
            long l = this.offset + this.iterations;
            T_L1 t_L1 = (T_L1)this.refs[0];
            this.lf.lockObject(compatibilitySpace, (Object)n, this.refs[0], null, -1);
            t_L1.value = l;
            this.checkLockCount(compatibilitySpace, 1);
            Thread.yield();
            this.checkValue(t_L1, l);
            this.lf.unlock(compatibilitySpace, (Object)n, this.refs[0], null);
            this.checkLockCount(compatibilitySpace, 0);
        }
    }

    private void T003() throws StandardException, T_Fail {
        CompatibilitySpace compatibilitySpace = this.lf.createCompatibilitySpace(null);
        Integer n = 1;
        this.checkLockCount(compatibilitySpace, 0);
        while (--this.iterations > 0L) {
            this.lf.lockObject(compatibilitySpace, (Object)n, this.refs[0], null, -1);
            this.checkLockCount(compatibilitySpace, 1);
            Thread.yield();
            this.lf.unlock(compatibilitySpace, (Object)n, this.refs[0], null);
            this.checkLockCount(compatibilitySpace, 0);
        }
    }

    private void T004() throws StandardException, T_Fail {
        CompatibilitySpace compatibilitySpace = this.lf.createCompatibilitySpace(null);
        Integer n = 1;
        this.checkLockCount(compatibilitySpace, 0);
        while (--this.iterations > 0L) {
            this.lf.lockObject(compatibilitySpace, (Object)n, this.refs[0], null, -1);
            this.checkLockCount(compatibilitySpace, 1);
            Thread.yield();
            this.lf.lockObject(compatibilitySpace, (Object)n, this.refs[0], null, -1);
            this.checkLockCount(compatibilitySpace, 2);
            Thread.yield();
            this.lf.unlockGroup(compatibilitySpace, (Object)n);
            this.checkLockCount(compatibilitySpace, 0);
        }
    }

    private void checkValue(T_L1 t_L1, long l) throws T_Fail {
        if (t_L1.value != l) {
            throw T_Fail.testFailMsg("value corrupted in multi-user test, exapected " + l + ", got " + t_L1.value);
        }
    }

    void checkLockCount(CompatibilitySpace compatibilitySpace, int n) throws T_Fail {
        boolean bl = n != 0;
        boolean bl2 = this.lf.areLocksHeld(compatibilitySpace);
        if (bl2 != bl) {
            throw T_Fail.testFailMsg("Expected lock count (" + bl + "), got (" + bl2 + ")");
        }
    }
}

