/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BlobStoredProcedureTest
extends BaseJDBCTestCase {
    final String testStr = "I am a simple derby test case";
    final long testStrLength = "I am a simple derby test case".length();

    public BlobStoredProcedureTest(String string) {
        super(string);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("empty: client not supported on JSR169; procs use DriverMgr");
        }
        return TestConfiguration.defaultSuite(BlobStoredProcedureTest.class);
    }

    protected void setUp() throws SQLException, UnsupportedEncodingException {
        byte[] byArray = "I am a simple derby test case".getBytes("US-ASCII");
        int n = -1;
        this.getConnection().setAutoCommit(false);
        CallableStatement callableStatement = this.prepareCall("? = CALL SYSIBM.BLOBCREATELOCATOR()");
        callableStatement.registerOutParameter(1, 4);
        callableStatement.executeUpdate();
        n = callableStatement.getInt(1);
        callableStatement.close();
        callableStatement = this.prepareCall("CALL SYSIBM.BLOBSETBYTES(?,?,?,?)");
        callableStatement.setInt(1, n);
        callableStatement.setLong(2, 1L);
        callableStatement.setInt(3, (int)this.testStrLength);
        callableStatement.setBytes(4, byArray);
        callableStatement.execute();
        callableStatement.close();
    }

    @Override
    protected void tearDown() throws Exception {
        this.commit();
        super.tearDown();
    }

    public void testBlobGetBytesSP() throws SQLException, UnsupportedEncodingException {
        String string = "I am a simple derby test case".substring(0, 10);
        byte[] byArray = string.getBytes("US-ASCII");
        CallableStatement callableStatement = this.prepareCall("? = CALL SYSIBM.BLOBGETBYTES(?,?,?)");
        callableStatement.registerOutParameter(1, -3);
        callableStatement.setInt(2, 1);
        callableStatement.setLong(3, 1L);
        callableStatement.setInt(4, 10);
        callableStatement.executeUpdate();
        byte[] byArray2 = callableStatement.getBytes(1);
        for (int i = 0; i < 10; ++i) {
            BlobStoredProcedureTest.assertEquals((String)"The Stored procedure SYSIBM.BLOBGETBYTES returns the wrong bytes", (byte)byArray[i], (byte)byArray2[i]);
        }
        callableStatement.close();
    }

    public void testBlobCreateLocatorSP() throws SQLException {
        int n = -1;
        CallableStatement callableStatement = this.prepareCall("? = CALL SYSIBM.BLOBCREATELOCATOR()");
        callableStatement.registerOutParameter(1, 4);
        callableStatement.executeUpdate();
        n = callableStatement.getInt(1);
        BlobStoredProcedureTest.assertEquals((String)"The locator values returned by SYSIBM.BLOBCREATELOCATOR() are incorrect", (int)2, (int)n);
        callableStatement.close();
    }

    public void testBlobReleaseLocatorSP() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL SYSIBM.BLOBRELEASELOCATOR(?)");
        callableStatement.setInt(1, 1);
        callableStatement.execute();
        callableStatement.close();
        callableStatement = this.prepareCall("? = CALL SYSIBM.BLOBGETLENGTH(?)");
        callableStatement.registerOutParameter(1, -5);
        callableStatement.setInt(2, 1);
        try {
            callableStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            return;
        }
        BlobStoredProcedureTest.fail((String)"Error the locator was not released by SYSIBM.BLOBRELEASELOCATOR");
        callableStatement.close();
    }

    public void testBlobGetLengthSP() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("? = CALL SYSIBM.BLOBGETLENGTH(?)");
        callableStatement.registerOutParameter(1, -5);
        callableStatement.setInt(2, 1);
        callableStatement.executeUpdate();
        BlobStoredProcedureTest.assertEquals((String)"Error SYSIBM.BLOBGETLENGTH returns the wrong value for the length of the Blob", (long)this.testStrLength, (long)callableStatement.getLong(1));
        callableStatement.close();
    }

    public void testBlobGetPositionFromBytesSP() throws Exception {
        CallableStatement callableStatement = this.prepareCall("? = CALL SYSIBM.BLOBGETPOSITIONFROMBYTES(?,?,?)");
        callableStatement.registerOutParameter(1, -5);
        callableStatement.setInt(2, 1);
        callableStatement.setBytes(3, new String("simple").getBytes("US-ASCII"));
        callableStatement.setLong(4, 1L);
        callableStatement.executeUpdate();
        BlobStoredProcedureTest.assertEquals((String)"Error SYSIBM.BLOBGETPOSITIONFROMBYTES returns the wrong value for the position of the Blob", (long)8L, (long)callableStatement.getLong(1));
        callableStatement.close();
    }

    public void testBlobSetBytes() throws SQLException, UnsupportedEncodingException {
        String string = "123456789012345";
        byte[] byArray = string.getBytes("US-ASCII");
        int n = -1;
        CallableStatement callableStatement = this.prepareCall("? = CALL SYSIBM.BLOBCREATELOCATOR()");
        callableStatement.registerOutParameter(1, 4);
        callableStatement.executeUpdate();
        n = callableStatement.getInt(1);
        callableStatement.close();
        callableStatement = this.prepareCall("CALL SYSIBM.BLOBSETBYTES(?,?,?,?)");
        callableStatement.setInt(1, n);
        callableStatement.setLong(2, 1L);
        callableStatement.setInt(3, string.length());
        callableStatement.setBytes(4, byArray);
        callableStatement.execute();
        callableStatement.close();
        callableStatement = this.prepareCall("? = CALL SYSIBM.BLOBGETBYTES(?,?,?)");
        callableStatement.registerOutParameter(1, -3);
        callableStatement.setInt(2, n);
        callableStatement.setLong(3, 1L);
        callableStatement.setInt(4, string.length());
        callableStatement.executeUpdate();
        byte[] byArray2 = callableStatement.getBytes(1);
        for (int i = 0; i < string.length(); ++i) {
            BlobStoredProcedureTest.assertEquals((String)"The Stored procedure SYSIBM.BLOBGETBYTES returns the wrong bytes", (byte)byArray[i], (byte)byArray2[i]);
        }
        callableStatement.close();
    }

    public void testBlobTruncateSP() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL SYSIBM.BLOBTRUNCATE(?,?)");
        callableStatement.setInt(1, 1);
        callableStatement.setLong(2, 10L);
        callableStatement.execute();
        callableStatement.close();
        callableStatement = this.prepareCall("? = CALL SYSIBM.BLOBGETLENGTH(?)");
        callableStatement.registerOutParameter(1, -5);
        callableStatement.setInt(2, 1);
        callableStatement.executeUpdate();
        BlobStoredProcedureTest.assertEquals((String)"Error SYSIBM.BLOBGETLENGTH returns the wrong value for the length of the Blob", (long)10L, (long)callableStatement.getLong(1));
        callableStatement.close();
    }

    public void testBlobGetPositionFromLocatorSP() throws SQLException, UnsupportedEncodingException {
        String string = "simple";
        byte[] byArray = string.getBytes("US-ASCII");
        int n = -1;
        CallableStatement callableStatement = this.prepareCall("? = CALL SYSIBM.BLOBCREATELOCATOR()");
        callableStatement.registerOutParameter(1, 4);
        callableStatement.executeUpdate();
        n = callableStatement.getInt(1);
        callableStatement.close();
        callableStatement = this.prepareCall("CALL SYSIBM.BLOBSETBYTES(?,?,?,?)");
        callableStatement.setInt(1, n);
        callableStatement.setLong(2, 1L);
        callableStatement.setInt(3, string.length());
        callableStatement.setBytes(4, byArray);
        callableStatement.execute();
        callableStatement.close();
        callableStatement = this.prepareCall("? = CALL SYSIBM.BLOBGETPOSITIONFROMLOCATOR(?,?,?)");
        callableStatement.registerOutParameter(1, -5);
        callableStatement.setInt(2, 1);
        callableStatement.setInt(3, n);
        callableStatement.setLong(4, 1L);
        callableStatement.executeUpdate();
        BlobStoredProcedureTest.assertEquals((String)"Error SYSIBM.BLOBGETPOSITIONFROMLOCATOR returns the wrong value for the position of the Blob", (long)8L, (long)callableStatement.getLong(1));
        callableStatement.close();
    }
}

