/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class NullSQLTextTest
extends BaseJDBCTestCase {
    private static String SQLSTATE_SYNTAX_ERROR = "42X01";

    public NullSQLTextTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("NullSQLTextTest");
        baseTestSuite.addTest(NullSQLTextTest.baseSuite("NullSQLTextTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(NullSQLTextTest.baseSuite("NullSQLTextTest:client")));
        return baseTestSuite;
    }

    private static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(NullSQLTextTest.class);
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                Connection connection = this.getConnection();
                statement.execute("create table t1 (i int)");
                statement.execute("insert into t1 values 1, 2, 3, 4, 5, 6, 7");
                statement.execute("create procedure za() language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.NullSQLTextTest.zeroArg' parameter style java");
            }
        };
    }

    public void testNullStringPreparedStatement() throws SQLException {
        String string = null;
        try {
            PreparedStatement preparedStatement = this.prepareStatement(string);
            NullSQLTextTest.fail((String)"preparedStatement(nullString) should have failed.");
        }
        catch (SQLException sQLException) {
            NullSQLTextTest.assertSQLState("XJ067", sQLException);
        }
    }

    public void testNullStringExecuteStatement() throws SQLException {
        String string = null;
        try {
            Statement statement = this.createStatement();
            statement.execute(string);
            NullSQLTextTest.fail((String)"execute(nullString) should have failed.");
        }
        catch (SQLException sQLException) {
            NullSQLTextTest.assertSQLState("XJ067", sQLException);
        }
    }

    public void testNullStringExecuteQueryStatement() throws SQLException {
        String string = null;
        try {
            Statement statement = this.createStatement();
            statement.executeQuery(string);
            NullSQLTextTest.fail((String)"executeQuery(nullString) should have failed.");
        }
        catch (SQLException sQLException) {
            NullSQLTextTest.assertSQLState("XJ067", sQLException);
        }
    }

    public void testNullStringExecuteUpdateStatement() throws SQLException {
        String string = null;
        try {
            Statement statement = this.createStatement();
            statement.executeUpdate(string);
            NullSQLTextTest.fail((String)"executeUpdate(nullString) should have failed.");
        }
        catch (SQLException sQLException) {
            NullSQLTextTest.assertSQLState("XJ067", sQLException);
        }
    }

    public void testDerby522() throws SQLException {
        Statement statement = this.createStatement();
        NullSQLTextTest.testCommentStmt(statement, " --", true);
        NullSQLTextTest.testCommentStmt(statement, " -- ", true);
        NullSQLTextTest.testCommentStmt(statement, " -- This is a comment \n --", true);
        NullSQLTextTest.testCommentStmt(statement, " -- This is a comment\n --And another\n -- Andonemore", true);
        NullSQLTextTest.testCommentStmt(statement, " --\nvalues 2, 4, 8", false);
        ResultSet resultSet = statement.getResultSet();
        String[][] stringArray = new String[][]{{"2"}, {"4"}, {"8"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        NullSQLTextTest.testCommentStmt(statement, " -- This is \n -- \n --3 comments\nvalues 8", false);
        resultSet = statement.getResultSet();
        stringArray = new String[][]{{"8"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        NullSQLTextTest.testCommentStmt(statement, " -- This is a comment\n --And another\n -- Andonemore\nvalues (2,3)", false);
        resultSet = statement.getResultSet();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        stringArray = new String[][]{{"2", "3"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        NullSQLTextTest.testCommentStmt(statement, " -- This is a comment\n select i from t1", false);
        resultSet = statement.getResultSet();
        stringArray = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}, {"7"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        NullSQLTextTest.testCommentStmt(statement, " --singleword\n insert into t1 values (8)", false);
        resultSet = statement.getResultSet();
        NullSQLTextTest.assertNull((String)"Unexpected Not Null ResultSet", (Object)resultSet);
        NullSQLTextTest.testCommentStmt(statement, " --singleword\ncall za()", false);
        NullSQLTextTest.assertNull((String)"Unexpected Not Null ResultSet", (Object)resultSet);
        NullSQLTextTest.testCommentStmt(statement, " -- leading comment\n(\nvalues 4, 8)", false);
        resultSet = statement.getResultSet();
        stringArray = new String[][]{{"4"}, {"8"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        NullSQLTextTest.testCommentStmt(statement, " -- leading comment\n\n(\n\n\rvalues 4, 8)", false);
        resultSet = statement.getResultSet();
        stringArray = new String[][]{{"4"}, {"8"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        NullSQLTextTest.testCommentStmt(statement, "select i from t1 -- This is a comment", false);
        resultSet = statement.getResultSet();
        stringArray = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}, {"7"}, {"8"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        NullSQLTextTest.testCommentStmt(statement, "select i from t1\n -- This is a comment", false);
        resultSet = statement.getResultSet();
        stringArray = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}, {"7"}, {"8"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        NullSQLTextTest.testCommentStmt(statement, "values 8, 4, 2\n --", false);
        resultSet = statement.getResultSet();
        stringArray = new String[][]{{"8"}, {"4"}, {"2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        NullSQLTextTest.testCommentStmt(statement, "values 8, 4,\n -- middle comment\n2\n -- end", false);
        resultSet = statement.getResultSet();
        stringArray = new String[][]{{"8"}, {"4"}, {"2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        NullSQLTextTest.testCommentStmt(statement, "values 8, 4,\n -- middle comment\n2\n -- end\n", false);
        resultSet = statement.getResultSet();
        stringArray = new String[][]{{"8"}, {"4"}, {"2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
    }

    private static void testCommentStmt(Statement statement, String string, boolean bl) throws SQLException {
        try {
            statement.execute(string);
            if (bl) {
                NullSQLTextTest.fail((String)"Unexpected Failure -- execute() should have failed.");
            }
        }
        catch (SQLException sQLException) {
            NullSQLTextTest.assertSQLState("42X01", sQLException);
        }
    }

    public static void zeroArg() {
    }

    public void testExecuteEmptyString() throws SQLException {
        try {
            this.createStatement().execute("");
            NullSQLTextTest.fail((String)"Statement expected to fail");
        }
        catch (SQLException sQLException) {
            NullSQLTextTest.assertSQLState(SQLSTATE_SYNTAX_ERROR, sQLException);
        }
    }

    public void testExecuteUpdateEmptyString() {
        try {
            this.createStatement().executeUpdate("");
            NullSQLTextTest.fail((String)"Statement expected to fail");
        }
        catch (SQLException sQLException) {
            NullSQLTextTest.assertSQLState(SQLSTATE_SYNTAX_ERROR, sQLException);
        }
    }

    public void testExecuteQueryEmptyString() {
        try {
            this.createStatement().executeQuery("");
            NullSQLTextTest.fail((String)"Statement expected to fail");
        }
        catch (SQLException sQLException) {
            NullSQLTextTest.assertSQLState(SQLSTATE_SYNTAX_ERROR, sQLException);
        }
    }

    public void testPrepareEmptyString() {
        try {
            this.prepareStatement("");
            NullSQLTextTest.fail((String)"Statement expected to fail");
        }
        catch (SQLException sQLException) {
            NullSQLTextTest.assertSQLState(SQLSTATE_SYNTAX_ERROR, sQLException);
        }
    }
}

