/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RelativeTest
extends BaseJDBCTestCase {
    public RelativeTest(String string) {
        super(string);
    }

    public void testScrolling_CONCUR_READ_ONLY() throws SQLException {
        int n = 1007;
        Statement statement = this.createStatement(1004, n);
        ResultSet resultSet = statement.executeQuery("select * from testRelative");
        resultSet.next();
        RelativeTest.assertEquals((String)"work1", (String)resultSet.getString("name"));
        resultSet.relative(2);
        RelativeTest.assertEquals((String)"work3", (String)resultSet.getString("name"));
        RelativeTest.assertEquals((boolean)false, (boolean)resultSet.isFirst());
        RelativeTest.assertEquals((boolean)false, (boolean)resultSet.isLast());
        RelativeTest.assertEquals((boolean)false, (boolean)resultSet.isAfterLast());
        resultSet.relative(-2);
        RelativeTest.assertEquals((String)"work1", (String)resultSet.getString("name"));
        resultSet.relative(10);
        try {
            resultSet.getString("name");
            RelativeTest.fail((String)"FAIL - Attempting to read from an invalid row should have thrown an exception");
        }
        catch (SQLException sQLException) {
            String string = "";
            string = RelativeTest.usingDerbyNetClient() ? "XJ121" : "24000";
            RelativeTest.assertSQLState(string, sQLException);
        }
    }

    public void testScrolling_CONCUR_UPDATABLE() throws SQLException {
        int n = 1008;
        Statement statement = this.createStatement(1004, n);
        ResultSet resultSet = statement.executeQuery("select * from testRelative");
        resultSet.next();
        RelativeTest.assertEquals((String)"work1", (String)resultSet.getString("name"));
        resultSet.relative(2);
        RelativeTest.assertEquals((String)"work3", (String)resultSet.getString("name"));
        RelativeTest.assertEquals((boolean)false, (boolean)resultSet.isFirst());
        RelativeTest.assertEquals((boolean)false, (boolean)resultSet.isLast());
        RelativeTest.assertEquals((boolean)false, (boolean)resultSet.isAfterLast());
        resultSet.relative(-2);
        RelativeTest.assertEquals((String)"work1", (String)resultSet.getString("name"));
        resultSet.relative(10);
        try {
            resultSet.getString("name");
            RelativeTest.fail((String)"FAIL - Attempting to read from an invalid row should have thrown an exception");
        }
        catch (SQLException sQLException) {
            String string = "";
            string = RelativeTest.usingDerbyNetClient() ? "XJ121" : "24000";
            RelativeTest.assertSQLState(string, sQLException);
        }
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("RelativeTest");
        baseTestSuite.addTest(RelativeTest.baseSuite("RelativeTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(RelativeTest.baseSuite("RelativeTest:client")));
        return baseTestSuite;
    }

    private static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(RelativeTest.class);
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts((Test)baseTestSuite, 2, 4)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create table testRelative(name varchar(10), i int)");
                statement.execute("insert into testRelative values ('work1', NULL)");
                statement.execute("insert into testRelative values ('work2', NULL)");
                statement.execute("insert into testRelative values ('work3', NULL)");
                statement.execute("insert into testRelative values ('work4', NULL)");
            }
        };
    }
}

