/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class OptimizerOverridesTest
extends BaseJDBCTestCase {
    private static final String[][] FULL_TABLE = new String[][]{{"1", "1", "1"}, {"2", "2", "2"}, {"3", "3", "3"}, {"4", "4", "4"}};

    public OptimizerOverridesTest(String string) {
        super(string);
    }

    public static Test suite() {
        Object object = TestConfiguration.defaultSuite(OptimizerOverridesTest.class, false);
        object = new CleanDatabaseTestSetup((Test)object){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.getConnection().setAutoCommit(false);
                statement.addBatch("create table t1 (c1 int, c2 int, c3 int, constraint cons1 primary key(c1, c2))");
                statement.addBatch("create table t2 (c1 int not null, c2 int not null, c3 int, constraint cons2 unique(c1, c2))");
                statement.addBatch("insert into t1 values (1, 1, 1), (2, 2, 2), (3, 3, 3), (4, 4, 4)");
                statement.addBatch("insert into t2 values (1, 1, 1), (2, 2, 2), (3, 3, 3), (4, 4, 4)");
                statement.addBatch("create index t1_c1c2c3 on t1(c1, c2, c3)");
                statement.addBatch("create index t1_c3c2c1 on t1(c3, c2, c1)");
                statement.addBatch("create index t1_c1 on t1(c1)");
                statement.addBatch("create index t1_c2 on t1(c2)");
                statement.addBatch("create index t1_c3 on t1(c3)");
                statement.addBatch("create index \"t1_c2c1\" on t1(c2, c1)");
                statement.addBatch("create index t2_c1c2c3 on t2(c1, c2, c3)");
                statement.addBatch("create index t2_c3c2c1 on t2(c3, c2, c1)");
                statement.addBatch("create index t2_c1 on t2(c1)");
                statement.addBatch("create index t2_c2 on t2(c2)");
                statement.addBatch("create index t2_c3 on t2(c3)");
                statement.addBatch("create view v1 as select * from t1 --derby-properties index = t1_c1");
                statement.addBatch("create view v2 as select t1.* from t1, t2");
                statement.addBatch("create view v3 as select * from v1");
                statement.addBatch("create view neg_v1 as select * from t1 --derby-properties asdf = fdsa");
                statement.executeBatch();
            }
        };
        return object;
    }

    public void testBadFormats() throws SQLException {
        Statement statement = this.createStatement();
        OptimizerOverridesTest.assertStatementError("42X01", statement, "select \n-- derby-properties index = t1_c1 \n* from t1");
        OptimizerOverridesTest.assertStatementError("42X01", statement, "select * -- derby-properties index = t1_c1 \nfrom t1");
        OptimizerOverridesTest.assertStatementError("42X01", statement, "select * -- derby-properties\n index = t1_c1 from t1");
        statement.close();
    }

    public void testBadProperties() throws SQLException {
        Statement statement = this.createStatement();
        OptimizerOverridesTest.assertStatementError("42Y44", statement, "select * from t1 --derby-properties asdf = i1");
        OptimizerOverridesTest.assertStatementError("42Y44", statement, "select * from t1 exposedname --derby-properties asdf = i1");
        OptimizerOverridesTest.assertStatementError("42Y44", statement, "select * from neg_v1");
        OptimizerOverridesTest.assertStatementError("42Y44", statement, "select * from t1 --derby-properties i = a\nleft outer join t2 on 1=1");
        OptimizerOverridesTest.assertStatementError("42Y44", statement, "select * from t1 left outer join t2 --derby-properties i = t1_c1\n on 1=1");
        OptimizerOverridesTest.assertStatementError("42Y46", statement, "select * from t1 left outer join t2 --derby-properties index = t1_c1\n on 1=1");
        OptimizerOverridesTest.assertStatementError("42Y46", statement, "select * from t1 right outer join t2 --derby-properties index = t1_c1\n on 1=1");
        statement.close();
    }

    public void testNonExistingPropertyValues() throws SQLException {
        Statement statement = this.createStatement();
        OptimizerOverridesTest.assertStatementError("42Y46", statement, "select * from t1 --derby-properties index = t1_notexists");
        OptimizerOverridesTest.assertStatementError("42Y46", statement, "select * from t1 exposedname --derby-properties index = t1_notexists");
        OptimizerOverridesTest.assertStatementError("42Y48", statement, "select * from t1 --derby-properties constraint = t1_notexists");
        OptimizerOverridesTest.assertStatementError("42Y48", statement, "select * from t1 exposedname --derby-properties constraint = t1_notexists");
        OptimizerOverridesTest.assertStatementError("42Y56", statement, "select * from t1 a, t1 b --derby-properties joinStrategy = asdf");
        statement.close();
    }

    public void testFragmentsAsComments() throws SQLException {
        String[] stringArray = new String[]{"--d", "-- de", "-- der", "--derb", "--derby comment", "-- derby another comment", "--derby-", "--derby-p", "--derby-pr", "--derby-pro", "--derby-prop", "--derby-prope", "--derby-proper", "-- derby-propert", "-- derby-properti", "-- derby-propertie", "-- derby-propertiex"};
        Statement statement = this.createStatement();
        for (int i = 0; i < stringArray.length; ++i) {
            JDBC.assertFullResultSet(statement.executeQuery(stringArray[i] + "\n VALUES 1 "), new String[][]{{"1"}});
        }
        statement.close();
    }

    public void testMixedIndexAndConstraint() throws SQLException {
        Statement statement = this.createStatement();
        OptimizerOverridesTest.assertStatementError("42Y50", statement, "select * from t1 --derby-properties index = t1_c1, constraint = cons1");
        OptimizerOverridesTest.assertStatementError("42Y50", statement, "select * from t1 exposedname --derby-properties index = t1_c1, constraint = cons1");
        statement.close();
    }

    public void testPropertyForUpdate() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        JDBC.assertFullResultSet(statement.executeQuery("select * from t1 --derby-properties index = t1_c1\nfor update"), FULL_TABLE);
        JDBC.assertFullResultSet(statement.executeQuery("select * from t1 exposedname --derby-properties index = t1_c1\nfor update"), FULL_TABLE);
        JDBC.assertFullResultSet(statement.executeQuery("select * from t1 --derby-properties index = t1_c1\nfor update of c2, c1"), FULL_TABLE);
        JDBC.assertFullResultSet(statement.executeQuery("select * from t1 exposedname --derby-properties index = t1_c1\nfor update of c2, c1"), FULL_TABLE);
        JDBC.assertFullResultSet(statement.executeQuery("select * from t1 --derby-properties constraint = cons1\nfor update"), FULL_TABLE);
        JDBC.assertFullResultSet(statement.executeQuery("select * from t1 exposedname --derby-properties constraint = cons1\nfor update"), FULL_TABLE);
        JDBC.assertFullResultSet(statement.executeQuery("select * from t1 --derby-properties constraint = cons1\nfor update of c2, c1"), FULL_TABLE);
        JDBC.assertFullResultSet(statement.executeQuery("select * from t1 exposedname --derby-properties constraint = cons1\nfor update of c2, c1"), FULL_TABLE);
        statement.close();
    }

    public void testInvalidJoinStrategy() throws SQLException {
        Statement statement = this.createStatement();
        OptimizerOverridesTest.assertStatementError("42Y50", statement, "select * from t1 --derby-properties index = t1_c1, constraint = cons1");
        OptimizerOverridesTest.assertStatementError("42Y50", statement, "select * from t1 exposedname --derby-properties index = t1_c1, constraint = cons1");
        statement.close();
    }

    public void testDependenceOnIndex() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select * from t1 --derby-properties index = t1_c1");
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), new String[][]{{"1", "1", "1"}, {"2", "2", "2"}, {"3", "3", "3"}, {"4", "4", "4"}});
        Statement statement = this.createStatement();
        statement.executeUpdate("drop index t1_c1");
        OptimizerOverridesTest.assertStatementError("42Y46", preparedStatement);
        preparedStatement.close();
        statement.executeUpdate("create index t1_c1 on t1(c1)");
        statement.close();
    }

    public void testDependenceOnConstraint() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select * from t1 --derby-properties constraint = cons1");
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), FULL_TABLE);
        Statement statement = this.createStatement();
        statement.executeUpdate("alter table t1 drop constraint cons1");
        OptimizerOverridesTest.assertStatementError("42Y48", preparedStatement);
        statement.executeUpdate("alter table t1 add constraint cons1 primary key(c1, c2)");
        preparedStatement.close();
        statement.close();
    }

    public void testSpell() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t1 --DeRbY-pRoPeRtIeS index = t1_c1"), FULL_TABLE);
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        OptimizerOverridesTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("T1", "T1_C1"));
        JDBC.assertFullResultSet(statement.executeQuery("select * from t1  --DeRbY-pRoPeRtIeAAAA index = t1_c1"), FULL_TABLE);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        OptimizerOverridesTest.assertTrue((String)"not using t1_c1, but what derby thinks is best index.", (boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("T1", "T1_C1C2C3"));
        OptimizerOverridesTest.assertStatementError("42Y44", statement, "select * from t1  --DeRbY-pRoPeRtIeSAAAA index = t1_c1");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t1 --derby-properties index = \"t1_c2c1\""), FULL_TABLE);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        OptimizerOverridesTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("T1", "t1_c2c1"));
        OptimizerOverridesTest.assertStatementError("42Y46", statement, "select * from t1  --DeRbY-pRoPeRtIeS index = t1_notexisting");
        statement.close();
    }

    public void testNullValue() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t1 --derby-properties index = null"), FULL_TABLE);
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        OptimizerOverridesTest.assertTrue((String)"force table scan", (boolean)runtimeStatisticsParser.usedTableScan());
        JDBC.assertFullResultSet(statement.executeQuery("select * from t1 --derby-properties constraint = null"), FULL_TABLE);
        OptimizerOverridesTest.assertStatementError("42Y56", statement, "select * from t1 --derby-properties joinStrategy = null");
        statement.close();
    }

    public void testJoin() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        JDBC.assertFullResultSet(statement.executeQuery("select 1 from t1 a --derby-properties index = t1_c1\n,t2 b --derby-properties index = t2_c2"), new String[][]{{"1"}, {"1"}, {"1"}, {"1"}, {"1"}, {"1"}, {"1"}, {"1"}, {"1"}, {"1"}, {"1"}, {"1"}, {"1"}, {"1"}, {"1"}, {"1"}});
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        OptimizerOverridesTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("T1", "T1_C1"));
        OptimizerOverridesTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("T2", "T2_C2"));
        JDBC.assertFullResultSet(statement.executeQuery("select 1 from  --derby-properties joinOrder=fixed\nt1, t2 where t1.c1 = t2.c1"), new String[][]{{"1"}, {"1"}, {"1"}, {"1"}});
        JDBC.assertFullResultSet(statement.executeQuery("select * from t1 --derby-properties index = t1_c1\nleft outer join t2 --derby-properties index = t2_c2\non t1.c1 = t2.c1"), new String[][]{{"1", "1", "1", "1", "1", "1"}, {"2", "2", "2", "2", "2", "2"}, {"3", "3", "3", "3", "3", "3"}, {"4", "4", "4", "4", "4", "4"}});
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        OptimizerOverridesTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("T1", "T1_C1"));
        OptimizerOverridesTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("T2", "T2_C2"));
        statement.close();
    }

    public void testComparision() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t1 --derby-properties index = t1_c1\nwhere c1 = c1"), FULL_TABLE);
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        OptimizerOverridesTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("T1", "T1_C1"));
        JDBC.assertFullResultSet(statement.executeQuery("select * from t1 --derby-properties index = t1_c1\nwhere c1 = c2"), FULL_TABLE);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        OptimizerOverridesTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("T1", "T1_C1"));
        JDBC.assertFullResultSet(statement.executeQuery("select * from t1 --derby-properties index = t1_c1\nwhere c1 + 1 = 1 + c1"), FULL_TABLE);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        OptimizerOverridesTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("T1", "T1_C1"));
        statement.close();
    }

    public void testNestedLoopJoinStrategy() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t1 a, t1 b --derby-properties joinStrategy = nestedloop\nwhere a.c1 = b.c1"), new String[][]{{"1", "1", "1", "1", "1", "1"}, {"2", "2", "2", "2", "2", "2"}, {"3", "3", "3", "3", "3", "3"}, {"4", "4", "4", "4", "4", "4"}});
        statement.close();
    }

    public void testInsertModeValue() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table temp1 (c1 int, c2 int, c3 int, constraint temp1cons1 primary key(c1, c2))");
        OptimizerOverridesTest.assertStatementError("42X01", statement, "insert into temp1 (c1,c2,c3) -- derby-properties insertModeValue=replace\nselect * from t1");
        this.dropTable("temp1");
        statement.close();
    }
}

