/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.derbyTesting.functionTests.tests.lang.EnumeratorTableFunction;

public class ZipFileTableFunction
extends EnumeratorTableFunction {
    private static final String[] COLUMN_NAMES = new String[]{"name", "directory", "comment", "compressed_size", "crc", "size", "modification_time"};

    public static ResultSet zipFile(String string) throws SQLException {
        return new ZipFileTableFunction(string);
    }

    public ZipFileTableFunction(String string) throws SQLException {
        super(COLUMN_NAMES);
        try {
            ZipFile zipFile = new ZipFile(string);
            this.setEnumeration(zipFile.entries());
        }
        catch (IOException iOException) {
            throw this.wrap(iOException);
        }
    }

    @Override
    public String[] makeRow(Object object) throws SQLException {
        String string;
        String string2;
        int n = 0;
        ZipEntry zipEntry = (ZipEntry)object;
        String string3 = zipEntry.getName();
        int n2 = string3.lastIndexOf(47);
        if (n2 < 0) {
            string2 = string3;
            string = "";
        } else {
            string2 = string3.substring(n2 + 1, string3.length());
            string = string3.substring(0, n2);
        }
        String[] stringArray = new String[this.getColumnCount()];
        stringArray[n++] = string2;
        stringArray[n++] = string;
        stringArray[n++] = zipEntry.getComment();
        stringArray[n++] = Long.toString(zipEntry.getCompressedSize());
        stringArray[n++] = Long.toString(zipEntry.getCrc());
        stringArray[n++] = Long.toString(zipEntry.getSize());
        stringArray[n++] = Long.toString(zipEntry.getTime());
        return stringArray;
    }

    private SQLException wrap(Throwable throwable) {
        return new SQLException(throwable.getMessage(), throwable);
    }
}

