/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.management;

import java.util.Set;
import javax.management.ObjectName;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.management.MBeanTest;

public class ManagementMBeanTest
extends MBeanTest {
    private static final String MANAGEMENT = "Management";
    private static final String VERSION = "Version";
    private static final int EXPECTED_BEAN_COUNT = 6;
    private static final String[] MBEAN_TYPES = new String[]{"NetworkServer", "Management", "JDBC", "Version"};

    public ManagementMBeanTest(String string) {
        super(string);
    }

    public static Test suite() {
        return MBeanTest.suite(ManagementMBeanTest.class, "ManagementMBeanTest");
    }

    public void testStartStopManagementFromApplication() throws Exception {
        ObjectName objectName = this.getApplicationManagementMBean();
        this.startStopManagement(objectName);
    }

    private void startStopManagement(ObjectName objectName) throws Exception {
        this.assertBooleanAttribute(true, objectName, "ManagementActive");
        StatsTuple statsTuple = this.getCurrentStats("Original");
        ManagementMBeanTest.assertTrue((String)("DerbyMBeanCount:" + statsTuple.getBeanCount()), (statsTuple.getBeanCount() >= 6 ? 1 : 0) != 0);
        this.invokeOperation(objectName, "startManagement");
        this.assertBooleanAttribute(true, objectName, "ManagementActive");
        StatsTuple statsTuple2 = this.getCurrentStats("NOP");
        this.compareStats(statsTuple, statsTuple2);
        this.invokeOperation(objectName, "stopManagement");
        this.assertBooleanAttribute(false, objectName, "ManagementActive");
        StatsTuple statsTuple3 = this.getCurrentStats("After Stopping");
        int[] nArray = new int[MBEAN_TYPES.length];
        for (int i = 0; i < MBEAN_TYPES.length; ++i) {
            int n = 1;
            if (MANAGEMENT.equals(MBEAN_TYPES[i])) {
                n = 0;
            } else if (VERSION.equals(MBEAN_TYPES[i])) {
                n = 2;
            }
            nArray[i] = statsTuple.typeCounts[i] - n;
        }
        StatsTuple statsTuple4 = new StatsTuple(null, nArray);
        this.compareStats(statsTuple4, statsTuple3);
        this.invokeOperation(objectName, "startManagement");
        this.assertBooleanAttribute(true, objectName, "ManagementActive");
        StatsTuple statsTuple5 = this.getCurrentStats("After Restarting");
        this.compareStats(statsTuple, statsTuple5);
    }

    private StatsTuple getCurrentStats(String string) throws Exception {
        Set<ObjectName> set = this.getDerbyDomainMBeans();
        StatsTuple statsTuple = new StatsTuple(set, this.countMBeanTypes(set));
        ManagementMBeanTest.println(string + " bean count = " + statsTuple.getBeanCount());
        return statsTuple;
    }

    private void compareStats(StatsTuple statsTuple, StatsTuple statsTuple2) throws Exception {
        ManagementMBeanTest.assertEquals((int)statsTuple.getBeanCount(), (int)statsTuple2.getBeanCount());
        for (int i = 0; i < MBEAN_TYPES.length; ++i) {
            ManagementMBeanTest.assertEquals((String)MBEAN_TYPES[i], (int)statsTuple.typeCounts[i], (int)statsTuple2.typeCounts[i]);
        }
    }

    private int[] countMBeanTypes(Set<ObjectName> set) throws Exception {
        int[] nArray = new int[MBEAN_TYPES.length];
        for (ObjectName objectName : set) {
            String string = objectName.getKeyProperty("type");
            for (int i = 0; i < MBEAN_TYPES.length; ++i) {
                if (!MBEAN_TYPES[i].equals(string)) continue;
                int n = i;
                nArray[n] = nArray[n] + 1;
            }
        }
        return nArray;
    }

    private static final class StatsTuple {
        Set<ObjectName> beanNames;
        int[] typeCounts;

        public StatsTuple(Set<ObjectName> set, int[] nArray) {
            this.beanNames = set;
            this.typeCounts = nArray;
        }

        public int getBeanCount() {
            int n = 0;
            for (int i = 0; i < this.typeCounts.length; ++i) {
                n += this.typeCounts[i];
            }
            return n;
        }
    }
}

