/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class RecoveryTest
extends BaseJDBCTestCase {
    public RecoveryTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("RecoveryTest");
        baseTestSuite.addTest(RecoveryTest.decorateTest());
        return baseTestSuite;
    }

    private static Test decorateTest() {
        CleanDatabaseTestSetup cleanDatabaseTestSetup = new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(RecoveryTest.class));
        return cleanDatabaseTestSetup;
    }

    public void testBasicRecovery() throws Exception {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t( i int )");
        connection.commit();
        TestConfiguration.getCurrent().shutdownDatabase();
        statement.close();
        connection.close();
        RecoveryTest.assertLaunchedJUnitTestMethod("org.apache.derbyTesting.functionTests.tests.store.RecoveryTest.launchRecoveryInsert");
        statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select i from t");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1956"}});
    }

    public void launchRecoveryInsert() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("insert into t(i) values (1956)");
        connection.commit();
        statement.executeUpdate("insert into t(i) values (2011)");
    }
}

