/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;

public class Changes10_2
extends UpgradeChange {
    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Upgrade changes for 10.2");
        baseTestSuite.addTestSuite(Changes10_2.class);
        if (JDBC.vmSupportsJDBC3()) {
            baseTestSuite.addTest((Test)new Changes10_2("changeEncryptionFromNone"));
            baseTestSuite.addTest((Test)new Changes10_2("changeEncryptionFromEncryptedDatabase"));
        }
        return baseTestSuite;
    }

    public Changes10_2(String string) {
        super(string);
    }

    public void testTriggerInternalVTI() throws SQLException {
        Statement statement = this.createStatement();
        boolean bl = this.oldAtLeast(10, 3);
        switch (this.getPhase()) {
            case 0: {
                statement.execute("CREATE TABLE D438.T438(a int, b varchar(20), c int)");
                statement.execute("INSERT INTO D438.T438 VALUES(1, 'DERBY-438', 2)");
                statement.execute("CREATE TABLE D438.T438_T1(a int, b varchar(20))");
                statement.execute("CREATE TABLE D438.T438_T2(a int, c int)");
                statement.execute("create trigger D438.T438_ROW_1 after UPDATE on D438.T438 referencing new as n old as o for each row " + (bl ? "" : "mode db2sql ") + "insert into D438.T438_T1(a, b) values (n.a, n.b || '_ROW')");
                statement.executeUpdate("create trigger D438.T438_STMT_1 after UPDATE on D438.T438 referencing new_table as n for each statement " + (bl ? "" : "mode db2sql ") + "insert into D438.T438_T1(a, b) select n.a, n.b || '_STMT' from n");
                this.commit();
                break;
            }
            case 1: {
                statement.execute("create trigger D438.T438_ROW_2 after UPDATE on D438.T438 referencing new as n old as o for each row " + (bl ? "" : "mode db2sql ") + "insert into D438.T438_T2(a, c) values (n.a, n.c + 100)");
                statement.executeUpdate("create trigger D438.T438_STMT_2 after UPDATE on D438.T438 referencing new_table as n for each statement " + (bl ? "" : "mode db2sql ") + "insert into D438.T438_T2(a, c) select n.a, n.c + 4000 from n");
                this.commit();
                break;
            }
            case 2: {
                break;
            }
        }
        statement.executeUpdate("UPDATE D438.T438 set c = c + 1");
        this.commit();
        ResultSet resultSet = statement.executeQuery("SELECT a,b from D438.T438_T1 ORDER BY 2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "DERBY-438_ROW"}, {"1", "DERBY-438_STMT"}});
        resultSet.close();
        resultSet = statement.executeQuery("SELECT a,c from D438.T438_T2 ORDER BY 2");
        if (this.getPhase() == 0) {
            Changes10_2.assertFalse((boolean)resultSet.next());
        } else {
            JDBC.assertFullResultSet(resultSet, new String[][]{{"1", Integer.toString(102 + this.getPhase() + 1)}, {"1", Integer.toString(4002 + this.getPhase() + 1)}});
        }
        resultSet.close();
        statement.executeUpdate("DELETE FROM D438.T438_T1");
        statement.executeUpdate("DELETE FROM D438.T438_T2");
        this.commit();
        statement.close();
    }

    public void testReusableRecordIdSequenceNumber() throws SQLException {
        boolean bl = this.oldAtLeast(10, 1);
        switch (this.getPhase()) {
            case 0: {
                Statement statement = this.createStatement();
                statement.execute("create table CT1(id int)");
                statement.execute("insert into CT1 values 1,2,3,4,5,6,7,8,9,10");
                statement.close();
                this.commit();
                break;
            }
            case 1: {
                if (!bl) break;
                PreparedStatement preparedStatement = this.prepareStatement("call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?,?,?,?,?)");
                preparedStatement.setString(1, "APP");
                preparedStatement.setString(2, "CT1");
                preparedStatement.setInt(3, 1);
                preparedStatement.setInt(4, 1);
                preparedStatement.setInt(5, 1);
                preparedStatement.executeUpdate();
                preparedStatement.close();
                this.commit();
                break;
            }
            case 2: {
                Statement statement = this.createStatement();
                ResultSet resultSet = statement.executeQuery("select * from CT1");
                while (resultSet.next()) {
                    resultSet.getInt(1);
                }
                statement.execute("insert into CT1 values 11,12,13,14,15,16,17,18,19");
                statement.close();
                this.commit();
                break;
            }
        }
    }

    public void testGrantRevokeStatements() throws SQLException {
        Statement statement = this.createStatement();
        switch (this.getPhase()) {
            case 0: 
            case 2: {
                Changes10_2.assertStatementError("42X01", statement, "GRANT SELECT ON TABLE1 TO USER1");
                Changes10_2.assertStatementError("42X01", statement, "REVOKE SELECT ON TABLE1 FROM USER1");
                break;
            }
            case 1: {
                Changes10_2.assertStatementError("XCL47", statement, "GRANT SELECT ON TABLE1 TO USER1");
                Changes10_2.assertStatementError("XCL47", statement, "REVOKE SELECT ON TABLE1 FROM USER1");
                break;
            }
            case 3: {
                Changes10_2.assertStatementError("42Z60", statement, "GRANT SELECT ON TABLE1 TO USER1");
                Changes10_2.assertStatementError("42Z60", statement, "REVOKE SELECT ON TABLE1 FROM USER1");
            }
        }
        statement.close();
    }

    public void testDatabaseOwnerChange() throws SQLException {
        switch (this.getPhase()) {
            case 0: 
            case 1: 
            case 2: {
                this.checkSystemSchemasOwner("DBA");
                break;
            }
            case 3: {
                this.checkSystemSchemasOwner(this.getTestConfiguration().getUserName());
            }
        }
    }

    private void checkSystemSchemasOwner(String string) throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select AUTHORIZATIONID, SCHEMANAME from SYS.SYSSCHEMAS WHERE SCHEMANAME LIKE 'SYS%' OR SCHEMANAME IN ('NULLID', 'SQLJ')");
        while (resultSet.next()) {
            Changes10_2.assertEquals((String)("AUTHORIZATIONID not valid for " + resultSet.getString(2)), (String)string, (String)resultSet.getString(1));
        }
        resultSet.close();
        statement.close();
    }

    public void testSystemRoutinePermissions() throws SQLException {
        switch (this.getPhase()) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                Statement statement = this.createStatement();
                ResultSet resultSet = statement.executeQuery("select A.ALIAS FROM SYS.SYSROUTINEPERMS R, SYS.SYSALIASES A WHERE R.ALIASID = A.ALIASID AND R.GRANTEE = 'PUBLIC' AND R.GRANTOR = '" + this.getTestConfiguration().getUserName() + "' ORDER BY 1");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"SYSCS_COMPRESS_TABLE"}, {"SYSCS_DROP_STATISTICS"}, {"SYSCS_GET_DATABASE_NAME"}, {"SYSCS_GET_RUNTIMESTATISTICS"}, {"SYSCS_INPLACE_COMPRESS_TABLE"}, {"SYSCS_MODIFY_PASSWORD"}, {"SYSCS_PEEK_AT_IDENTITY"}, {"SYSCS_PEEK_AT_SEQUENCE"}, {"SYSCS_SET_RUNTIMESTATISTICS"}, {"SYSCS_SET_STATISTICS_TIMING"}, {"SYSCS_UPDATE_STATISTICS"}});
                resultSet.close();
                statement.close();
            }
        }
    }

    public void changeEncryptionFromNone() throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSourceLogical("NO_ENCRYPT_10_2");
        switch (this.getPhase()) {
            case 0: {
                JDBCDataSource.setBeanProperty(dataSource, "createDatabase", "create");
                dataSource.getConnection().close();
                break;
            }
            case 1: {
                JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "dataEncryption=true;bootPassword=xyz1234abc");
                try {
                    dataSource.getConnection();
                    Changes10_2.fail((String)"open re-encrypted connection in soft upgrade");
                }
                catch (SQLException sQLException) {
                    Changes10_2.assertSQLState("XJ040", sQLException);
                    SQLException sQLException2 = sQLException.getNextException();
                    Changes10_2.assertNotNull((Object)sQLException2);
                    Changes10_2.assertSQLState("XCL47", sQLException2);
                }
                break;
            }
            case 2: {
                dataSource.getConnection().close();
                break;
            }
            case 3: {
                JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "upgrade=true;dataEncryption=true;bootPassword=haRD1234upGrAde");
                dataSource.getConnection().close();
                JDBCDataSource.clearStringBeanProperty(dataSource, "connectionAttributes");
                JDBCDataSource.shutdownDatabase(dataSource);
                try {
                    dataSource.getConnection();
                    Changes10_2.fail((String)"open re-encrypted connection without password");
                }
                catch (SQLException sQLException) {
                    Changes10_2.assertSQLState("XJ040", sQLException);
                    SQLException sQLException3 = sQLException.getNextException();
                    Changes10_2.assertNotNull((Object)sQLException3);
                    Changes10_2.assertSQLState("XBM06", sQLException3);
                }
                JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "bootPassword=haRD1234upGrAde");
                dataSource.getConnection().close();
            }
        }
    }

    public void changeEncryptionFromEncryptedDatabase() throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSourceLogical("ENCRYPT_10_2");
        switch (this.getPhase()) {
            case 0: {
                JDBCDataSource.setBeanProperty(dataSource, "createDatabase", "create");
                JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "dataEncryption=true;bootPassword=old862phRase");
                dataSource.getConnection().close();
                break;
            }
            case 1: {
                JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "bootPassword=old862phRase;newBootPassword=new902pHrAse");
                try {
                    dataSource.getConnection();
                    Changes10_2.fail((String)"open re-encrypted connection in soft upgrade");
                }
                catch (SQLException sQLException) {
                    Changes10_2.assertSQLState("XJ040", sQLException);
                    SQLException sQLException2 = sQLException.getNextException();
                    Changes10_2.assertNotNull((Object)sQLException2);
                    Changes10_2.assertSQLState("XCL47", sQLException2);
                }
                break;
            }
            case 2: {
                JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "bootPassword=old862phRase");
                dataSource.getConnection().close();
                break;
            }
            case 3: {
                JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "upgrade=true;bootPassword=old862phRase;newBootPassword=hard924pHrAse");
                dataSource.getConnection().close();
                JDBCDataSource.clearStringBeanProperty(dataSource, "connectionAttributes");
                JDBCDataSource.shutdownDatabase(dataSource);
                try {
                    dataSource.getConnection();
                    Changes10_2.fail((String)"open re-encrypted connection without password");
                }
                catch (SQLException sQLException) {
                    Changes10_2.assertSQLState("XJ040", sQLException);
                    SQLException sQLException3 = sQLException.getNextException();
                    Changes10_2.assertNotNull((Object)sQLException3);
                    Changes10_2.assertSQLState("XBM06", sQLException3);
                }
                JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "bootPassword=hard924pHrAse");
                dataSource.getConnection().close();
            }
        }
    }
}

