/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.File;
import java.sql.SQLException;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSetup;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

class DropDatabaseSetup
extends BaseTestSetup {
    private final String logicalDBName;
    private final boolean shutdownBeforeDrop;

    DropDatabaseSetup(Test test, String string) {
        this(test, string, true);
    }

    DropDatabaseSetup(Test test, String string, boolean bl) {
        super(test);
        this.logicalDBName = string;
        this.shutdownBeforeDrop = bl;
    }

    protected void tearDown() throws Exception {
        if (this.shutdownBeforeDrop) {
            this.shutdownDatabase();
        }
        this.removeDatabase();
    }

    private void shutdownDatabase() throws SQLException {
        boolean bl;
        TestConfiguration testConfiguration = TestConfiguration.getCurrent();
        try {
            testConfiguration.openConnection(this.logicalDBName).close();
            bl = true;
        }
        catch (SQLException sQLException) {
            String string = sQLException.getSQLState();
            if ("XJ040".equals(string) || "08004".equals(string) || "4251I".equals(string)) {
                bl = false;
            }
            throw sQLException;
        }
        if (bl) {
            DataSource dataSource = JDBCDataSource.getDataSourceLogical(this.logicalDBName);
            JDBCDataSource.shutdownDatabase(dataSource);
        }
    }

    void removeDatabase() {
        TestConfiguration testConfiguration = TestConfiguration.getCurrent();
        Object object = testConfiguration.getPhysicalDatabaseName(this.logicalDBName);
        object = ((String)object).replace('/', File.separatorChar);
        String string = BaseTestCase.getSystemProperty("derby.system.home");
        if (string == null) {
            DropDatabaseSetup.fail((String)"not implemented");
        } else {
            object = string + File.separator + (String)object;
        }
        DropDatabaseSetup.removeDirectory((String)object);
        String string2 = testConfiguration.getConnectionAttributes().getProperty("logDevice");
        if (string2 != null) {
            DropDatabaseSetup.removeDirectory(string2);
        }
    }

    static void removeDirectory(String string) {
        File file = new File(string);
        DropDatabaseSetup.removeDirectory(file);
    }

    static void removeDirectory(File file) {
        if (!PrivilegedFileOpsForTests.exists(file)) {
            return;
        }
        BaseTestCase.assertDirectoryDeleted(file);
    }

    static void removeFiles(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                File file = new File(stringArray[i].toString());
                DropDatabaseSetup.assertTrue((String)stringArray[i].toString(), (boolean)file.delete());
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DropDatabaseSetup.fail((String)"open file error");
            }
        }
    }
}

