/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.basic.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBCPerfTestCase;

public class IndexScanTest
extends JDBCPerfTestCase {
    private PreparedStatement preparedStmt;

    private IndexScanTest(String string, int n, int n2) {
        super(string, n, n2);
    }

    private PreparedStatement getOrPrepareStatement(String string) throws SQLException {
        if (this.preparedStmt == null) {
            this.preparedStmt = this.prepareStatement(string);
        }
        return this.preparedStmt;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.preparedStmt = null;
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("IndexScanTest");
        baseTestSuite.addTest((Test)new IndexScanTest("varchar10", 5000, 4));
        baseTestSuite.addTest((Test)new IndexScanTest("varchar100", 5000, 4));
        baseTestSuite.addTest((Test)new IndexScanTest("varchar1000", 5000, 4));
        baseTestSuite.addTest((Test)new IndexScanTest("varcharAll", 5000, 4));
        baseTestSuite.addTest((Test)new IndexScanTest("decimal1column", 5000, 4));
        baseTestSuite.addTest((Test)new IndexScanTest("decimal10columns", 5000, 4));
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("CREATE TABLE T (VC10 VARCHAR(10), VC100 VARCHAR(100), VC1000 VARCHAR(1000), DEC1 DECIMAL(10,10), DEC2 DECIMAL(10,10), DEC3 DECIMAL(10,10), DEC4 DECIMAL(10,10), DEC5 DECIMAL(10,10), DEC6 DECIMAL(10,10), DEC7 DECIMAL(10,10), DEC8 DECIMAL(10,10), DEC9 DECIMAL(10,10), DEC10 DECIMAL(10,10))");
                PreparedStatement preparedStatement = statement.getConnection().prepareStatement("INSERT INTO T(VC10,VC100,VC1000,DEC1,DEC2,DEC3,DEC4,DEC5,DEC6,DEC7,DEC8,DEC9,DEC10) VALUES (?,?,?,RANDOM(),RANDOM(),RANDOM(),RANDOM(),RANDOM(),RANDOM(),RANDOM(),RANDOM(),RANDOM(),RANDOM())");
                char[] cArray = new char[1000];
                Random random = new Random();
                for (int i = 0; i < 1000; ++i) {
                    IndexScanTest.fillWithRandomChars(random, cArray);
                    preparedStatement.setString(1, new String(cArray, 0, 10));
                    preparedStatement.setString(2, new String(cArray, 0, 100));
                    preparedStatement.setString(3, new String(cArray, 0, 1000));
                    preparedStatement.executeUpdate();
                }
                preparedStatement.close();
                statement.execute("CREATE INDEX T_VC10 ON T(VC10)");
                statement.execute("CREATE INDEX T_VC100 ON T(VC100)");
                statement.execute("CREATE INDEX T_VC1000 ON T(VC1000)");
                statement.execute("CREATE INDEX T_VC_ALL ON T(VC10,VC100,VC1000)");
                statement.execute("CREATE INDEX T_DEC1 ON T(DEC1)");
                statement.execute("CREATE INDEX T_DEC_ALL ON T(DEC1,DEC2,DEC3,DEC4,DEC5,DEC6,DEC7,DEC8,DEC9,DEC10)");
            }
        };
    }

    private static void fillWithRandomChars(Random random, char[] cArray) {
        String string = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = string.charAt(random.nextInt(string.length()));
        }
    }

    public void varchar10() throws SQLException {
        PreparedStatement preparedStatement = this.getOrPrepareStatement("SELECT VC10 FROM T --DERBY-PROPERTIES index=T_VC10");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            IndexScanTest.assertNotNull((Object)resultSet.getString(1));
        }
        resultSet.close();
    }

    public void varchar100() throws SQLException {
        PreparedStatement preparedStatement = this.getOrPrepareStatement("SELECT VC100 FROM T --DERBY-PROPERTIES index=T_VC100");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            IndexScanTest.assertNotNull((Object)resultSet.getString(1));
        }
        resultSet.close();
    }

    public void varchar1000() throws SQLException {
        PreparedStatement preparedStatement = this.getOrPrepareStatement("SELECT VC1000 FROM T --DERBY-PROPERTIES index=T_VC1000");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            IndexScanTest.assertNotNull((Object)resultSet.getString(1));
        }
        resultSet.close();
    }

    public void varcharAll() throws SQLException {
        PreparedStatement preparedStatement = this.getOrPrepareStatement("SELECT VC10,VC100,VC1000 FROM T --DERBY-PROPERTIES index=T_VC_ALL");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            for (int i = 1; i <= 3; ++i) {
                IndexScanTest.assertNotNull((Object)resultSet.getString(i));
            }
        }
        resultSet.close();
    }

    public void decimal1column() throws SQLException {
        PreparedStatement preparedStatement = this.getOrPrepareStatement("SELECT DEC1 FROM T --DERBY-PROPERTIES index=T_DEC1");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            IndexScanTest.assertNotNull((Object)resultSet.getBigDecimal(1));
        }
        resultSet.close();
    }

    public void decimal10columns() throws SQLException {
        PreparedStatement preparedStatement = this.getOrPrepareStatement("SELECT DEC1,DEC2,DEC3,DEC4,DEC5,DEC6,DEC7,DEC8,DEC9,DEC10 FROM T --DERBY-PROPERTIES index=T_DEC_ALL");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            for (int i = 1; i <= 10; ++i) {
                IndexScanTest.assertNotNull((Object)resultSet.getBigDecimal(i));
            }
        }
        resultSet.close();
    }
}

