/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.mailjdbc.utils;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Random;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.system.mailjdbc.MailJdbc;
import org.apache.derbyTesting.system.mailjdbc.utils.LogFile;
import org.apache.derbyTesting.system.mailjdbc.utils.PerfTime;
import org.apache.derbyTesting.system.mailjdbc.utils.Statements;

public class DbTasks {
    public static LogFile log = new LogFile("performance.out");
    private static int id_count = 0;
    public static int insert_count = 0;
    public static int delete_count = 0;
    public static int clob_count = 0;
    public static int blob_count = 0;
    public static Random Rn = new Random();

    public static void jdbcLoad(String string, boolean bl) {
        if (string.equalsIgnoreCase("embedded")) {
            DbTasks.setSystemProperty("driver", "org.apache.derby.jdbc.EmbeddedDriver");
            MailJdbc.logAct.logMsg(" \n*****************************************************");
            MailJdbc.logAct.logMsg("\n\n\tStarting the test in Embedded mode");
            MailJdbc.logAct.logMsg("\n\n*****************************************************");
            if (bl) {
                DbTasks.setSystemProperty("database", "jdbc:derby:mailsdb");
            } else {
                DbTasks.setSystemProperty("database", "jdbc:derby:mailsdb;create=true");
            }
            DbTasks.setSystemProperty("ij.user", "REFRESH");
            DbTasks.setSystemProperty("ij.password", "Refresh");
        } else {
            DbTasks.setSystemProperty("driver", "org.apache.derby.jdbc.ClientDriver");
            MailJdbc.logAct.logMsg(" \n*****************************************************");
            MailJdbc.logAct.logMsg("\n\n\tStarting the test in NetworkServer mode");
            MailJdbc.logAct.logMsg("\n\n*****************************************************");
            if (bl) {
                DbTasks.setSystemProperty("database", "jdbc:derby://localhost:1527/mailsdb");
            } else {
                DbTasks.setSystemProperty("database", "jdbc:derby://localhost:1527/mailsdb;create=true");
            }
            DbTasks.setSystemProperty("ij.user", "REFRESH");
            DbTasks.setSystemProperty("ij.password", "Refresh");
        }
        try {
            if (bl) {
                MailJdbc.logAct.logMsg("Useing the existing database...");
                return;
            }
            long l = System.currentTimeMillis();
            ij.main((String[])new String[]{"-fr", "/org/apache/derbyTesting/system/mailjdbc/schema/schema.sql"});
            long l2 = System.currentTimeMillis();
            log.logMsg(" \n*****************************************************");
            log.logMsg("\n\n\tPerformance Info for the Test on" + l);
            log.logMsg("\n\n*****************************************************");
            log.logMsg(LogFile.INFO + "Schema Creation :" + PerfTime.readableTime(l2 - l));
            System.out.println("created the schema");
        }
        catch (Exception exception) {
            log.logMsg(LogFile.ERROR + "Exception while running loading and creating tables: " + exception.getMessage());
            exception.printStackTrace();
            DbTasks.errorPrint(exception);
        }
    }

    public static Connection getConnection(String string, String string2) {
        try {
            Class<?> clazz = Class.forName(System.getProperty("driver"));
            clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            Connection connection = DriverManager.getConnection(System.getProperty("database"), string, string2);
            return connection;
        }
        catch (Exception exception) {
            log.logMsg(LogFile.ERROR + "Error while getting connection for threads:" + exception.getMessage());
            exception.printStackTrace();
            DbTasks.errorPrint(exception);
            return null;
        }
    }

    public void readMail(Connection connection, String string) throws Exception {
        long l;
        ResultSet resultSet;
        boolean bl = connection.getAutoCommit();
        int n = connection.getTransactionIsolation();
        Statement statement = null;
        Statement statement2 = null;
        int n2 = 0;
        int n3 = 0;
        long l2 = 0L;
        try {
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(1);
            long l3 = System.currentTimeMillis();
            statement = connection.createStatement();
            statement2 = connection.createStatement();
            ResultSet resultSet2 = statement.executeQuery(Statements.getRowCount);
            resultSet = statement2.executeQuery(Statements.getRowCountAttach);
            while (resultSet2.next()) {
                n2 = resultSet2.getInt(1);
            }
            while (resultSet.next()) {
                n3 = resultSet.getInt(1);
            }
            if (n2 == 0) {
                MailJdbc.logAct.logMsg(LogFile.INFO + string + " : Inbox is empty");
            }
            l = System.currentTimeMillis();
            MailJdbc.logAct.logMsg(LogFile.INFO + string + " : The number of mails in the REFRESH.INBOX are : " + n2);
            MailJdbc.logAct.logMsg(LogFile.INFO + string + " : The number of mails in the REFRESH.ATTACH are : " + n3);
            log.logMsg(LogFile.INFO + string + " : Time taken to scan the entire REFRESH.INBOX for count :" + PerfTime.readableTime(l - l3));
            resultSet2.close();
            resultSet.close();
            statement2.close();
        }
        catch (SQLException sQLException) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + string + " : SQL Exception while reading : " + sQLException.getMessage());
            sQLException.printStackTrace();
            DbTasks.errorPrint(sQLException);
            connection.rollback();
            throw sQLException;
        }
        try {
            int n4 = 0;
            if (n2 - 1 <= 0) {
                n4 = 1;
            } else {
                n4 = Rn.nextInt(n2 - 1);
                if (n4 == 0) {
                    n4 = 1;
                }
            }
            long l4 = System.currentTimeMillis();
            resultSet = statement.executeQuery("select message from REFRESH.INBOX where id  = " + n4);
            if (resultSet.next()) {
                l2 = resultSet.getClob(1).length();
                MailJdbc.logAct.logMsg(LogFile.INFO + string + " : size of the message for id " + n4 + " is : " + l2);
            } else {
                MailJdbc.logAct.logMsg(LogFile.INFO + string + " : mail with the id " + n4 + " does not exist");
            }
            l = System.currentTimeMillis();
            log.logMsg(LogFile.INFO + string + " : Time taken to get the clob :" + PerfTime.readableTime(l - l4));
            resultSet.close();
            ResultSet resultSet3 = statement.executeQuery("select attachment from REFRESH.attach where id  = " + n4);
            long l5 = System.currentTimeMillis();
            if (resultSet3.next()) {
                l2 = resultSet3.getBlob(1).length();
                MailJdbc.logAct.logMsg(LogFile.INFO + string + " : size of the attachment for id " + n4 + " is : " + l2);
            } else {
                MailJdbc.logAct.logMsg(LogFile.INFO + string + " : no attachment");
            }
            resultSet3.close();
            statement.close();
            long l6 = System.currentTimeMillis();
            log.logMsg(LogFile.INFO + string + " : Time taken to get the blob :" + PerfTime.readableTime(l6 - l5));
            connection.commit();
        }
        catch (SQLException sQLException) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + string + " : SQL Exception while getting the message and attach size : " + sQLException.getMessage());
            sQLException.printStackTrace();
            DbTasks.errorPrint(sQLException);
            connection.rollback();
            throw sQLException;
        }
        finally {
            connection.setAutoCommit(bl);
            connection.setTransactionIsolation(n);
        }
    }

    public synchronized void deleteMailByUser(Connection connection, String string) throws Exception {
        boolean bl = connection.getAutoCommit();
        int n = 0;
        int n2 = 0;
        try {
            connection.setAutoCommit(false);
            PreparedStatement preparedStatement = connection.prepareStatement(Statements.updateStr);
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("select max(id) from REFRESH.INBOX ");
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
            statement.close();
            short s = 1;
            if (n - 1 <= 0) {
                n2 = n;
            } else {
                n2 = Rn.nextInt(n - 1);
                if (n2 == 0) {
                    n2 = 1;
                }
            }
            long l = System.currentTimeMillis();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                preparedStatement.setShort(1, s);
                preparedStatement.setInt(2, i);
                int n4 = preparedStatement.executeUpdate();
                n3 += n4;
            }
            long l2 = System.currentTimeMillis();
            log.logMsg(LogFile.INFO + string + " :  Time taken to mark " + n2 + " mails to be deleted :" + PerfTime.readableTime(l2 - l));
            MailJdbc.logAct.logMsg(LogFile.INFO + string + " : The number of mails marked to be deleted from REFRESH.INBOX is: " + n3);
            preparedStatement.close();
            connection.commit();
        }
        catch (SQLException sQLException) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + string + " : Exception while deleting mail REFRESH.INBOX" + sQLException.getMessage());
            sQLException.printStackTrace();
            DbTasks.errorPrint(sQLException);
            connection.rollback();
            throw sQLException;
        }
        finally {
            connection.setAutoCommit(bl);
        }
    }

    public void deleteMailByThread(Connection connection, String string) throws Exception {
        boolean bl = connection.getAutoCommit();
        try {
            connection.setAutoCommit(false);
            PreparedStatement preparedStatement = connection.prepareStatement(Statements.deleteStr);
            Statement statement = connection.createStatement();
            long l = System.currentTimeMillis();
            int n = 0;
            n = preparedStatement.executeUpdate();
            long l2 = System.currentTimeMillis();
            log.logMsg(LogFile.INFO + string + " : Time taken to delete mails by thread :" + PerfTime.readableTime(l2 - l));
            MailJdbc.logAct.logMsg(LogFile.INFO + string + " : " + n + " rows deleted from REFRESH.INBOX");
            delete_count += n;
            preparedStatement.close();
            statement.close();
            connection.commit();
        }
        catch (SQLException sQLException) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + string + " : Exception while deleting mail from REFRESH.INBOX, REFRESH.ATTACH by Thread: " + sQLException.getMessage());
            sQLException.printStackTrace();
            DbTasks.errorPrint(sQLException);
            connection.rollback();
            throw sQLException;
        }
        finally {
            connection.setAutoCommit(bl);
        }
    }

    public void moveToFolders(Connection connection, String string) throws Exception {
        boolean bl = connection.getAutoCommit();
        try {
            connection.setAutoCommit(false);
            Statement statement = connection.createStatement();
            PreparedStatement preparedStatement = connection.prepareStatement(Statements.movefolder);
            ResultSet resultSet = statement.executeQuery(Statements.getRowCount);
            if (!resultSet.next()) {
                MailJdbc.logAct.logMsg(LogFile.INFO + string + " : no message in the REFRESH.INBOX to move");
            } else {
                int n;
                int n2 = 0;
                int n3 = resultSet.getInt(1);
                if (n3 == 0) {
                    return;
                }
                n2 = n3 <= 1 ? 1 : Rn.nextInt(n3 - 1);
                if (n2 == 0) {
                    n2 = 1;
                }
                if ((n = Rn.nextInt(4)) == 0) {
                    n = 1;
                }
                preparedStatement.setInt(1, n);
                preparedStatement.setInt(2, n2);
                long l = System.currentTimeMillis();
                preparedStatement.executeUpdate();
                long l2 = System.currentTimeMillis();
                log.logMsg(LogFile.INFO + string + " : Time taken to move a mail to the folder :" + PerfTime.readableTime(l2 - l));
                MailJdbc.logAct.logMsg(LogFile.INFO + string + " : Mail with id : " + n2 + " is moved to folder" + n);
            }
            statement.close();
            preparedStatement.close();
            resultSet.close();
            connection.commit();
        }
        catch (SQLException sQLException) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + string + " : Exception while moving mail to folders: " + sQLException.getMessage());
            sQLException.printStackTrace();
            DbTasks.errorPrint(sQLException);
            connection.rollback();
            throw sQLException;
        }
        finally {
            connection.setAutoCommit(bl);
        }
    }

    public void insertMail(Connection connection, String string) throws Exception {
        LoopingAlphabetStream loopingAlphabetStream = null;
        LoopingAlphabetReader loopingAlphabetReader = null;
        boolean bl = connection.getAutoCommit();
        int n = connection.getTransactionIsolation();
        try {
            connection.setAutoCommit(false);
            PreparedStatement preparedStatement = connection.prepareStatement(Statements.insertStr, 1);
            String string2 = new String("ABCD");
            String string3 = new String("WXYZ");
            long l = 0L;
            long l2 = 0L;
            int n2 = 0;
            int n3 = Rn.nextInt(9);
            if (n3 == 0) {
                n3 = 1;
            }
            for (int i = 0; i < n3; ++i) {
                int n4;
                long l3 = System.currentTimeMillis();
                String string4 = new String(DbTasks.increment(string2, 60));
                String string5 = new String(DbTasks.decrement(string3, 60));
                preparedStatement.setString(1, string4);
                preparedStatement.setString(2, string5);
                preparedStatement.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                string2 = string4;
                string3 = string5;
                try {
                    n4 = Rn.nextInt(3077801) + 200;
                    loopingAlphabetReader = new LoopingAlphabetReader((long)n4, CharAlphabet.modernLatinLowercase());
                    preparedStatement.setCharacterStream(4, (Reader)loopingAlphabetReader, n4);
                }
                catch (Exception exception) {
                    MailJdbc.logAct.logMsg(LogFile.ERROR + string + " : File not found Exception : " + exception.getMessage());
                    DbTasks.errorPrint(exception);
                    throw exception;
                }
                n4 = preparedStatement.executeUpdate();
                if (n4 != 0) {
                    ++insert_count;
                }
                ((Reader)loopingAlphabetReader).close();
                long l4 = System.currentTimeMillis();
                l += l4 - l3;
                PreparedStatement preparedStatement2 = connection.prepareStatement(Statements.insertStrAttach);
                Statement statement = connection.createStatement();
                ResultSet resultSet = preparedStatement.getGeneratedKeys();
                int n5 = Rn.nextInt(9);
                if (n5 == 0) {
                    n5 = 1;
                }
                if (i == n5) {
                    int n6 = 0;
                    while (resultSet.next()) {
                        n6 = resultSet.getInt(1);
                    }
                    int n7 = Rn.nextInt(4);
                    if (n7 == 0) {
                        n7 = 1;
                    }
                    for (int j = 0; j < n7; ++j) {
                        int n8;
                        long l5 = System.currentTimeMillis();
                        preparedStatement2.setInt(1, n6);
                        try {
                            n8 = Rn.nextInt(5130001) + 0;
                            loopingAlphabetStream = new LoopingAlphabetStream(n8);
                            preparedStatement2.setBinaryStream(2, (InputStream)loopingAlphabetStream, n8);
                        }
                        catch (Exception exception) {
                            MailJdbc.logAct.logMsg(LogFile.ERROR + string + " : Exception : " + exception.getMessage());
                            DbTasks.errorPrint(exception);
                            throw exception;
                        }
                        n8 = preparedStatement2.executeUpdate();
                        loopingAlphabetStream.close();
                        if (n8 != 0) {
                            ++blob_count;
                            ++n2;
                        }
                        long l6 = System.currentTimeMillis();
                        l2 += l6 - l5;
                    }
                }
                ++id_count;
                resultSet.close();
                statement.close();
                preparedStatement2.close();
            }
            log.logMsg(LogFile.INFO + string + " : Time taken to insert " + n3 + " rows to REFRESH.INBOX :" + PerfTime.readableTime(l));
            log.logMsg(LogFile.INFO + string + " : Time taken to insert " + n2 + " rows to REFRESH.ATTACH :" + PerfTime.readableTime(l2));
            preparedStatement.close();
            connection.commit();
        }
        catch (SQLException sQLException) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + string + " : Error while inserting REFRESH.ATTACH:" + sQLException.getMessage());
            sQLException.printStackTrace();
            DbTasks.errorPrint(sQLException);
            connection.rollback();
            throw sQLException;
        }
        finally {
            connection.setTransactionIsolation(n);
            connection.setAutoCommit(bl);
        }
    }

    public synchronized void deleteMailByExp(Connection connection, String string) throws Exception {
        boolean bl = connection.getAutoCommit();
        try {
            connection.setAutoCommit(false);
            long l = System.currentTimeMillis();
            Statement statement = connection.createStatement();
            MailJdbc.logAct.logMsg(LogFile.INFO + string + " : delete mails which are older than 1 day with sleep 250000 ");
            int n = 0;
            n = statement.executeUpdate(Statements.del_jdbc_exp);
            statement.close();
            connection.commit();
            long l2 = System.currentTimeMillis();
            log.logMsg(LogFile.INFO + string + " : " + PerfTime.readableTime(l) + " : Time taken to delete " + n + " mails :" + PerfTime.readableTime(l2 - l));
            MailJdbc.logAct.logMsg(LogFile.INFO + string + " :  number of mails deleted : " + n);
            delete_count += n;
        }
        catch (SQLException sQLException) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + string + " : Error while deleting mails by expiry manager: " + sQLException.getMessage());
            sQLException.printStackTrace();
            DbTasks.errorPrint(sQLException);
            connection.rollback();
            throw sQLException;
        }
        finally {
            connection.setAutoCommit(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Backup(Connection connection, String string) throws Exception {
        boolean bl = connection.getAutoCommit();
        long l = System.currentTimeMillis();
        try {
            connection.setAutoCommit(true);
            CallableStatement callableStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT(?, ?)");
            callableStatement.setString(1, System.getProperty("user.dir") + File.separator + "mailbackup");
            callableStatement.setInt(2, 1);
            callableStatement.execute();
            callableStatement.close();
            MailJdbc.logAct.logMsg(LogFile.INFO + string + " : Finished backing up the Database");
            connection.commit();
        }
        catch (Throwable throwable) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + string + " : Error while doing the backup system procedure: " + throwable.getMessage());
            throwable.printStackTrace();
            DbTasks.errorPrint(throwable);
        }
        finally {
            connection.setAutoCommit(bl);
        }
        long l2 = System.currentTimeMillis();
        log.logMsg(LogFile.INFO + string + " : Time taken to do backup :" + PerfTime.readableTime(l2 - l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compressTable(Connection connection, String string, String string2) throws Exception {
        long l = System.currentTimeMillis();
        long l2 = DbTasks.databaseSize(new File("mailsdb"));
        MailJdbc.logAct.logMsg(LogFile.INFO + string2 + " : dbsize before compress : " + l2);
        boolean bl = connection.getAutoCommit();
        try {
            connection.setAutoCommit(true);
            CallableStatement callableStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?, ?, ?, ?, ?)");
            callableStatement.setString(1, "REFRESH");
            callableStatement.setString(2, string);
            callableStatement.setShort(3, (short)1);
            callableStatement.setShort(4, (short)1);
            callableStatement.setShort(5, (short)1);
            callableStatement.execute();
            callableStatement.close();
        }
        catch (Throwable throwable) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + string2 + " : Error while doing the Compress procedure: " + throwable.getMessage());
            throwable.printStackTrace();
            DbTasks.errorPrint(throwable);
        }
        finally {
            connection.setAutoCommit(bl);
        }
        long l3 = System.currentTimeMillis();
        MailJdbc.logAct.logMsg(LogFile.INFO + string2 + " : Finished Compressing the table: " + string);
        log.logMsg(LogFile.INFO + string2 + " : Time taken to compress the table : " + string + " " + PerfTime.readableTime(l3 - l));
        l2 = DbTasks.databaseSize(new File("mailsdb"));
        MailJdbc.logAct.logMsg(LogFile.INFO + string2 + " : dbsize after compress : " + l2);
    }

    public synchronized void checkDbSize(Connection connection, String string) {
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            Statement statement = connection.createStatement();
            Statement statement2 = connection.createStatement();
            Statement statement3 = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("select count(*) from REFRESH.INBOX ");
            while (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
            if (n2 > 50) {
                n3 = Rn.nextInt(n2 - 36 - 1);
                if (n3 == 0) {
                    n3 = 1;
                }
                ResultSet resultSet2 = statement2.executeQuery("select id from REFRESH.INBOX");
                while (resultSet2.next()) {
                    arrayList.add(resultSet2.getInt(1));
                }
                for (int i = 0; i <= n3; ++i) {
                    n += statement3.executeUpdate("delete from REFRESH.INBOX where id =" + String.valueOf(arrayList.get(i)));
                }
                resultSet2.close();
            }
            delete_count += n;
            resultSet.close();
            statement.close();
            statement2.close();
            statement3.close();
        }
        catch (Exception exception) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + string + " :  " + exception.getMessage());
            DbTasks.errorPrint(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantRevoke(Connection connection, String string) throws Exception {
        boolean bl = connection.getAutoCommit();
        try {
            Statement statement = connection.createStatement();
            statement.execute(Statements.grantSel1);
            statement.execute(Statements.grantSel2);
            statement.execute(Statements.grantSel3);
            statement.execute(Statements.grantSel4);
            statement.execute(Statements.grantSel5);
            statement.execute(Statements.grantSel6);
            statement.execute(Statements.grantSel7);
            statement.execute(Statements.grantIns1);
            statement.execute(Statements.grantIns2);
            statement.execute(Statements.grantIns3);
            statement.execute(Statements.grantUp1);
            statement.execute(Statements.grantUp2);
            statement.execute(Statements.grantUp3);
            statement.execute(Statements.grantDel1);
            statement.execute(Statements.grantDel2);
            statement.execute(Statements.grantDel3);
            statement.execute(Statements.grantExe1);
            statement.execute(Statements.grantExe2);
            statement.execute(Statements.grantExe3);
            statement.execute(Statements.grantExe4);
            statement.execute(Statements.grantExe5);
            connection.commit();
            statement.close();
            MailJdbc.logAct.logMsg(LogFile.INFO + string + " : Finished Granting permissions");
        }
        catch (Throwable throwable) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + string + " : Error while doing Grant Revoke: " + throwable.getMessage());
            throwable.printStackTrace();
            DbTasks.errorPrint(throwable);
        }
        finally {
            connection.setAutoCommit(bl);
        }
    }

    public static long databaseSize(File file) {
        long l = 0L;
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                l += DbTasks.databaseSize(new File(file, stringArray[i]));
            }
            return l;
        }
        return file.length();
    }

    public static void setSystemProperty(String string, String string2) {
        String string3 = System.getProperty(string);
        if (string3 == null) {
            System.setProperty(string, string2);
        } else {
            string2 = string3;
        }
        MailJdbc.logAct.logMsg(LogFile.INFO + string + "=" + string2);
    }

    public void totals(String string) {
        MailJdbc.logAct.logMsg(LogFile.INFO + string + " : total number of inserts : " + insert_count);
        MailJdbc.logAct.logMsg(LogFile.INFO + string + " : total number of deletes : " + delete_count);
        MailJdbc.logAct.logMsg(LogFile.INFO + string + " : total number of blobs had inserted : " + blob_count);
    }

    public static String decrement(String string, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer();
        if (string.length() == 1 && string.charAt(0) == DbTasks.firstChar()) {
            for (int i = 0; i < n; ++i) {
                stringBuffer2.append(DbTasks.lastChar());
            }
            return stringBuffer2.toString();
        }
        boolean bl = true;
        for (n2 = 0; n2 < stringBuffer.length(); ++n2) {
            if (stringBuffer.charAt(n2) == DbTasks.firstChar()) continue;
            bl = false;
            break;
        }
        if (bl) {
            stringBuffer.deleteCharAt(0);
            for (n2 = 0; n2 < stringBuffer.length(); ++n2) {
                stringBuffer.setCharAt(n2, DbTasks.lastChar());
            }
        } else {
            for (n2 = stringBuffer.length() - 1; n2 >= 0; --n2) {
                if (stringBuffer.charAt(n2) > DbTasks.firstChar()) {
                    stringBuffer.setCharAt(n2, DbTasks.previousChar(stringBuffer.charAt(n2)));
                } else {
                    stringBuffer.setCharAt(n2, DbTasks.lastChar());
                    if (stringBuffer.charAt(n2 - 1) >= DbTasks.firstChar()) continue;
                    stringBuffer.setCharAt(n2 - 1, DbTasks.previousChar(stringBuffer.charAt(n2 - 1)));
                }
                break;
            }
        }
        return stringBuffer.toString();
    }

    private static char firstChar() {
        return '0';
    }

    private static char lastChar() {
        return 'z';
    }

    private static char previousChar(char c) {
        if (c <= 'A' && c >= ';') {
            return '9';
        }
        if (c <= 'a' && c >= '\\') {
            return 'Z';
        }
        return (char)(c - '\u0001');
    }

    public static String increment(String string, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = true;
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (string.charAt(n2) == DbTasks.lastChar()) continue;
            bl = false;
            break;
        }
        if (bl) {
            if (string.length() >= n) {
                return "0";
            }
            for (n2 = 0; n2 < stringBuffer.length(); ++n2) {
                stringBuffer.setCharAt(n2, DbTasks.firstChar());
            }
            stringBuffer.append('0');
        } else {
            for (n2 = stringBuffer.length() - 1; n2 >= 0; --n2) {
                if (stringBuffer.charAt(n2) < DbTasks.lastChar()) {
                    stringBuffer.setCharAt(n2, DbTasks.nextChar(stringBuffer.charAt(n2)));
                    break;
                }
                stringBuffer.setCharAt(n2, DbTasks.firstChar());
                if (stringBuffer.charAt(n2 - 1) >= DbTasks.lastChar()) continue;
                stringBuffer.setCharAt(n2 - 1, DbTasks.nextChar(stringBuffer.charAt(n2 - 1)));
                break;
            }
        }
        return stringBuffer.toString();
    }

    private static char nextChar(char c) {
        if (c <= '?' && c >= '9') {
            return 'A';
        }
        if (c <= '_' && c >= 'Z') {
            return 'a';
        }
        return (char)(c + '\u0001');
    }

    static void errorPrint(Throwable throwable) {
        if (throwable instanceof SQLException) {
            DbTasks.SQLExceptionPrint((SQLException)throwable);
        } else {
            System.out.println("A non SQL error occured.");
            throwable.printStackTrace();
        }
    }

    static void SQLExceptionPrint(SQLException sQLException) {
        while (sQLException != null) {
            System.out.println("\n---SQLException Caught---\n");
            System.out.println("SQLState:   " + sQLException.getSQLState());
            System.out.println("Severity: " + sQLException.getErrorCode());
            System.out.println("Message:  " + sQLException.getMessage());
            sQLException.printStackTrace();
            sQLException = sQLException.getNextException();
        }
    }
}

