/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.oe.test;

import java.util.HashMap;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.system.oe.client.Display;
import org.apache.derbyTesting.system.oe.client.Operations;
import org.apache.derbyTesting.system.oe.client.Submitter;
import org.apache.derbyTesting.system.oe.direct.Standard;
import org.apache.derbyTesting.system.oe.model.Customer;
import org.apache.derbyTesting.system.oe.model.District;
import org.apache.derbyTesting.system.oe.model.Order;
import org.apache.derbyTesting.system.oe.model.OrderLine;
import org.apache.derbyTesting.system.oe.model.Warehouse;
import org.apache.derbyTesting.system.oe.util.OERandom;

public class OperationsTester
extends BaseJDBCTestCase
implements Display {
    private Operations ops;
    private OERandom rand;
    private final short w = 1;

    public OperationsTester(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.ops = new Standard(this.getConnection());
        this.rand = Submitter.getRuntimeRandom(this.getConnection());
    }

    @Override
    protected void tearDown() throws Exception {
        this.ops.close();
        super.tearDown();
    }

    public void testStockLevel() throws Exception {
        this.ops.stockLevel(null, null, (short)1, this.rand.district(), this.rand.threshold());
        for (int i = 0; i < 20; ++i) {
            short s = this.rand.district();
            int n = this.rand.threshold();
            HashMap<String, Number> hashMap = new HashMap<String, Number>();
            hashMap.put("d", s);
            hashMap.put("threshold", n);
            this.ops.stockLevel(this, hashMap, (short)1, s, n);
            OperationsTester.assertTrue((boolean)hashMap.isEmpty());
        }
    }

    public void testOrderStatus() throws Exception {
        HashMap<String, Object> hashMap;
        short s;
        int n;
        this.ops.orderStatus(null, null, (short)1, this.rand.district(), this.rand.NURand1023());
        for (n = 0; n < 50; ++n) {
            s = this.rand.district();
            int n2 = this.rand.NURand1023();
            hashMap = new HashMap<String, Object>();
            hashMap.put("d", s);
            hashMap.put("c", n2);
            this.ops.orderStatus((Display)this, hashMap, (short)1, s, n2);
            OperationsTester.assertTrue((boolean)hashMap.isEmpty());
        }
        this.ops.orderStatus(null, null, (short)1, this.rand.district(), this.rand.randomCLast());
        for (n = 0; n < 50; ++n) {
            s = this.rand.district();
            String string = this.rand.randomCLast();
            hashMap = new HashMap();
            hashMap.put("d", s);
            hashMap.put("customerLast", string);
            this.ops.orderStatus((Display)this, hashMap, (short)1, s, string);
            OperationsTester.assertTrue((boolean)hashMap.isEmpty());
        }
    }

    public void testPayment() throws Exception {
        int n;
        this.ops.payment(null, null, (short)1, this.rand.district(), (short)1, this.rand.district(), this.rand.randomCLast(), this.rand.payment().toString());
        for (n = 0; n < 50; ++n) {
            this.ops.payment((Display)this, null, (short)1, this.rand.district(), (short)1, this.rand.district(), this.rand.randomCLast(), this.rand.payment().toString());
        }
        this.ops.payment(null, null, (short)1, this.rand.district(), (short)1, this.rand.district(), this.rand.NURand1023(), this.rand.payment().toString());
        for (n = 0; n < 50; ++n) {
            this.ops.payment((Display)this, null, (short)1, this.rand.district(), (short)1, this.rand.district(), this.rand.NURand1023(), this.rand.payment().toString());
        }
    }

    public void testNewOrder() throws Exception {
        for (int i = 0; i < 50; ++i) {
            int n = this.rand.randomInt(5, 15);
            int[] nArray = new int[n];
            short[] sArray = new short[n];
            short[] sArray2 = new short[n];
            boolean bl = this.rand.randomInt(1, 100) == 1;
            for (int j = 0; j < n; ++j) {
                nArray[j] = bl && j == n - 1 ? 500000 : this.rand.NURand8191();
                sArray[j] = (short)this.rand.randomInt(1, 10);
                sArray2[j] = 1;
            }
            this.ops.newOrder(this, null, (short)1, this.rand.district(), this.rand.NURand1023(), nArray, sArray, sArray2);
        }
    }

    public void testScheduleDelivery() throws Exception {
        for (int i = 0; i < 50; ++i) {
            this.ops.scheduleDelivery(this, null, (short)1, this.rand.carrier());
        }
    }

    public void testDelivery() throws Exception {
        this.testScheduleDelivery();
        for (int i = 0; i < 50; ++i) {
            this.ops.delivery();
        }
    }

    @Override
    public void displayStockLevel(Object object, short s, short s2, int n, int n2) throws Exception {
        if (object == null) {
            return;
        }
        HashMap hashMap = (HashMap)object;
        OperationsTester.assertEquals((String)"sl:w", (short)this.w, (short)s);
        OperationsTester.assertEquals((String)"sl:d", (short)((Short)hashMap.get("d")), (short)s2);
        OperationsTester.assertEquals((String)"sl:threshold", (int)((Integer)hashMap.get("threshold")), (int)n);
        OperationsTester.assertTrue((String)"sl:low stock", (n2 >= 0 ? 1 : 0) != 0);
        hashMap.clear();
    }

    @Override
    public void displayOrderStatus(Object object, boolean bl, Customer customer, Order order, OrderLine[] orderLineArray) throws Exception {
        if (object == null) {
            return;
        }
        HashMap hashMap = (HashMap)object;
        OperationsTester.assertEquals((String)"os:w", (short)this.w, (short)customer.getWarehouse());
        OperationsTester.assertEquals((String)"os:d", (short)((Short)hashMap.get("d")), (short)customer.getDistrict());
        if (bl) {
            OperationsTester.assertNotNull(hashMap.get("customerLast"));
        } else {
            OperationsTester.assertNull(hashMap.get("customerLast"));
        }
        hashMap.clear();
    }

    @Override
    public void displayPayment(Object object, String string, boolean bl, Warehouse warehouse, District district, Customer customer) throws Exception {
    }

    @Override
    public void displayNewOrder(Object object, Warehouse warehouse, District district, Customer customer, Order order) throws Exception {
    }

    @Override
    public void displayScheduleDelivery(Object object, short s, short s2) throws Exception {
    }

    public void testSubmitter() throws Exception {
        int n;
        Submitter submitter = new Submitter(this, this.ops, this.rand, 1);
        int n2 = 37;
        for (n = 0; n < n2; ++n) {
            submitter.runTransaction(null);
        }
        n = 47;
        submitter.runTransactions(null, n);
        int[] nArray = submitter.getTransactionCount();
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n3 += nArray[i];
        }
        OperationsTester.assertEquals((String)"Mismatch on Submitter transaction count", (int)(n2 + n), (int)n3);
    }
}

