/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.services;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derbyTesting.unitTests.harness.T_Fail;

public class T_Serviceable
implements Serviceable {
    protected int timesServiced = 0;
    protected final int timesRequeue;
    protected final boolean onDemandOnly;
    protected final boolean subscribed;
    protected int clientNumber;

    public T_Serviceable(int n) {
        this.timesRequeue = n;
        this.onDemandOnly = false;
        this.subscribed = false;
        this.clientNumber = -1;
    }

    public T_Serviceable(boolean bl) {
        this.timesRequeue = 0;
        this.onDemandOnly = bl;
        this.subscribed = true;
    }

    protected void setClientNumber(int n) {
        this.clientNumber = n;
    }

    protected int getClientNumber() {
        return this.clientNumber;
    }

    public synchronized int performWork(ContextManager contextManager) {
        contextManager.toString();
        ++this.timesServiced;
        this.notifyAll();
        if (!this.subscribed && this.timesRequeue > this.timesServiced) {
            return 2;
        }
        return 1;
    }

    public boolean serviceASAP() {
        return true;
    }

    public boolean serviceImmediately() {
        return false;
    }

    protected synchronized void t_wait(int n) {
        try {
            while (this.timesServiced < n) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected synchronized void t_check(int n) throws T_Fail {
        if (this.timesServiced != n) {
            throw T_Fail.testFailMsg("Expect to be serviced " + n + " times, instead serviced " + this.timesServiced);
        }
    }
}

