/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;
import org.apache.derby.impl.drda.CcsidManager;
import org.apache.derby.impl.drda.CodePointNameTable;
import org.apache.derby.impl.drda.DDMReader;
import org.apache.derby.impl.drda.DDMWriter;
import org.apache.derby.impl.drda.DRDAProtocolException;
import org.apache.derby.impl.drda.EbcdicCcsidManager;

public class ProtocolTestAdapter {
    public static final byte SPACE = new EbcdicCcsidManager().space;
    public static final int CP_SQLCARD = 9224;
    public static final int CP_SVRCOD = 4425;
    public static final int CP_CODPNT = 12;
    public static final int CP_PRCCNVCD = 4415;
    public static final int CP_SYNERRCD = 4426;
    public static final int CP_MGRLVLLS = 5124;
    public static final int CP_PRCCNVRM = 4677;
    public static final int CP_SYNTAXRM = 4684;
    public static final int CP_MGRLVLRM = 4624;
    public static final int CP_SECMEC = 4514;
    public static final int CP_SECCHKCD = 4516;
    private static final CodePointNameTable CP_NAMES = new CodePointNameTable();
    private final CcsidManager ccsidManager = new EbcdicCcsidManager();
    private final DDMWriter writer = new DDMWriter(null, null);
    private final Socket socket;
    private final DDMReader reader;
    private final OutputStream out;

    public ProtocolTestAdapter(Socket socket) throws IOException {
        this.socket = socket;
        this.reader = new DDMReader(socket.getInputStream());
        this.out = socket.getOutputStream();
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public String lookupCodePoint(int n) {
        return CP_NAMES.lookup(n);
    }

    public Integer decodeCodePoint(String string) {
        for (Map.Entry entry : CP_NAMES.entrySet()) {
            if (!string.equals((String)entry.getValue())) continue;
            return (Integer)entry.getKey();
        }
        return null;
    }

    public byte[] convertFromJavaString(String string) {
        return this.ccsidManager.convertFromJavaString(string);
    }

    public void setUtf8Ccsid() {
        this.writer.setUtf8Ccsid();
        this.reader.setUtf8Ccsid();
    }

    public void wCreateDssRequest() {
        this.writer.createDssRequest();
    }

    public void wCreateDssObject() {
        this.writer.createDssObject();
    }

    public void wCreateDssReply() {
        this.writer.createDssReply();
    }

    public void wEndDss() {
        this.writer.endDss();
    }

    public void wEndDss(byte by) {
        this.writer.endDss(by);
    }

    public void wEndDdm() {
        this.writer.endDdm();
    }

    public void wEndDdmAndDss() {
        this.writer.endDdmAndDss();
    }

    public void wStartDdm(int n) {
        this.writer.startDdm(n);
    }

    public void wWriteScalarString(int n, String string) {
        this.writer.writeScalarString(n, string);
    }

    public void wWriteScalar2Bytes(int n, int n2) {
        this.writer.writeScalar2Bytes(n, n2);
    }

    public void wWriteScalar1Byte(int n, int n2) {
        this.writer.writeScalar1Byte(n, n2);
    }

    public void wWriteScalarBytes(int n, byte[] byArray) {
        this.writer.writeScalarBytes(n, byArray);
    }

    public void wWriteScalarPaddedBytes(int n, byte[] byArray, int n2, byte by) {
        this.writer.writeScalarPaddedBytes(n, byArray, n2, by);
    }

    public void wWriteByte(int n) {
        this.writer.writeByte(n);
    }

    public void wWriteBytes(byte[] byArray) {
        this.writer.writeBytes(byArray);
    }

    public void wWriteShort(int n) {
        this.writer.writeShort(n);
    }

    public void wWriteInt(int n) {
        this.writer.writeInt(n);
    }

    public void wWriteCodePoint4Bytes(int n, int n2) {
        this.writer.writeCodePoint4Bytes(n, n2);
    }

    public void wPadBytes(byte by, int n) {
        this.writer.padBytes(by, n);
    }

    public void wFlush() throws IOException {
        try {
            this.writer.finalizeChain(this.reader.getCurrChainState(), this.out);
        }
        catch (DRDAProtocolException dRDAProtocolException) {
            throw ProtocolTestAdapter.wrap(dRDAProtocolException);
        }
        this.writer.reset(null);
    }

    public void rReadReplyDss() throws IOException {
        try {
            this.reader.readReplyDss();
        }
        catch (DRDAProtocolException dRDAProtocolException) {
            throw ProtocolTestAdapter.wrap(dRDAProtocolException);
        }
    }

    public void rSkipDss() throws IOException {
        try {
            this.reader.readReplyDss();
            this.reader.skipDss();
        }
        catch (DRDAProtocolException dRDAProtocolException) {
            throw ProtocolTestAdapter.wrap(dRDAProtocolException);
        }
    }

    public void rSkipDdm() throws IOException {
        try {
            this.reader.readLengthAndCodePoint(false);
            this.reader.skipBytes();
        }
        catch (DRDAProtocolException dRDAProtocolException) {
            throw ProtocolTestAdapter.wrap(dRDAProtocolException);
        }
    }

    public void rSkipBytes() throws IOException {
        try {
            this.reader.skipBytes();
        }
        catch (DRDAProtocolException dRDAProtocolException) {
            throw ProtocolTestAdapter.wrap(dRDAProtocolException);
        }
    }

    public boolean rMoreData() {
        return this.reader.moreData();
    }

    public boolean rMoreDssData() {
        return this.reader.moreDssData();
    }

    public boolean rMoreDdmData() {
        return this.reader.moreDssData();
    }

    public int rReadNetworkShort() throws IOException {
        try {
            return this.reader.readNetworkShort();
        }
        catch (DRDAProtocolException dRDAProtocolException) {
            throw ProtocolTestAdapter.wrap(dRDAProtocolException);
        }
    }

    public byte rReadByte() throws IOException {
        try {
            return this.reader.readByte();
        }
        catch (DRDAProtocolException dRDAProtocolException) {
            throw ProtocolTestAdapter.wrap(dRDAProtocolException);
        }
    }

    public byte[] rReadBytes() throws IOException {
        try {
            return this.reader.readBytes();
        }
        catch (DRDAProtocolException dRDAProtocolException) {
            throw ProtocolTestAdapter.wrap(dRDAProtocolException);
        }
    }

    public int rReadLengthAndCodePoint(boolean bl) throws IOException {
        try {
            return this.reader.readLengthAndCodePoint(bl);
        }
        catch (DRDAProtocolException dRDAProtocolException) {
            throw ProtocolTestAdapter.wrap(dRDAProtocolException);
        }
    }

    public int rReadNetworkInt() throws IOException {
        try {
            return this.reader.readNetworkInt();
        }
        catch (DRDAProtocolException dRDAProtocolException) {
            throw ProtocolTestAdapter.wrap(dRDAProtocolException);
        }
    }

    public String rReadString(int n, String string) throws IOException {
        try {
            return this.reader.readString(n, string);
        }
        catch (DRDAProtocolException dRDAProtocolException) {
            throw ProtocolTestAdapter.wrap(dRDAProtocolException);
        }
    }

    private static IOException wrap(DRDAProtocolException dRDAProtocolException) {
        IOException iOException = new IOException(dRDAProtocolException.getMessage());
        iOException.initCause(dRDAProtocolException);
        return iOException;
    }
}

