/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulDisconnect;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.AbstractExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulDisconnect.GracefulDisconnectResponseContainer;
import org.apache.directory.api.ldap.extras.extended.gracefulDisconnect.GracefulDisconnectResponse;
import org.apache.directory.api.ldap.extras.extended.gracefulDisconnect.GracefulDisconnectResponseImpl;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;

public class GracefulDisconnectFactory
extends AbstractExtendedOperationFactory {
    public GracefulDisconnectFactory(LdapApiService codec) {
        super(codec, "1.3.6.1.4.1.18060.0.1.5");
    }

    public ExtendedRequest newRequest() {
        return null;
    }

    public GracefulDisconnectResponse newResponse() {
        return new GracefulDisconnectResponseImpl();
    }

    public GracefulDisconnectResponse newResponse(byte[] encodedValue) throws DecoderException {
        GracefulDisconnectResponseImpl gracefulDisconnectResponse = new GracefulDisconnectResponseImpl();
        this.decodeValue((ExtendedResponse)gracefulDisconnectResponse, encodedValue);
        return gracefulDisconnectResponse;
    }

    public void decodeValue(ExtendedResponse extendedResponse, byte[] requestValue) throws DecoderException {
        ByteBuffer bb = ByteBuffer.wrap(requestValue);
        GracefulDisconnectResponseContainer container = new GracefulDisconnectResponseContainer();
        container.setGracefulDisconnectResponse((GracefulDisconnectResponse)extendedResponse);
        Asn1Decoder.decode((ByteBuffer)bb, (Asn1Container)container);
    }

    private void encodeUrls(Asn1Buffer buffer, Iterator<String> urls) {
        if (urls.hasNext()) {
            String url = urls.next();
            this.encodeUrls(buffer, urls);
            BerValue.encodeOctetString((Asn1Buffer)buffer, (String)url);
        }
    }

    public void encodeValue(Asn1Buffer buffer, ExtendedResponse extendedResponse) {
        Collection urls;
        int start = buffer.getPos();
        GracefulDisconnectResponse gracefulDisconnectResponse = (GracefulDisconnectResponse)extendedResponse;
        if (gracefulDisconnectResponse.getReplicatedContexts() != null && (urls = gracefulDisconnectResponse.getReplicatedContexts().getLdapUrls()).size() != 0) {
            this.encodeUrls(buffer, urls.iterator());
            BerValue.encodeSequence((Asn1Buffer)buffer, (int)start);
        }
        if (gracefulDisconnectResponse.getDelay() != 0) {
            BerValue.encodeInteger((Asn1Buffer)buffer, (byte)-128, (int)gracefulDisconnectResponse.getDelay());
        }
        if (gracefulDisconnectResponse.getTimeOffline() != 0) {
            BerValue.encodeInteger((Asn1Buffer)buffer, (int)gracefulDisconnectResponse.getTimeOffline());
        }
        BerValue.encodeSequence((Asn1Buffer)buffer, (int)start);
    }
}

