/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.trigger;

import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapContext;
import org.apache.directory.api.ldap.model.entry.AttributeUtils;

public final class TriggerUtils {
    private TriggerUtils() {
    }

    public static void defineTriggerExecutionSpecificPoint(LdapContext apCtx) throws NamingException {
        Attributes ap = apCtx.getAttributes("", new String[]{"administrativeRole"});
        Attribute administrativeRole = ap.get("administrativeRole");
        if (administrativeRole == null || !AttributeUtils.containsValueCaseIgnore((Attribute)administrativeRole, (Object)"triggerExecutionSpecificArea")) {
            BasicAttributes changes = new BasicAttributes("administrativeRole", "triggerExecutionSpecificArea", true);
            apCtx.modifyAttributes("", 1, (Attributes)changes);
        }
    }

    public static void createTriggerExecutionSubentry(LdapContext apCtx, String subentryCN, String subtreeSpec, String prescriptiveTriggerSpec) throws NamingException {
        BasicAttributes subentry = new BasicAttributes("cn", subentryCN, true);
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        subentry.put(objectClass);
        objectClass.add("top");
        objectClass.add("subentry");
        objectClass.add("triggerExecutionSubentry");
        subentry.put("subtreeSpecification", subtreeSpec);
        subentry.put("prescriptiveTriggerSpecification", prescriptiveTriggerSpec);
        apCtx.createSubcontext("cn=" + subentryCN, (Attributes)subentry);
    }

    public static void loadPrescriptiveTriggerSpecification(LdapContext apCtx, String subentryCN, String triggerSpec) throws NamingException {
        BasicAttributes changes = new BasicAttributes("prescriptiveTriggerSpecification", triggerSpec, true);
        apCtx.modifyAttributes("cn=" + subentryCN, 1, (Attributes)changes);
    }

    public static void loadEntryTriggerSpecification(LdapContext ctx, String triggerSpec) throws NamingException {
        BasicAttributes changes = new BasicAttributes("entryTriggerSpecification", triggerSpec, true);
        ctx.modifyAttributes("", 1, (Attributes)changes);
    }
}

