/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;

public class DependencyMap {
    private ListMultiMap<String, ITestNGMethod> m_dependencies = Maps.newListMultiMap();
    private ListMultiMap<String, ITestNGMethod> m_groups = Maps.newListMultiMap();

    public DependencyMap(ITestNGMethod[] iTestNGMethodArray) {
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            this.m_dependencies.put(iTestNGMethod.getQualifiedName(), iTestNGMethod);
            for (String string : iTestNGMethod.getGroups()) {
                this.m_groups.put(string, iTestNGMethod);
            }
        }
    }

    public List<ITestNGMethod> getMethodsThatBelongTo(String string, ITestNGMethod iTestNGMethod) {
        Set set = this.m_groups.keySet();
        List<ITestNGMethod> list = Lists.newArrayList();
        for (String string2 : set) {
            if (!Pattern.matches(string, string2)) continue;
            list.addAll((Collection<ITestNGMethod>)this.m_groups.get(string2));
        }
        if (list.isEmpty() && !iTestNGMethod.ignoreMissingDependencies()) {
            throw new TestNGException("DependencyMap::Method \"" + iTestNGMethod + "\" depends on nonexistent group \"" + string + "\"");
        }
        return list;
    }

    public ITestNGMethod getMethodDependingOn(String string, ITestNGMethod iTestNGMethod) {
        List list = (List)this.m_dependencies.get(string);
        if (list.isEmpty()) {
            list = (List)this.m_dependencies.get(DependencyMap.constructMethodNameUsingTestClass(string, iTestNGMethod));
        }
        if (list.isEmpty() && iTestNGMethod.ignoreMissingDependencies()) {
            return iTestNGMethod;
        }
        for (ITestNGMethod iTestNGMethod2 : list) {
            if (iTestNGMethod.getRealClass().isAssignableFrom(iTestNGMethod2.getRealClass())) {
                if (iTestNGMethod2.getInstance() != iTestNGMethod.getInstance()) continue;
                return iTestNGMethod2;
            }
            return iTestNGMethod2;
        }
        throw new TestNGException("Method \"" + iTestNGMethod + "\" depends on nonexistent method \"" + string + "\"");
    }

    private static String constructMethodNameUsingTestClass(String string, ITestNGMethod iTestNGMethod) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            return iTestNGMethod.getTestClass().getRealClass().getName() + string.substring(n);
        }
        return string;
    }
}

