/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.constraints;

import java.util.List;
import org.apache.helix.controller.rebalancer.waged.constraints.HardConstraint;
import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.controller.rebalancer.waged.model.ClusterContext;

class ReplicaActivateConstraint
extends HardConstraint {
    ReplicaActivateConstraint() {
    }

    @Override
    boolean isAssignmentValid(AssignableNode node, AssignableReplica replica, ClusterContext clusterContext) {
        List<String> disabledPartitions = node.getDisabledPartitionsMap().get(replica.getResourceName());
        return disabledPartitions == null || !disabledPartitions.contains(replica.getPartitionName());
    }

    @Override
    String getDescription() {
        return "Cannot assign the inactive replica";
    }
}

