/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixException;
import org.apache.helix.InstanceType;
import org.apache.helix.PropertyPathBuilder;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.msdcommon.exception.InvalidRoutingDataException;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.impl.client.FederatedZkClient;
import org.apache.helix.zookeeper.impl.factory.DedicatedZkClientFactory;
import org.apache.helix.zookeeper.zkclient.DataUpdater;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZKUtil {
    private static Logger logger = LoggerFactory.getLogger(ZKUtil.class);
    private static int RETRYLIMIT = 3;

    private ZKUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isClusterSetup(String clusterName, String zkAddress) {
        boolean result;
        try (RealmAwareZkClient zkClient = ZKUtil.getHelixZkClient(zkAddress);){
            result = ZKUtil.isClusterSetup(clusterName, zkClient);
        }
        return result;
    }

    public static boolean isClusterSetup(String clusterName, RealmAwareZkClient zkClient) {
        if (clusterName == null) {
            logger.info("Fail to check cluster setup : cluster name is null!");
            return false;
        }
        if (zkClient == null) {
            logger.info("Fail to check cluster setup : zookeeper client is null!");
            return false;
        }
        ArrayList<String> requiredPaths = new ArrayList<String>();
        requiredPaths.add(PropertyPathBuilder.idealState(clusterName));
        requiredPaths.add(PropertyPathBuilder.clusterConfig(clusterName));
        requiredPaths.add(PropertyPathBuilder.instanceConfig(clusterName));
        requiredPaths.add(PropertyPathBuilder.resourceConfig(clusterName));
        requiredPaths.add(PropertyPathBuilder.propertyStore(clusterName));
        requiredPaths.add(PropertyPathBuilder.liveInstance(clusterName));
        requiredPaths.add(PropertyPathBuilder.instance(clusterName));
        requiredPaths.add(PropertyPathBuilder.externalView(clusterName));
        requiredPaths.add(PropertyPathBuilder.controller(clusterName));
        requiredPaths.add(PropertyPathBuilder.stateModelDef(clusterName));
        requiredPaths.add(PropertyPathBuilder.controllerMessage(clusterName));
        requiredPaths.add(PropertyPathBuilder.controllerError(clusterName));
        requiredPaths.add(PropertyPathBuilder.controllerStatusUpdate(clusterName));
        requiredPaths.add(PropertyPathBuilder.controllerHistory(clusterName));
        boolean isValid = true;
        boolean[] ret = new boolean[requiredPaths.size()];
        for (int i = 0; i < requiredPaths.size(); ++i) {
            try {
                ret[i] = zkClient.exists((String)requiredPaths.get(i));
                continue;
            }
            catch (Exception e) {
                ret[i] = false;
            }
        }
        StringBuilder errorMsg = new StringBuilder();
        for (int i = 0; i < ret.length; ++i) {
            if (ret[i]) continue;
            isValid = false;
            errorMsg.append("Invalid cluster setup for cluster: ").append(clusterName).append(", missing znode path: ").append((String)requiredPaths.get(i)).append("\n");
        }
        if (!isValid) {
            logger.warn(errorMsg.toString());
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInstanceSetup(String zkAddress, String clusterName, String instanceName, InstanceType type) {
        boolean result;
        try (RealmAwareZkClient zkClient = ZKUtil.getHelixZkClient(zkAddress);){
            result = ZKUtil.isInstanceSetup(zkClient, clusterName, instanceName, type);
        }
        return result;
    }

    public static boolean isInstanceSetup(RealmAwareZkClient zkclient, String clusterName, String instanceName, InstanceType type) {
        if (type == InstanceType.PARTICIPANT || type == InstanceType.CONTROLLER_PARTICIPANT) {
            String historyPath;
            ArrayList<String> requiredPaths = new ArrayList<String>();
            requiredPaths.add(PropertyPathBuilder.instanceConfig(clusterName, instanceName));
            requiredPaths.add(PropertyPathBuilder.instanceMessage(clusterName, instanceName));
            requiredPaths.add(PropertyPathBuilder.instanceCurrentState(clusterName, instanceName));
            requiredPaths.add(PropertyPathBuilder.instanceStatusUpdate(clusterName, instanceName));
            requiredPaths.add(PropertyPathBuilder.instanceError(clusterName, instanceName));
            boolean isValid = true;
            for (String path : requiredPaths) {
                if (zkclient.exists(path)) continue;
                isValid = false;
                logger.info("Invalid instance setup, missing znode path: {}", (Object)path);
            }
            if (isValid && !zkclient.exists(historyPath = PropertyPathBuilder.instanceHistory(clusterName, instanceName))) {
                zkclient.createPersistent(historyPath, true);
            }
            return isValid;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createChildren(String zkAddress, String parentPath, List<ZNRecord> list) {
        try (RealmAwareZkClient zkClient = ZKUtil.getHelixZkClient(zkAddress);){
            ZKUtil.createChildren(zkClient, parentPath, list);
        }
    }

    public static void createChildren(RealmAwareZkClient client, String parentPath, List<ZNRecord> list) {
        client.createPersistent(parentPath, true);
        if (list != null) {
            for (ZNRecord record : list) {
                ZKUtil.createChildren(client, parentPath, record);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createChildren(String zkAddress, String parentPath, ZNRecord nodeRecord) {
        try (RealmAwareZkClient zkClient = ZKUtil.getHelixZkClient(zkAddress);){
            ZKUtil.createChildren(zkClient, parentPath, nodeRecord);
        }
    }

    public static void createChildren(RealmAwareZkClient client, String parentPath, ZNRecord nodeRecord) {
        client.createPersistent(parentPath, true);
        String id = nodeRecord.getId();
        String temp = parentPath + "/" + id;
        client.createPersistent(temp, nodeRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropChildren(String zkAddress, String parentPath, List<ZNRecord> list) {
        try (RealmAwareZkClient zkClient = ZKUtil.getHelixZkClient(zkAddress);){
            ZKUtil.dropChildren(zkClient, parentPath, list);
        }
    }

    public static void dropChildren(RealmAwareZkClient client, String parentPath, List<ZNRecord> list) {
        if (list != null) {
            for (ZNRecord record : list) {
                ZKUtil.dropChildren(client, parentPath, record);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropChildren(String zkAddress, String parentPath, ZNRecord nodeRecord) {
        try (RealmAwareZkClient zkClient = ZKUtil.getHelixZkClient(zkAddress);){
            ZKUtil.dropChildren(zkClient, parentPath, nodeRecord);
        }
    }

    public static void dropChildren(RealmAwareZkClient client, String parentPath, ZNRecord nodeRecord) {
        String id = nodeRecord.getId();
        String temp = parentPath + "/" + id;
        client.deleteRecursively(temp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ZNRecord> getChildren(String zkAddress, String path) {
        List<ZNRecord> result;
        try (RealmAwareZkClient zkClient = ZKUtil.getHelixZkClient(zkAddress);){
            result = ZKUtil.getChildren(zkClient, path);
        }
        return result;
    }

    public static List<ZNRecord> getChildren(RealmAwareZkClient client, String path) {
        List<String> children = client.getChildren(path);
        if (children == null || children.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ZNRecord> childRecords = new ArrayList<ZNRecord>();
        for (String child : children) {
            Stat newStat;
            String childPath = path + "/" + child;
            ZNRecord record = (ZNRecord)client.readDataAndStat(childPath, newStat = new Stat(), true);
            if (record == null) continue;
            record.setVersion(newStat.getVersion());
            record.setCreationTime(newStat.getCtime());
            record.setModifiedTime(newStat.getMtime());
            record.setEphemeralOwner(newStat.getEphemeralOwner());
            childRecords.add(record);
        }
        return childRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateIfExists(String zkAddress, String path, ZNRecord record, boolean mergeOnUpdate) {
        try (RealmAwareZkClient zkClient = ZKUtil.getHelixZkClient(zkAddress);){
            ZKUtil.updateIfExists(zkClient, path, record, mergeOnUpdate);
        }
    }

    public static void updateIfExists(RealmAwareZkClient client, String path, final ZNRecord record, boolean mergeOnUpdate) {
        if (client.exists(path)) {
            DataUpdater<Object> updater = new DataUpdater<Object>(){

                @Override
                public Object update(Object currentData) {
                    return record;
                }
            };
            client.updateDataSerialized(path, updater);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createOrMerge(String zkAddress, String path, ZNRecord record, boolean persistent, boolean mergeOnUpdate) {
        try (RealmAwareZkClient zkClient = ZKUtil.getHelixZkClient(zkAddress);){
            ZKUtil.createOrMerge(zkClient, path, record, persistent, mergeOnUpdate);
        }
    }

    public static void createOrMerge(RealmAwareZkClient client, String path, final ZNRecord record, boolean persistent, final boolean mergeOnUpdate) {
        for (int retryCount = 0; retryCount < RETRYLIMIT; ++retryCount) {
            try {
                CreateMode mode;
                if (client.exists(path)) {
                    DataUpdater<ZNRecord> updater = new DataUpdater<ZNRecord>(){

                        @Override
                        public ZNRecord update(ZNRecord currentData) {
                            if (currentData != null && mergeOnUpdate) {
                                currentData.merge(record);
                                return currentData;
                            }
                            return record;
                        }
                    };
                    client.updateDataSerialized(path, updater);
                    break;
                }
                CreateMode createMode = mode = persistent ? CreateMode.PERSISTENT : CreateMode.EPHEMERAL;
                if (record.getDeltaList().size() > 0) {
                    ZNRecord value = new ZNRecord(record.getId());
                    value.merge(record);
                    client.create(path, value, mode);
                    break;
                }
                client.create(path, record, mode);
                break;
            }
            catch (Exception e) {
                logger.warn("Exception trying to update " + path + " Exception:" + e.getMessage() + ". Will retry.");
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createOrUpdate(String zkAddress, String path, ZNRecord record, boolean persistent, boolean mergeOnUpdate) {
        try (RealmAwareZkClient zkClient = ZKUtil.getHelixZkClient(zkAddress);){
            ZKUtil.createOrUpdate(zkClient, path, record, persistent, mergeOnUpdate);
        }
    }

    public static void createOrUpdate(RealmAwareZkClient client, String path, final ZNRecord record, boolean persistent, final boolean mergeOnUpdate) {
        for (int retryCount = 0; retryCount < RETRYLIMIT; ++retryCount) {
            try {
                if (client.exists(path)) {
                    DataUpdater<ZNRecord> updater = new DataUpdater<ZNRecord>(){

                        @Override
                        public ZNRecord update(ZNRecord currentData) {
                            if (currentData != null && mergeOnUpdate) {
                                currentData.update(record);
                                return currentData;
                            }
                            return record;
                        }
                    };
                    client.updateDataSerialized(path, updater);
                    break;
                }
                CreateMode mode = persistent ? CreateMode.PERSISTENT : CreateMode.EPHEMERAL;
                client.create(path, record, mode);
                break;
            }
            catch (Exception e) {
                logger.warn("Exception trying to update " + path + " Exception:" + e.getMessage() + ". Will retry.");
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void asyncCreateOrMerge(String zkAddress, String path, ZNRecord record, boolean persistent, boolean mergeOnUpdate) {
        try (RealmAwareZkClient zkClient = ZKUtil.getHelixZkClient(zkAddress);){
            ZKUtil.asyncCreateOrMerge(zkClient, path, record, persistent, mergeOnUpdate);
        }
    }

    public static void asyncCreateOrMerge(RealmAwareZkClient client, String path, ZNRecord record, boolean persistent, boolean mergeOnUpdate) {
        try {
            if (client.exists(path)) {
                if (mergeOnUpdate) {
                    ZNRecord curRecord = (ZNRecord)client.readData(path);
                    if (curRecord != null) {
                        curRecord.merge(record);
                        client.asyncSetData(path, curRecord, -1, null);
                    } else {
                        client.asyncSetData(path, record, -1, null);
                    }
                } else {
                    client.asyncSetData(path, record, -1, null);
                }
            } else {
                CreateMode mode;
                CreateMode createMode = mode = persistent ? CreateMode.PERSISTENT : CreateMode.EPHEMERAL;
                if (record.getDeltaList().size() > 0) {
                    ZNRecord newRecord = new ZNRecord(record.getId());
                    newRecord.merge(record);
                    client.create(path, null, mode);
                    client.asyncSetData(path, newRecord, -1, null);
                } else {
                    client.create(path, null, mode);
                    client.asyncSetData(path, record, -1, null);
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception in async create or update " + path + ". Exception: " + e.getMessage() + ". Give up.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createOrReplace(String zkAddress, String path, ZNRecord record, boolean persistent) {
        try (RealmAwareZkClient zkClient = ZKUtil.getHelixZkClient(zkAddress);){
            ZKUtil.createOrReplace(zkClient, path, record, persistent);
        }
    }

    public static void createOrReplace(RealmAwareZkClient client, String path, final ZNRecord record, boolean persistent) {
        for (int retryCount = 0; retryCount < RETRYLIMIT; ++retryCount) {
            try {
                if (client.exists(path)) {
                    DataUpdater<Object> updater = new DataUpdater<Object>(){

                        @Override
                        public Object update(Object currentData) {
                            return record;
                        }
                    };
                    client.updateDataSerialized(path, updater);
                    break;
                }
                CreateMode mode = persistent ? CreateMode.PERSISTENT : CreateMode.EPHEMERAL;
                client.create(path, record, mode);
                break;
            }
            catch (Exception e) {
                logger.warn("Exception trying to createOrReplace " + path + " Exception:" + e.getMessage() + ". Will retry.");
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void subtract(String zkAddress, String path, ZNRecord recordTosubtract) {
        try (RealmAwareZkClient zkClient = ZKUtil.getHelixZkClient(zkAddress);){
            ZKUtil.subtract(zkClient, path, recordTosubtract);
        }
    }

    public static void subtract(RealmAwareZkClient client, final String path, final ZNRecord recordTosubtract) {
        int retryCount = 0;
        while (retryCount < RETRYLIMIT) {
            try {
                if (!client.exists(path)) continue;
                DataUpdater<ZNRecord> updater = new DataUpdater<ZNRecord>(){

                    @Override
                    public ZNRecord update(ZNRecord currentData) {
                        if (currentData == null) {
                            throw new HelixException(String.format("subtract DataUpdater: ZNode at path %s is not found!", path));
                        }
                        currentData.subtract(recordTosubtract);
                        return currentData;
                    }
                };
                client.updateDataSerialized(path, updater);
                break;
            }
            catch (Exception e) {
                ++retryCount;
                logger.warn("Exception trying to createOrReplace " + path + ". Will retry.", (Throwable)e);
            }
        }
    }

    public static String toHexSessionId(long sessionId) {
        return Long.toHexString(sessionId);
    }

    private static RealmAwareZkClient getHelixZkClient(String zkAddr) {
        if (Boolean.getBoolean("helix.multiZkEnabled") || zkAddr == null) {
            try {
                RealmAwareZkClient.RealmAwareZkConnectionConfig connectionConfig = new RealmAwareZkClient.RealmAwareZkConnectionConfig.Builder().build();
                RealmAwareZkClient.RealmAwareZkClientConfig clientConfig = new RealmAwareZkClient.RealmAwareZkClientConfig();
                return new FederatedZkClient(connectionConfig, clientConfig);
            }
            catch (IllegalArgumentException | InvalidRoutingDataException e) {
                throw new HelixException("Not able to connect on realm-aware mode", e);
            }
        }
        if (zkAddr.isEmpty()) {
            throw new HelixException("ZK Address given is empty!");
        }
        HelixZkClient.ZkClientConfig clientConfig = new HelixZkClient.ZkClientConfig();
        clientConfig.setZkSerializer(new ZNRecordSerializer());
        return DedicatedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(zkAddr), clientConfig);
    }

    public static Map<String, String> fromStatToMap(Stat stat) {
        if (stat == null) {
            throw new HelixException("Stat cannot be null!");
        }
        HashMap<String, String> statMap = new HashMap<String, String>();
        statMap.put("czxid", Long.toString(stat.getCzxid()));
        statMap.put("mzxid", Long.toString(stat.getMzxid()));
        statMap.put("ctime", Long.toString(stat.getCtime()));
        statMap.put("mtime", Long.toString(stat.getMtime()));
        statMap.put("version", Integer.toString(stat.getVersion()));
        statMap.put("cversion", Integer.toString(stat.getCversion()));
        statMap.put("aversion", Integer.toString(stat.getAversion()));
        statMap.put("ephemeralOwner", Long.toString(stat.getEphemeralOwner()));
        statMap.put("dataLength", Integer.toString(stat.getDataLength()));
        statMap.put("numChildren", Integer.toString(stat.getNumChildren()));
        statMap.put("pzxid", Long.toString(stat.getPzxid()));
        return statMap;
    }
}

