/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.builder.ConfigScopeBuilder;
import org.apache.helix.util.StringTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ConfigScope {
    private static Logger LOG = LoggerFactory.getLogger(ConfigScope.class);
    private static final List<HelixConfigScope.ConfigScopeProperty> scopePriority = new ArrayList<HelixConfigScope.ConfigScopeProperty>();
    private static final Map<HelixConfigScope.ConfigScopeProperty, Map<HelixConfigScope.ConfigScopeProperty, HelixConfigScope.ConfigScopeProperty>> scopeTransition = new HashMap<HelixConfigScope.ConfigScopeProperty, Map<HelixConfigScope.ConfigScopeProperty, HelixConfigScope.ConfigScopeProperty>>();
    private static final StringTemplate template = new StringTemplate();
    private final String _clusterName;
    private final HelixConfigScope.ConfigScopeProperty _scope;
    private final String _scopeStr;

    public ConfigScope(ConfigScopeBuilder configScopeBuilder) {
        Map<HelixConfigScope.ConfigScopeProperty, String> scopeMap = configScopeBuilder.getScopeMap();
        ArrayList<String> keys = new ArrayList<String>();
        HelixConfigScope.ConfigScopeProperty curScope = null;
        for (HelixConfigScope.ConfigScopeProperty scope : scopePriority) {
            if (!scopeMap.containsKey((Object)scope)) continue;
            if (curScope == null && scope == HelixConfigScope.ConfigScopeProperty.CLUSTER) {
                keys.add(scopeMap.get((Object)scope));
                curScope = HelixConfigScope.ConfigScopeProperty.CLUSTER;
                continue;
            }
            if (curScope == null) {
                throw new IllegalArgumentException("Missing CLUSTER scope. Can't build scope using " + configScopeBuilder);
            }
            if (!scopeTransition.containsKey((Object)curScope) || !scopeTransition.get((Object)curScope).containsKey((Object)scope)) {
                throw new IllegalArgumentException("Can't build scope using " + configScopeBuilder);
            }
            keys.add(scopeMap.get((Object)scope));
            curScope = scopeTransition.get((Object)curScope).get((Object)scope);
        }
        if (curScope == HelixConfigScope.ConfigScopeProperty.CLUSTER) {
            keys.add(scopeMap.get((Object)HelixConfigScope.ConfigScopeProperty.CLUSTER));
        }
        String scopeStr = template.instantiate(curScope, keys.toArray(new String[0]));
        this._clusterName = (String)keys.get(0);
        this._scopeStr = scopeStr;
        this._scope = curScope;
    }

    public HelixConfigScope.ConfigScopeProperty getScope() {
        return this._scope;
    }

    public String getClusterName() {
        return this._clusterName;
    }

    public String getScopeStr() {
        return this._scopeStr;
    }

    public String toString() {
        return super.toString() + ": " + this._scopeStr;
    }

    static {
        scopePriority.add(HelixConfigScope.ConfigScopeProperty.CLUSTER);
        scopePriority.add(HelixConfigScope.ConfigScopeProperty.PARTICIPANT);
        scopePriority.add(HelixConfigScope.ConfigScopeProperty.RESOURCE);
        scopePriority.add(HelixConfigScope.ConfigScopeProperty.PARTITION);
        scopeTransition.put(HelixConfigScope.ConfigScopeProperty.CLUSTER, new HashMap());
        scopeTransition.get((Object)HelixConfigScope.ConfigScopeProperty.CLUSTER).put(HelixConfigScope.ConfigScopeProperty.PARTICIPANT, HelixConfigScope.ConfigScopeProperty.PARTICIPANT);
        scopeTransition.get((Object)HelixConfigScope.ConfigScopeProperty.CLUSTER).put(HelixConfigScope.ConfigScopeProperty.RESOURCE, HelixConfigScope.ConfigScopeProperty.RESOURCE);
        scopeTransition.put(HelixConfigScope.ConfigScopeProperty.RESOURCE, new HashMap());
        scopeTransition.get((Object)HelixConfigScope.ConfigScopeProperty.RESOURCE).put(HelixConfigScope.ConfigScopeProperty.PARTITION, HelixConfigScope.ConfigScopeProperty.PARTITION);
        template.addEntry(HelixConfigScope.ConfigScopeProperty.CLUSTER, 2, "/{clusterName}/CONFIGS/CLUSTER/{clusterName}");
        template.addEntry(HelixConfigScope.ConfigScopeProperty.PARTICIPANT, 2, "/{clusterName}/CONFIGS/PARTICIPANT/{participantName}");
        template.addEntry(HelixConfigScope.ConfigScopeProperty.RESOURCE, 2, "/{clusterName}/CONFIGS/RESOURCE/{resourceName}");
        template.addEntry(HelixConfigScope.ConfigScopeProperty.PARTITION, 3, "/{clusterName}/CONFIGS/RESOURCE/{resourceName}|{partitionName}");
    }
}

