/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.agent;

import java.util.HashMap;
import java.util.Map;

public enum CommandAttribute {
    COMMAND("command"),
    WORKING_DIR("command.workingDir"),
    TIMEOUT("command.timeout"),
    PID_FILE("command.pidFile"),
    NOP("nop");

    private static final Map<String, CommandAttribute> map;
    private final String _name;

    private CommandAttribute(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public static CommandAttribute getCommandAttributeByName(String name) {
        return map.get(name);
    }

    static {
        map = new HashMap<String, CommandAttribute>();
        for (CommandAttribute attr : CommandAttribute.values()) {
            map.put(attr.getName(), attr);
        }
    }
}

