"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HelixCtrl = void 0;
const request = require("request");
const config_1 = require("../config");
class HelixCtrl {
    constructor(router) {
        router.route('/helix/list').get(this.list);
        router.route('/helix/*').all(this.proxy);
    }
    proxy(req, res) {
        const url = req.originalUrl.replace(HelixCtrl.ROUTE_PREFIX, '');
        const helixKey = url.split('/')[1];
        const segments = helixKey.split('.');
        const group = segments[0];
        segments.shift();
        const name = segments.join('.');
        const user = req.session.username;
        const method = req.method.toLowerCase();
        if (method != 'get' && !req.session.isAdmin) {
            res.status(403).send('Forbidden');
            return;
        }
        let apiPrefix = null;
        if (config_1.HELIX_ENDPOINTS[group]) {
            config_1.HELIX_ENDPOINTS[group].forEach(section => {
                if (section[name]) {
                    apiPrefix = section[name];
                }
            });
        }
        if (apiPrefix) {
            const realUrl = apiPrefix + url.replace(`/${helixKey}`, '');
            const options = {
                url: realUrl,
                json: req.body,
                headers: {
                    'Helix-User': user
                }
            };
            request[method](options, (error, response, body) => {
                if (error) {
                    res.status(500).send(error);
                }
                else {
                    res.status(response.statusCode).send(body);
                }
            });
        }
        else {
            res.status(404).send('Not found');
        }
    }
    list(req, res) {
        try {
            res.json(config_1.HELIX_ENDPOINTS);
        }
        catch (err) {
            console.log('error from helix/list/');
            console.log(err);
        }
    }
}
exports.HelixCtrl = HelixCtrl;
HelixCtrl.ROUTE_PREFIX = '/api/helix';
//# sourceMappingURL=helix.js.map