/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.manager.zk.ZKHelixAdmin;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.manager.zk.ZkBucketDataAccessor;
import org.apache.helix.msdcommon.exception.InvalidRoutingDataException;
import org.apache.helix.rest.metadatastore.ZkMetadataStoreDirectory;
import org.apache.helix.task.TaskDriver;
import org.apache.helix.tools.ClusterSetup;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.constant.RoutingDataReaderType;
import org.apache.helix.zookeeper.datamodel.serializer.ByteArraySerializer;
import org.apache.helix.zookeeper.datamodel.serializer.ZNRecordSerializer;
import org.apache.helix.zookeeper.impl.client.FederatedZkClient;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.apache.helix.zookeeper.impl.factory.DedicatedZkClientFactory;
import org.apache.helix.zookeeper.impl.factory.SharedZkClientFactory;
import org.apache.helix.zookeeper.routing.RoutingDataManager;
import org.apache.helix.zookeeper.zkclient.IZkChildListener;
import org.apache.helix.zookeeper.zkclient.IZkDataListener;
import org.apache.helix.zookeeper.zkclient.IZkStateListener;
import org.apache.helix.zookeeper.zkclient.serialize.ZkSerializer;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerContext
implements IZkDataListener,
IZkChildListener,
IZkStateListener {
    private static final Logger LOG = LoggerFactory.getLogger(ServerContext.class);
    private final String _zkAddr;
    private final String _msdsEndpoint;
    private final boolean _isMultiZkEnabled;
    private volatile RealmAwareZkClient _zkClient;
    private volatile RealmAwareZkClient _byteArrayZkClient;
    private volatile ZKHelixAdmin _zkHelixAdmin;
    private volatile ClusterSetup _clusterSetup;
    private volatile ConfigAccessor _configAccessor;
    private volatile ZkBaseDataAccessor<byte[]> _byteArrayZkBaseDataAccessor;
    private final Map<String, HelixDataAccessor> _helixDataAccessorPool;
    private final Map<String, TaskDriver> _taskDriverPool;
    private volatile ZkBucketDataAccessor _zkBucketDataAccessor;
    private final ZkMetadataStoreDirectory _zkMetadataStoreDirectory;
    private RealmAwareZkClient _zkClientForRoutingDataListener;

    public ServerContext(String zkAddr) {
        this(zkAddr, false, null);
    }

    public ServerContext(String zkAddr, boolean isMultiZkEnabled, String msdsEndpoint) {
        this._zkAddr = zkAddr;
        this._isMultiZkEnabled = isMultiZkEnabled;
        this._msdsEndpoint = msdsEndpoint;
        this._helixDataAccessorPool = new ConcurrentHashMap<String, HelixDataAccessor>();
        this._taskDriverPool = new ConcurrentHashMap<String, TaskDriver>();
        this._zkMetadataStoreDirectory = ZkMetadataStoreDirectory.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RealmAwareZkClient getRealmAwareZkClient() {
        if (this._zkClient == null) {
            ServerContext serverContext = this;
            synchronized (serverContext) {
                if (this._zkClient == null) {
                    this._zkClient = this.createRealmAwareZkClient((ZkSerializer)new ZNRecordSerializer());
                }
            }
        }
        return this._zkClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RealmAwareZkClient getByteArrayRealmAwareZkClient() {
        if (this._byteArrayZkClient == null) {
            ServerContext serverContext = this;
            synchronized (serverContext) {
                if (this._byteArrayZkClient == null) {
                    this._byteArrayZkClient = this.createRealmAwareZkClient((ZkSerializer)new ByteArraySerializer());
                }
            }
        }
        return this._byteArrayZkClient;
    }

    private RealmAwareZkClient createRealmAwareZkClient(ZkSerializer zkSerializer) {
        HelixZkClient realmAwareZkClient;
        if (this._isMultiZkEnabled || Boolean.parseBoolean(System.getProperty("helix.multiZkEnabled"))) {
            try {
                this.initializeZkClientForRoutingData();
                RealmAwareZkClient.RealmAwareZkConnectionConfig.Builder connectionConfigBuilder = new RealmAwareZkClient.RealmAwareZkConnectionConfig.Builder();
                if (this._msdsEndpoint != null && !this._msdsEndpoint.isEmpty()) {
                    connectionConfigBuilder.setRoutingDataSourceEndpoint(this._msdsEndpoint).setRoutingDataSourceType(RoutingDataReaderType.HTTP.name());
                }
                realmAwareZkClient = new FederatedZkClient(connectionConfigBuilder.build(), new RealmAwareZkClient.RealmAwareZkClientConfig().setZkSerializer(zkSerializer));
                LOG.info("ServerContext: FederatedZkClient created successfully!");
            }
            catch (IllegalStateException | InvalidRoutingDataException e) {
                throw new HelixException("Failed to create FederatedZkClient!", e);
            }
        } else {
            HelixZkClient.ZkClientConfig clientConfig = new HelixZkClient.ZkClientConfig();
            clientConfig.setZkSerializer(zkSerializer);
            realmAwareZkClient = SharedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(this._zkAddr), clientConfig);
        }
        return realmAwareZkClient;
    }

    private void initializeZkClientForRoutingData() {
        if (this._zkClientForRoutingDataListener == null) {
            this._zkClientForRoutingDataListener = DedicatedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(this._zkAddr), new HelixZkClient.ZkClientConfig().setZkSerializer((ZkSerializer)new ZNRecordSerializer()));
        }
        this._zkClientForRoutingDataListener.unsubscribeAll();
        this._zkClientForRoutingDataListener.subscribeRoutingDataChanges((IZkChildListener)this, (IZkDataListener)this);
        LOG.info("ServerContext: subscribed to routing data in routing ZK at {}!", (Object)this._zkAddr);
    }

    @Deprecated
    public ZkClient getZkClient() {
        return (ZkClient)this.getRealmAwareZkClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HelixAdmin getHelixAdmin() {
        if (this._zkHelixAdmin == null) {
            ServerContext serverContext = this;
            synchronized (serverContext) {
                if (this._zkHelixAdmin == null) {
                    this._zkHelixAdmin = new ZKHelixAdmin(this.getRealmAwareZkClient());
                }
            }
        }
        return this._zkHelixAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterSetup getClusterSetup() {
        if (this._clusterSetup == null) {
            ServerContext serverContext = this;
            synchronized (serverContext) {
                if (this._clusterSetup == null) {
                    this._clusterSetup = new ClusterSetup(this.getRealmAwareZkClient(), this.getHelixAdmin());
                }
            }
        }
        return this._clusterSetup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskDriver getTaskDriver(String clusterName) {
        TaskDriver taskDriver = this._taskDriverPool.get(clusterName);
        if (taskDriver == null) {
            ServerContext serverContext = this;
            synchronized (serverContext) {
                if (!this._taskDriverPool.containsKey(clusterName)) {
                    this._taskDriverPool.put(clusterName, new TaskDriver(this.getRealmAwareZkClient(), clusterName));
                }
                taskDriver = this._taskDriverPool.get(clusterName);
            }
        }
        return taskDriver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigAccessor getConfigAccessor() {
        if (this._configAccessor == null) {
            ServerContext serverContext = this;
            synchronized (serverContext) {
                if (this._configAccessor == null) {
                    this._configAccessor = new ConfigAccessor(this.getRealmAwareZkClient());
                }
            }
        }
        return this._configAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HelixDataAccessor getDataAccessor(String clusterName) {
        HelixDataAccessor dataAccessor = this._helixDataAccessorPool.get(clusterName);
        if (dataAccessor == null) {
            ServerContext serverContext = this;
            synchronized (serverContext) {
                if (!this._helixDataAccessorPool.containsKey(clusterName)) {
                    ZkBaseDataAccessor baseDataAccessor = new ZkBaseDataAccessor(this.getRealmAwareZkClient());
                    this._helixDataAccessorPool.put(clusterName, (HelixDataAccessor)new ZKHelixDataAccessor(clusterName, (BaseDataAccessor)baseDataAccessor));
                }
                dataAccessor = this._helixDataAccessorPool.get(clusterName);
            }
        }
        return dataAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseDataAccessor<byte[]> getByteArrayZkBaseDataAccessor() {
        if (this._byteArrayZkBaseDataAccessor == null) {
            ServerContext serverContext = this;
            synchronized (serverContext) {
                if (this._byteArrayZkBaseDataAccessor == null) {
                    this._byteArrayZkBaseDataAccessor = new ZkBaseDataAccessor(this.getByteArrayRealmAwareZkClient());
                }
            }
        }
        return this._byteArrayZkBaseDataAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZkBucketDataAccessor getZkBucketDataAccessor() {
        if (this._zkBucketDataAccessor == null) {
            ServerContext serverContext = this;
            synchronized (serverContext) {
                if (this._zkBucketDataAccessor == null) {
                    this._zkBucketDataAccessor = new ZkBucketDataAccessor(this._zkAddr);
                }
            }
        }
        return this._zkBucketDataAccessor;
    }

    public void close() {
        if (this._zkClient != null) {
            this._zkClient.close();
        }
        if (this._zkMetadataStoreDirectory != null) {
            this._zkMetadataStoreDirectory.close();
        }
        if (this._zkClientForRoutingDataListener != null) {
            this._zkClientForRoutingDataListener.close();
        }
    }

    public void handleChildChange(String parentPath, List<String> currentChilds) {
        if (this._zkClientForRoutingDataListener == null || this._zkClientForRoutingDataListener.isClosed()) {
            return;
        }
        this._zkClientForRoutingDataListener.unsubscribeAll();
        this._zkClientForRoutingDataListener.subscribeRoutingDataChanges((IZkChildListener)this, (IZkDataListener)this);
        this.resetZkResources();
    }

    public void handleDataChange(String dataPath, Object data) {
        if (this._zkClientForRoutingDataListener == null || this._zkClientForRoutingDataListener.isClosed()) {
            return;
        }
        this.resetZkResources();
    }

    public void handleDataDeleted(String dataPath) {
        if (this._zkClientForRoutingDataListener == null || this._zkClientForRoutingDataListener.isClosed()) {
            return;
        }
        this._zkClientForRoutingDataListener.unsubscribeAll();
        this._zkClientForRoutingDataListener.subscribeRoutingDataChanges((IZkChildListener)this, (IZkDataListener)this);
        this.resetZkResources();
    }

    public void handleStateChanged(Watcher.Event.KeeperState state) {
        if (this._zkClientForRoutingDataListener == null || this._zkClientForRoutingDataListener.isClosed()) {
            return;
        }
        this._zkClientForRoutingDataListener.unsubscribeAll();
        this._zkClientForRoutingDataListener.subscribeRoutingDataChanges((IZkChildListener)this, (IZkDataListener)this);
        this.resetZkResources();
    }

    public void handleNewSession(String sessionId) {
        if (this._zkClientForRoutingDataListener == null || this._zkClientForRoutingDataListener.isClosed()) {
            return;
        }
        this._zkClientForRoutingDataListener.unsubscribeAll();
        this._zkClientForRoutingDataListener.subscribeRoutingDataChanges((IZkChildListener)this, (IZkDataListener)this);
        this.resetZkResources();
    }

    public void handleSessionEstablishmentError(Throwable error) {
        if (this._zkClientForRoutingDataListener == null || this._zkClientForRoutingDataListener.isClosed()) {
            return;
        }
        this._zkClientForRoutingDataListener.unsubscribeAll();
        this._zkClientForRoutingDataListener.subscribeRoutingDataChanges((IZkChildListener)this, (IZkDataListener)this);
        this.resetZkResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetZkResources() {
        ServerContext serverContext = this;
        synchronized (serverContext) {
            LOG.info("ServerContext: Resetting ZK resources due to routing data change! Routing ZK: {}", (Object)this._zkAddr);
            try {
                RoutingDataManager.getInstance().reset();
                if (this._zkClient != null && !this._zkClient.isClosed()) {
                    this._zkClient.close();
                }
                if (this._byteArrayZkClient != null && !this._byteArrayZkClient.isClosed()) {
                    this._byteArrayZkClient.close();
                }
                this._zkClient = null;
                this._byteArrayZkClient = null;
                if (this._zkHelixAdmin != null) {
                    this._zkHelixAdmin.close();
                    this._zkHelixAdmin = null;
                }
                if (this._clusterSetup != null) {
                    this._clusterSetup.close();
                    this._clusterSetup = null;
                }
                if (this._configAccessor != null) {
                    this._configAccessor.close();
                    this._configAccessor = null;
                }
                if (this._byteArrayZkBaseDataAccessor != null) {
                    this._byteArrayZkBaseDataAccessor.close();
                    this._byteArrayZkBaseDataAccessor = null;
                }
                if (this._zkBucketDataAccessor != null) {
                    this._zkBucketDataAccessor.close();
                    this._zkBucketDataAccessor = null;
                }
                this._helixDataAccessorPool.clear();
                this._taskDriverPool.clear();
            }
            catch (Exception e) {
                LOG.error("Failed to reset ZkClient and Helix APIs in ServerContext!", (Throwable)e);
            }
        }
    }
}

