/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.constraint;

import java.util.List;
import java.util.Map;
import org.apache.helix.api.rebalancer.constraint.AbnormalStateResolver;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.Partition;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.monitoring.metrics.AbnormalStatesMetricCollector;
import org.apache.helix.monitoring.metrics.model.CountMetric;

public class MonitoredAbnormalResolver
implements AbnormalStateResolver {
    private final AbnormalStateResolver _resolver;
    private final AbnormalStatesMetricCollector _metricCollector;
    public static final MonitoredAbnormalResolver DUMMY_STATE_RESOLVER = new MonitoredAbnormalResolver(new AbnormalStateResolver(){

        @Override
        public boolean checkCurrentStates(CurrentStateOutput currentStateOutput, String resourceName, Partition partition, StateModelDefinition stateModelDef) {
            return true;
        }

        @Override
        public Map<String, String> computeRecoveryAssignment(CurrentStateOutput currentStateOutput, String resourceName, Partition partition, StateModelDefinition stateModelDef, List<String> preferenceList) {
            throw new UnsupportedOperationException("This resolver won't recover abnormal states.");
        }
    }, null);

    private MonitoredAbnormalResolver(AbnormalStateResolver resolver, AbnormalStatesMetricCollector metricCollector) {
        if (resolver instanceof MonitoredAbnormalResolver) {
            throw new IllegalArgumentException("Cannot construct a MonitoredAbnormalResolver wrap object using another MonitoredAbnormalResolver object.");
        }
        this._resolver = resolver;
        this._metricCollector = metricCollector;
    }

    public MonitoredAbnormalResolver(AbnormalStateResolver resolver, String clusterName, String stateModelDef) {
        this(resolver, new AbnormalStatesMetricCollector(clusterName, stateModelDef));
    }

    public void recordAbnormalState() {
        this._metricCollector.getMetric(AbnormalStatesMetricCollector.AbnormalStatesMetricNames.AbnormalStatePartitionCounter.name(), CountMetric.class).increment(1L);
    }

    public void recordRecoveryAttempt() {
        this._metricCollector.getMetric(AbnormalStatesMetricCollector.AbnormalStatesMetricNames.RecoveryAttemptCounter.name(), CountMetric.class).increment(1L);
    }

    public Class getResolverClass() {
        return this._resolver.getClass();
    }

    @Override
    public boolean checkCurrentStates(CurrentStateOutput currentStateOutput, String resourceName, Partition partition, StateModelDefinition stateModelDef) {
        return this._resolver.checkCurrentStates(currentStateOutput, resourceName, partition, stateModelDef);
    }

    @Override
    public Map<String, String> computeRecoveryAssignment(CurrentStateOutput currentStateOutput, String resourceName, Partition partition, StateModelDefinition stateModelDef, List<String> preferenceList) {
        return this._resolver.computeRecoveryAssignment(currentStateOutput, resourceName, partition, stateModelDef, preferenceList);
    }

    public void close() {
        if (this._metricCollector != null) {
            this._metricCollector.unregister();
        }
    }

    public void finalize() {
        this.close();
    }
}

