/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyPathBuilder;
import org.apache.helix.PropertyType;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.apache.helix.zookeeper.zkclient.serialize.ZkSerializer;
import org.restlet.data.Form;
import org.restlet.data.MediaType;

public class ClusterRepresentationUtil {
    public static final ZNRecord EMPTY_ZNRECORD = new ZNRecord("EMPTY_ZNRECORD");
    private static ObjectMapper mapper = new ObjectMapper();

    public static String getClusterPropertyAsString(ZkClient zkClient, String clusterName, PropertyKey propertyKey, MediaType mediaType) throws JsonGenerationException, JsonMappingException, IOException {
        return ClusterRepresentationUtil.getClusterPropertyAsString(zkClient, clusterName, mediaType, propertyKey);
    }

    public static String getClusterPropertyAsString(ZkClient zkClient, String clusterName, MediaType mediaType, PropertyKey propertyKey) throws JsonGenerationException, JsonMappingException, IOException {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, (BaseDataAccessor)new ZkBaseDataAccessor((RealmAwareZkClient)zkClient));
        HelixProperty property = accessor.getProperty(propertyKey);
        ZNRecord record = property == null ? null : property.getRecord();
        return ClusterRepresentationUtil.ZNRecordToJson(record);
    }

    public static String getInstancePropertyNameListAsString(ZkClient zkClient, String clusterName, String instanceName, PropertyType instanceProperty, String key, MediaType mediaType) throws JsonGenerationException, JsonMappingException, IOException {
        String path = PropertyPathBuilder.instanceProperty((String)clusterName, (String)instanceName, (PropertyType)instanceProperty, (String)key);
        if (zkClient.exists(path)) {
            List recordNames = zkClient.getChildren(path);
            return ClusterRepresentationUtil.ObjectToJson(recordNames);
        }
        return ClusterRepresentationUtil.ObjectToJson(new ArrayList());
    }

    public static String getInstancePropertyAsString(ZkClient zkClient, String clusterName, PropertyKey propertyKey, MediaType mediaType) throws JsonGenerationException, JsonMappingException, IOException {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, (BaseDataAccessor)new ZkBaseDataAccessor((RealmAwareZkClient)zkClient));
        ZNRecord records = accessor.getProperty(propertyKey).getRecord();
        return ClusterRepresentationUtil.ZNRecordToJson(records);
    }

    public static String getInstancePropertiesAsString(ZkClient zkClient, String clusterName, PropertyKey propertyKey, MediaType mediaType) throws JsonGenerationException, JsonMappingException, IOException {
        zkClient.setZkSerializer((ZkSerializer)new ZNRecordSerializer());
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, (BaseDataAccessor)new ZkBaseDataAccessor((RealmAwareZkClient)zkClient));
        List records = HelixProperty.convertToList((List)accessor.getChildValues(propertyKey));
        return ClusterRepresentationUtil.ObjectToJson(records);
    }

    public static String getPropertyAsString(ZkClient zkClient, String clusterName, PropertyKey propertyKey, MediaType mediaType) throws JsonGenerationException, JsonMappingException, IOException {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, (BaseDataAccessor)new ZkBaseDataAccessor((RealmAwareZkClient)zkClient));
        ZNRecord record = EMPTY_ZNRECORD;
        HelixProperty property = accessor.getProperty(propertyKey);
        if (property != null) {
            record = property.getRecord();
        }
        return ClusterRepresentationUtil.ObjectToJson(record);
    }

    public static String ZNRecordToJson(ZNRecord record) throws JsonGenerationException, JsonMappingException, IOException {
        return ClusterRepresentationUtil.ObjectToJson(record);
    }

    public static String ObjectToJson(Object object) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        StringWriter sw = new StringWriter();
        mapper.writeValue((Writer)sw, object);
        return sw.toString();
    }

    public static HelixDataAccessor getClusterDataAccessor(ZkClient zkClient, String clusterName) {
        return new ZKHelixDataAccessor(clusterName, (BaseDataAccessor)new ZkBaseDataAccessor((RealmAwareZkClient)zkClient));
    }

    public static <T> T JsonToObject(Class<T> clazz, String jsonString) throws JsonParseException, JsonMappingException, IOException {
        StringReader sr = new StringReader(jsonString);
        return (T)mapper.readValue((Reader)sr, clazz);
    }

    public static Map<String, String> JsonToMap(String jsonString) throws JsonParseException, JsonMappingException, IOException {
        StringReader sr = new StringReader(jsonString);
        TypeReference<TreeMap<String, String>> typeRef = new TypeReference<TreeMap<String, String>>(){};
        return (Map)mapper.readValue((Reader)sr, (TypeReference)typeRef);
    }

    public static Map<String, String> getFormJsonParameters(Form form) throws JsonParseException, JsonMappingException, IOException {
        String jsonPayload = form.getFirstValue("jsonParameters", true);
        return ClusterRepresentationUtil.JsonToMap(jsonPayload);
    }

    public static Map<String, String> getFormJsonParameters(Form form, String key) throws JsonParseException, JsonMappingException, IOException {
        String jsonPayload = form.getFirstValue(key, true);
        return ClusterRepresentationUtil.JsonToMap(jsonPayload);
    }

    public static String getFormJsonParameterString(Form form, String key) throws JsonParseException, JsonMappingException, IOException {
        return form.getFirstValue(key, true);
    }

    public static <T> T getFormJsonParameters(Class<T> clazz, Form form, String key) throws JsonParseException, JsonMappingException, IOException {
        return ClusterRepresentationUtil.JsonToObject(clazz, form.getFirstValue(key, true));
    }

    public static String getErrorAsJsonStringFromException(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        String error = e.getMessage() + '\n' + sw.toString();
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("ERROR", error);
        try {
            return ClusterRepresentationUtil.ObjectToJson(result);
        }
        catch (Exception e1) {
            StringWriter sw1 = new StringWriter();
            PrintWriter pw1 = new PrintWriter(sw1);
            e.printStackTrace(pw1);
            return "{\"ERROR\": \"" + sw1.toString() + "\"}";
        }
    }

    public static String getInstanceSessionId(ZkClient zkClient, String clusterName, String instanceName) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, (BaseDataAccessor)new ZkBaseDataAccessor((RealmAwareZkClient)zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        ZNRecord liveInstance = accessor.getProperty(keyBuilder.liveInstance(instanceName)).getRecord();
        return liveInstance.getSimpleField(LiveInstance.LiveInstanceProperty.SESSION_ID.toString());
    }

    public static List<String> getInstancePropertyList(ZkClient zkClient, String clusterName, String instanceName, PropertyType property, String key) {
        String propertyPath = PropertyPathBuilder.instanceProperty((String)clusterName, (String)instanceName, (PropertyType)property, (String)key);
        return zkClient.getChildren(propertyPath);
    }
}

