/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.zkclient.util;

import java.util.Random;

public class ExponentialBackoffStrategy {
    private final long INIT_RETRY_INTERVAL = 500L;
    private final long _maxRetryInterval;
    private final boolean _addJitter;
    private final Random _ran;

    public ExponentialBackoffStrategy(long maxRetryInterval, boolean addJitter) {
        this._maxRetryInterval = maxRetryInterval;
        this._addJitter = addJitter;
        this._ran = new Random(System.currentTimeMillis());
    }

    public long getNextWaitInterval(int numberOfTriesFailed) {
        double exponentialMultiplier = Math.pow(2.0, numberOfTriesFailed - 1);
        double result = exponentialMultiplier * 500.0;
        if (this._maxRetryInterval > 0L && result > (double)this._maxRetryInterval) {
            result = this._maxRetryInterval;
        }
        if (this._addJitter) {
            result *= 0.75 + this._ran.nextDouble() % 0.25;
        }
        return (long)result;
    }
}

