/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import org.apache.zookeeper.CreateMode;

public class AccessOption {
    public static int PERSISTENT = 1;
    public static int EPHEMERAL = 2;
    public static int PERSISTENT_SEQUENTIAL = 4;
    public static int EPHEMERAL_SEQUENTIAL = 8;
    public static int THROW_EXCEPTION_IFNOTEXIST = 16;
    public static int CONTAINER = 32;
    public static int PERSISTENT_WITH_TTL = 64;
    public static int PERSISTENT_SEQUENTIAL_WITH_TTL = 128;

    public static CreateMode getMode(int options) {
        if ((options & PERSISTENT) > 0) {
            return CreateMode.PERSISTENT;
        }
        if ((options & EPHEMERAL) > 0) {
            return CreateMode.EPHEMERAL;
        }
        if ((options & PERSISTENT_SEQUENTIAL) > 0) {
            return CreateMode.PERSISTENT_SEQUENTIAL;
        }
        if ((options & EPHEMERAL_SEQUENTIAL) > 0) {
            return CreateMode.EPHEMERAL_SEQUENTIAL;
        }
        if ((options & CONTAINER) > 0) {
            return CreateMode.CONTAINER;
        }
        if ((options & PERSISTENT_WITH_TTL) > 0) {
            return CreateMode.PERSISTENT_WITH_TTL;
        }
        if ((options & PERSISTENT_SEQUENTIAL_WITH_TTL) > 0) {
            return CreateMode.PERSISTENT_SEQUENTIAL_WITH_TTL;
        }
        return null;
    }

    public static boolean isThrowExceptionIfNotExist(int options) {
        return (options & THROW_EXCEPTION_IFNOTEXIST) > 0;
    }
}

