/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.pipeline;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.helix.common.DedupEventProcessor;
import org.apache.helix.controller.pipeline.AsyncWorkerType;
import org.apache.helix.controller.pipeline.Stage;
import org.apache.helix.controller.pipeline.StageContext;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterEvent;

public class AbstractBaseStage
implements Stage {
    protected String _eventId;

    @Override
    public void init(StageContext context) {
    }

    @Override
    public void preProcess() {
    }

    @Override
    public void process(ClusterEvent event) throws Exception {
    }

    @Override
    public void postProcess() {
    }

    @Override
    public void release() {
    }

    @Override
    public String getStageName() {
        String className = this.getClass().getSimpleName();
        return className;
    }

    public static <T> Future asyncExecute(ExecutorService service, Callable<T> task) {
        if (service != null) {
            return service.submit(task);
        }
        return null;
    }

    protected DedupEventProcessor<String, Runnable> getAsyncWorkerFromClusterEvent(ClusterEvent event, AsyncWorkerType workerType) {
        Map workerPool = (Map)event.getAttribute(AttributeName.AsyncFIFOWorkerPool.name());
        if (workerPool != null && workerPool.containsKey((Object)workerType)) {
            return (DedupEventProcessor)workerPool.get((Object)workerType);
        }
        return null;
    }
}

