/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.examples;

import org.apache.helix.NotificationContext;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelFactory;

public class OnlineOfflineStateModelFactory
extends StateModelFactory<StateModel> {
    int _delay;
    String _instanceName = "";

    public OnlineOfflineStateModelFactory(int delay) {
        this._delay = delay;
    }

    public OnlineOfflineStateModelFactory(String instanceName) {
        this._instanceName = instanceName;
        this._delay = 10;
    }

    public OnlineOfflineStateModelFactory(String instanceName, int delay) {
        this._instanceName = instanceName;
        this._delay = delay;
    }

    public OnlineOfflineStateModelFactory() {
        this(10);
    }

    @Override
    public StateModel createNewStateModel(String resourceName, String stateUnitKey) {
        OnlineOfflineStateModel stateModel = new OnlineOfflineStateModel();
        stateModel.setDelay(this._delay);
        stateModel.setInstanceName(this._instanceName);
        return stateModel;
    }

    public static class OnlineOfflineStateModel
    extends StateModel {
        int _transDelay = 0;
        String _instanceName = "";

        public void setDelay(int delay) {
            this._transDelay = delay > 0 ? delay : 0;
        }

        public void setInstanceName(String instanceName) {
            this._instanceName = instanceName;
        }

        public void onBecomeOnlineFromOffline(Message message, NotificationContext context) {
            System.out.println("OnlineOfflineStateModelFactory.onBecomeOnlineFromOffline():" + this._instanceName + " transitioning from " + message.getFromState() + " to " + message.getToState() + " for " + message.getResourceName() + " " + message.getPartitionName());
            this.sleep();
        }

        public void onBecomeOfflineFromOnline(Message message, NotificationContext context) {
            System.out.println("OnlineOfflineStateModelFactory.onBecomeOfflineFromOnline():" + this._instanceName + " transitioning from " + message.getFromState() + " to " + message.getToState() + " for " + message.getResourceName() + " " + message.getPartitionName());
            this.sleep();
        }

        public void onBecomeDroppedFromOffline(Message message, NotificationContext context) {
            System.out.println("OnlineOfflineStateModelFactory.onBecomeDroppedFromOffline():" + this._instanceName + " transitioning from " + message.getFromState() + " to " + message.getToState() + " for " + message.getResourceName() + " " + message.getPartitionName());
            this.sleep();
        }

        private void sleep() {
            try {
                Thread.sleep(this._transDelay);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

