/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotContext;
import org.apache.flink.runtime.jobmaster.SlotOwner;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;

public class SingleLogicalSlot
implements LogicalSlot,
PhysicalSlot.Payload {
    private static final AtomicReferenceFieldUpdater<SingleLogicalSlot, LogicalSlot.Payload> PAYLOAD_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SingleLogicalSlot.class, LogicalSlot.Payload.class, "payload");
    private static final AtomicReferenceFieldUpdater<SingleLogicalSlot, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SingleLogicalSlot.class, State.class, "state");
    private final SlotRequestId slotRequestId;
    private final SlotContext slotContext;
    private final Locality locality;
    private final SlotOwner slotOwner;
    private final CompletableFuture<Void> releaseFuture;
    private volatile State state;
    private volatile LogicalSlot.Payload payload;
    private boolean willBeOccupiedIndefinitely;

    @VisibleForTesting
    public SingleLogicalSlot(SlotRequestId slotRequestId, SlotContext slotContext, Locality locality, SlotOwner slotOwner) {
        this(slotRequestId, slotContext, locality, slotOwner, true);
    }

    public SingleLogicalSlot(SlotRequestId slotRequestId, SlotContext slotContext, Locality locality, SlotOwner slotOwner, boolean willBeOccupiedIndefinitely) {
        this.slotRequestId = (SlotRequestId)((Object)Preconditions.checkNotNull((Object)((Object)slotRequestId)));
        this.slotContext = (SlotContext)Preconditions.checkNotNull((Object)slotContext);
        this.locality = (Locality)((Object)Preconditions.checkNotNull((Object)((Object)locality)));
        this.slotOwner = (SlotOwner)Preconditions.checkNotNull((Object)slotOwner);
        this.willBeOccupiedIndefinitely = willBeOccupiedIndefinitely;
        this.releaseFuture = new CompletableFuture();
        this.state = State.ALIVE;
        this.payload = null;
    }

    @Override
    public TaskManagerLocation getTaskManagerLocation() {
        return this.slotContext.getTaskManagerLocation();
    }

    @Override
    public TaskManagerGateway getTaskManagerGateway() {
        return this.slotContext.getTaskManagerGateway();
    }

    @Override
    public Locality getLocality() {
        return this.locality;
    }

    @Override
    public boolean isAlive() {
        return this.state == State.ALIVE;
    }

    @Override
    public boolean tryAssignPayload(LogicalSlot.Payload payload) {
        return PAYLOAD_UPDATER.compareAndSet(this, null, payload);
    }

    @Override
    @Nullable
    public LogicalSlot.Payload getPayload() {
        return this.payload;
    }

    @Override
    public CompletableFuture<?> releaseSlot(@Nullable Throwable cause) {
        if (STATE_UPDATER.compareAndSet(this, State.ALIVE, State.RELEASING)) {
            this.signalPayloadRelease(cause);
            this.returnSlotToOwner(this.payload.getTerminalStateFuture());
        }
        return this.releaseFuture;
    }

    @Override
    public AllocationID getAllocationId() {
        return this.slotContext.getAllocationId();
    }

    @Override
    public SlotRequestId getSlotRequestId() {
        return this.slotRequestId;
    }

    public static SingleLogicalSlot allocateFromPhysicalSlot(SlotRequestId slotRequestId, PhysicalSlot physicalSlot, Locality locality, SlotOwner slotOwner, boolean slotWillBeOccupiedIndefinitely) {
        SingleLogicalSlot singleTaskSlot = new SingleLogicalSlot(slotRequestId, physicalSlot, locality, slotOwner, slotWillBeOccupiedIndefinitely);
        if (physicalSlot.tryAssignPayload(singleTaskSlot)) {
            return singleTaskSlot;
        }
        throw new IllegalStateException("BUG: Unexpected physical slot payload assignment failure!");
    }

    @Override
    public void release(Throwable cause) {
        if (STATE_UPDATER.compareAndSet(this, State.ALIVE, State.RELEASING)) {
            this.signalPayloadRelease(cause);
        }
        this.markReleased();
        this.releaseFuture.complete(null);
    }

    @Override
    public boolean willOccupySlotIndefinitely() {
        return this.willBeOccupiedIndefinitely;
    }

    private void signalPayloadRelease(Throwable cause) {
        this.tryAssignPayload(TERMINATED_PAYLOAD);
        this.payload.fail(cause);
    }

    private void returnSlotToOwner(CompletableFuture<?> terminalStateFuture) {
        FutureUtils.assertNoException((CompletableFuture)terminalStateFuture.thenRun(() -> {
            if (this.state == State.RELEASING) {
                this.slotOwner.returnLogicalSlot(this);
            }
            this.markReleased();
            this.releaseFuture.complete(null);
        }));
    }

    private void markReleased() {
        this.state = State.RELEASED;
    }

    static enum State {
        ALIVE,
        RELEASING,
        RELEASED;

    }
}

