/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import io.netty.util.concurrent.FastThreadLocal;
import java.util.EnumMap;
import java.util.Map;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.ParamType;

public class MessageParams {
    private static final FastThreadLocal<Map<ParamType, Object>> local = new FastThreadLocal();

    private MessageParams() {
    }

    private static Map<ParamType, Object> get() {
        EnumMap instance = (EnumMap)local.get();
        if (instance == null) {
            instance = new EnumMap(ParamType.class);
            local.set(instance);
        }
        return instance;
    }

    public static void add(ParamType key, Object value) {
        MessageParams.get().put(key, value);
    }

    public static <T> T get(ParamType key) {
        return (T)MessageParams.get().get((Object)key);
    }

    public static void remove(ParamType key) {
        MessageParams.get().remove((Object)key);
    }

    public static void reset() {
        MessageParams.get().clear();
    }

    public static <T> Message<T> addToMessage(Message<T> message) {
        return message.withParams(MessageParams.get());
    }
}

