/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.collect.Iterators;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.EndpointsForRange;
import org.apache.cassandra.locator.EndpointsForToken;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaCollection;
import org.apache.cassandra.utils.FBUtilities;

public class PendingRangeMaps
implements Iterable<Map.Entry<Range<Token>, EndpointsForRange.Builder>> {
    private final NavigableMap<Range<Token>, EndpointsForRange.Builder> ascendingMap = new TreeMap<Range<Token>, EndpointsForRange.Builder>(ascendingComparator);
    private static final Comparator<Range<Token>> ascendingComparator = (o1, o2) -> {
        int res = ((Token)o1.right).compareTo(o2.right);
        if (res != 0) {
            return res;
        }
        return ((Token)o2.left).compareTo(o1.left);
    };
    private final NavigableMap<Range<Token>, EndpointsForRange.Builder> descendingMap = new TreeMap<Range<Token>, EndpointsForRange.Builder>(descendingComparator);
    private static final Comparator<Range<Token>> descendingComparator = (o1, o2) -> {
        int res = ((Token)o2.left).compareTo(o1.left);
        if (res != 0) {
            return res;
        }
        return ((Token)o2.right).compareTo(o1.right);
    };
    private final NavigableMap<Range<Token>, EndpointsForRange.Builder> ascendingMapForWrapAround = new TreeMap<Range<Token>, EndpointsForRange.Builder>(ascendingComparatorForWrapAround);
    private static final Comparator<Range<Token>> ascendingComparatorForWrapAround = (o1, o2) -> {
        int res = ((Token)o1.right).compareTo(o2.right);
        if (res != 0) {
            return res;
        }
        return ((Token)o1.left).compareTo(o2.left);
    };
    private final NavigableMap<Range<Token>, EndpointsForRange.Builder> descendingMapForWrapAround = new TreeMap<Range<Token>, EndpointsForRange.Builder>(descendingComparatorForWrapAround);
    private static final Comparator<Range<Token>> descendingComparatorForWrapAround = (o1, o2) -> {
        int res = ((Token)o2.left).compareTo(o1.left);
        if (res != 0) {
            return res;
        }
        return ((Token)o1.right).compareTo(o2.right);
    };

    static final void addToMap(Range<Token> range, Replica replica, NavigableMap<Range<Token>, EndpointsForRange.Builder> ascendingMap, NavigableMap<Range<Token>, EndpointsForRange.Builder> descendingMap) {
        EndpointsForRange.Builder replicas = (EndpointsForRange.Builder)ascendingMap.get(range);
        if (replicas == null) {
            replicas = new EndpointsForRange.Builder(range, 1);
            ascendingMap.put(range, replicas);
            descendingMap.put(range, replicas);
        }
        replicas.add(replica, ReplicaCollection.Builder.Conflict.DUPLICATE);
    }

    public void addPendingRange(Range<Token> range, Replica replica) {
        if (Range.isWrapAround(range.left, range.right)) {
            PendingRangeMaps.addToMap(range, replica, this.ascendingMapForWrapAround, this.descendingMapForWrapAround);
        } else {
            PendingRangeMaps.addToMap(range, replica, this.ascendingMap, this.descendingMap);
        }
    }

    static final void addIntersections(EndpointsForToken.Builder replicasToAdd, NavigableMap<Range<Token>, EndpointsForRange.Builder> smallerMap, NavigableMap<Range<Token>, EndpointsForRange.Builder> biggerMap) {
        for (Range range : smallerMap.keySet()) {
            EndpointsForRange.Builder replicas = (EndpointsForRange.Builder)biggerMap.get(range);
            if (replicas == null) continue;
            replicasToAdd.addAll(replicas);
        }
    }

    public boolean isTokenInLocalPendingRange(Token token) {
        Range<Token> searchRange = new Range<Token>(token, token);
        InetAddressAndPort self = FBUtilities.getBroadcastAddressAndPort();
        NavigableMap<Range<Token>, EndpointsForRange.Builder> ascendingTailMap = this.ascendingMap.tailMap(searchRange, true);
        NavigableMap<Range<Token>, EndpointsForRange.Builder> descendingTailMap = this.descendingMap.tailMap(searchRange, false);
        boolean ascMapSizeLTDescMapSize = ascendingTailMap.size() < descendingTailMap.size();
        NavigableMap<Range<Token>, EndpointsForRange.Builder> smallerMap = ascMapSizeLTDescMapSize ? ascendingTailMap : descendingTailMap;
        NavigableMap<Range<Token>, EndpointsForRange.Builder> biggerMap = ascMapSizeLTDescMapSize ? descendingTailMap : ascendingTailMap;
        for (Range range : smallerMap.keySet()) {
            EndpointsForRange.Builder replicas = (EndpointsForRange.Builder)biggerMap.get(range);
            if (replicas == null || !replicas.contains(self)) continue;
            return true;
        }
        ascendingTailMap = this.ascendingMapForWrapAround.tailMap(searchRange, true);
        descendingTailMap = this.descendingMapForWrapAround.tailMap(searchRange, false);
        for (EndpointsForRange.Builder endpointsForRange : ascendingTailMap.values()) {
            if (!endpointsForRange.contains(self)) continue;
            return true;
        }
        for (EndpointsForRange.Builder endpointsForRange : descendingTailMap.values()) {
            if (!endpointsForRange.contains(self)) continue;
            return true;
        }
        return false;
    }

    public EndpointsForToken pendingEndpointsFor(Token token) {
        EndpointsForToken.Builder replicas = EndpointsForToken.builder(token);
        Range<Token> searchRange = new Range<Token>(token, token);
        NavigableMap<Range<Token>, EndpointsForRange.Builder> ascendingTailMap = this.ascendingMap.tailMap(searchRange, true);
        NavigableMap<Range<Token>, EndpointsForRange.Builder> descendingTailMap = this.descendingMap.tailMap(searchRange, false);
        if (ascendingTailMap.size() < descendingTailMap.size()) {
            PendingRangeMaps.addIntersections(replicas, ascendingTailMap, descendingTailMap);
        } else {
            PendingRangeMaps.addIntersections(replicas, descendingTailMap, ascendingTailMap);
        }
        ascendingTailMap = this.ascendingMapForWrapAround.tailMap(searchRange, true);
        descendingTailMap = this.descendingMapForWrapAround.tailMap(searchRange, false);
        for (Map.Entry entry : ascendingTailMap.entrySet()) {
            replicas.addAll((Iterable)entry.getValue());
        }
        for (Map.Entry entry : descendingTailMap.entrySet()) {
            replicas.addAll((Iterable)entry.getValue());
        }
        return replicas.build();
    }

    public String printPendingRanges() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Range<Token>, EndpointsForRange.Builder> entry : this) {
            Range<Token> range = entry.getKey();
            for (Replica replica : entry.getValue()) {
                sb.append(replica).append(':').append(range);
                sb.append(CassandraRelevantProperties.LINE_SEPARATOR.getString());
            }
        }
        return sb.toString();
    }

    @Override
    public Iterator<Map.Entry<Range<Token>, EndpointsForRange.Builder>> iterator() {
        return Iterators.concat(this.ascendingMap.entrySet().iterator(), this.ascendingMapForWrapAround.entrySet().iterator());
    }
}

