/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline;

import java.util.concurrent.TimeUnit;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.pipeline.transform.ITransform;

public class RowProducer {
    private IRowSet rowSet;
    private ITransform transform;

    public RowProducer(ITransform transform, IRowSet rowSet) {
        this.transform = transform;
        this.rowSet = rowSet;
    }

    public void putRow(IRowMeta rowMeta, Object[] row) {
        this.putRow(rowMeta, row, true);
    }

    public boolean putRow(IRowMeta rowMeta, Object[] row, boolean block) {
        if (block) {
            boolean added = false;
            while (!added) {
                added = this.rowSet.putRowWait(rowMeta, row, Long.MAX_VALUE, TimeUnit.DAYS);
            }
            return true;
        }
        return this.rowSet.putRow(rowMeta, row);
    }

    public boolean putRowWait(IRowMeta rowMeta, Object[] rowData, long time, TimeUnit tu) {
        return this.rowSet.putRowWait(rowMeta, rowData, time, tu);
    }

    public void finished() {
        this.rowSet.setDone();
    }

    public IRowSet getRowSet() {
        return this.rowSet;
    }

    public void setRowSet(IRowSet rowSet) {
        this.rowSet = rowSet;
    }

    public ITransform getTransform() {
        return this.transform;
    }

    public void setTransform(ITransform transform) {
        this.transform = transform;
    }
}

