/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.loadfileinput;

import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.loadfileinput.LoadFileInputField;
import org.apache.hop.pipeline.transforms.loadfileinput.LoadFileInputMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class LoadFileInputDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = LoadFileInputMeta.class;
    private static final String CONST_COMBO_NO = "System.Combo.No";
    private static final String CONST_COMBO_YES = "System.Combo.Yes";
    private static final String[] YES_NO_COMBO = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    private CTabFolder wTabFolder;
    private Label wlFilename;
    private Button wbbFilename;
    private Button wbdFilename;
    private Button wbeFilename;
    private Button wbaFilename;
    private TextVar wFilename;
    private Label wlFilenameList;
    private TableView wFilenameList;
    private Label wlFilemask;
    private TextVar wFilemask;
    private Label wlExcludeFilemask;
    private TextVar wExcludeFilemask;
    private Button wbShowFiles;
    private Label wlFilenameField;
    private CCombo wFilenameField;
    private Button wFilenameInField;
    private Label wlInclFilename;
    private Button wInclFilename;
    private Button wAddResult;
    private Label wlInclFilenameField;
    private TextVar wInclFilenameField;
    private Label wlAddResult;
    private Button wInclRownum;
    private Button wIgnoreEmptyFile;
    private Button wIgnoreMissingPath;
    private Label wlInclRownumField;
    private TextVar wInclRownumField;
    private Text wLimit;
    private Label wlEncoding;
    private CCombo wEncoding;
    private TableView wFields;
    private final LoadFileInputMeta input;
    private boolean gotEncodings = false;
    private boolean gotPreviousFields = false;
    public static final int[] dateLengths = new int[]{23, 19, 14, 10, 10, 10, 10, 8, 8, 8, 8, 6, 6};
    private TextVar wShortFileFieldName;
    private TextVar wPathFieldName;
    private TextVar wIsHiddenName;
    private TextVar wLastModificationTimeName;
    private TextVar wUriName;
    private TextVar wRootUriName;
    private TextVar wExtensionFieldName;
    private int middle;
    private int margin;
    private ModifyListener lsMod;

    public LoadFileInputDialog(Shell parent, IVariables variables, LoadFileInputMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        this.lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.DialogTitle", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.Button.PreviewRows", (String[])new String[0]));
        this.wPreview.addListener(13, e -> this.preview());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wCancel}, this.margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.TransformName.Label", (String[])new String[0]));
        this.wlTransformName.setToolTipText(BaseMessages.getString(PKG, (String)"System.TransformName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, this.margin);
        this.fdlTransformName.right = new FormAttachment(this.middle, -this.margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(this.lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(this.middle, 0);
        this.fdTransformName.top = new FormAttachment(0, this.margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.wTabFolder, (int)4);
        CTabItem wFileTab = new CTabItem(this.wTabFolder, 0);
        wFileTab.setFont(GuiResource.getInstance().getFontDefault());
        wFileTab.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.File.Tab", (String[])new String[0]));
        Composite wFileComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wFileComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wFileComp.setLayout((Layout)fileLayout);
        Group wOutputField = new Group(wFileComp, 32);
        PropsUi.setLook((Widget)wOutputField);
        wOutputField.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.wOutputField.Label", (String[])new String[0]));
        FormLayout outputfieldgroupLayout = new FormLayout();
        outputfieldgroupLayout.marginWidth = 10;
        outputfieldgroupLayout.marginHeight = 10;
        wOutputField.setLayout((Layout)outputfieldgroupLayout);
        Label wlFilenameInField = new Label((Composite)wOutputField, 131072);
        wlFilenameInField.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FilenameInField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilenameInField);
        FormData fdlFilenameInField = new FormData();
        fdlFilenameInField.left = new FormAttachment(0, -this.margin);
        fdlFilenameInField.top = new FormAttachment(0, this.margin);
        fdlFilenameInField.right = new FormAttachment(this.middle, -2 * this.margin);
        wlFilenameInField.setLayoutData((Object)fdlFilenameInField);
        this.wFilenameInField = new Button((Composite)wOutputField, 32);
        PropsUi.setLook((Widget)this.wFilenameInField);
        this.wFilenameInField.setToolTipText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FilenameInField.Tooltip", (String[])new String[0]));
        FormData fdFileNameInField = new FormData();
        fdFileNameInField.left = new FormAttachment(this.middle, -this.margin);
        fdFileNameInField.top = new FormAttachment((Control)wlFilenameInField, 0, 0x1000000);
        this.wFilenameInField.setLayoutData((Object)fdFileNameInField);
        SelectionAdapter lsxmlstream = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LoadFileInputDialog.this.activateXmlStreamField();
                LoadFileInputDialog.this.input.setChanged();
            }
        };
        this.wFilenameInField.addSelectionListener((SelectionListener)lsxmlstream);
        this.wlFilenameField = new Label((Composite)wOutputField, 131072);
        this.wlFilenameField.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FilenameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilenameField);
        FormData fdlFilenameField = new FormData();
        fdlFilenameField.left = new FormAttachment(0, this.margin);
        fdlFilenameField.top = new FormAttachment((Control)this.wFilenameInField, this.margin);
        fdlFilenameField.right = new FormAttachment(this.middle, -2 * this.margin);
        this.wlFilenameField.setLayoutData((Object)fdlFilenameField);
        this.wFilenameField = new CCombo((Composite)wOutputField, 2056);
        this.wFilenameField.setEditable(true);
        PropsUi.setLook((Widget)this.wFilenameField);
        this.wFilenameField.addModifyListener(this.lsMod);
        FormData fdXMLField = new FormData();
        fdXMLField.left = new FormAttachment(this.middle, -this.margin);
        fdXMLField.top = new FormAttachment((Control)this.wFilenameInField, this.margin);
        fdXMLField.right = new FormAttachment(100, -this.margin);
        this.wFilenameField.setLayoutData((Object)fdXMLField);
        this.wFilenameField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                LoadFileInputDialog.this.setDynamicFilenameField();
            }
        });
        FormData fdOutputField = new FormData();
        fdOutputField.left = new FormAttachment(0, this.margin);
        fdOutputField.top = new FormAttachment((Control)this.wFilenameList, this.margin);
        fdOutputField.right = new FormAttachment(100, -this.margin);
        wOutputField.setLayoutData((Object)fdOutputField);
        this.middle /= 2;
        this.wlFilename = new Label(wFileComp, 131072);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.Filename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.top = new FormAttachment((Control)wOutputField, this.margin);
        fdlFilename.right = new FormAttachment(this.middle, -this.margin);
        this.wlFilename.setLayoutData((Object)fdlFilename);
        this.wbbFilename = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbbFilename);
        this.wbbFilename.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FilenameBrowse.Button", (String[])new String[0]));
        this.wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)wOutputField, this.margin);
        this.wbbFilename.setLayoutData((Object)fdbFilename);
        this.wbaFilename = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbaFilename);
        this.wbaFilename.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FilenameAdd.Button", (String[])new String[0]));
        this.wbaFilename.setToolTipText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FilenameAdd.Tooltip", (String[])new String[0]));
        FormData fdbaFilename = new FormData();
        fdbaFilename.right = new FormAttachment((Control)this.wbbFilename, -this.margin);
        fdbaFilename.top = new FormAttachment((Control)wOutputField, this.margin);
        this.wbaFilename.setLayoutData((Object)fdbaFilename);
        this.wFilename = new TextVar(this.variables, wFileComp, 18436);
        PropsUi.setLook((Widget)this.wFilename);
        this.wFilename.addModifyListener(this.lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(this.middle, 0);
        fdFilename.right = new FormAttachment((Control)this.wbaFilename, -this.margin);
        fdFilename.top = new FormAttachment((Control)wOutputField, this.margin);
        this.wFilename.setLayoutData((Object)fdFilename);
        this.wlFilemask = new Label(wFileComp, 131072);
        this.wlFilemask.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.RegExp.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilemask);
        FormData fdlFilemask = new FormData();
        fdlFilemask.left = new FormAttachment(0, 0);
        fdlFilemask.top = new FormAttachment((Control)this.wFilename, 2 * this.margin);
        fdlFilemask.right = new FormAttachment(this.middle, -this.margin);
        this.wlFilemask.setLayoutData((Object)fdlFilemask);
        this.wFilemask = new TextVar(this.variables, wFileComp, 18436);
        PropsUi.setLook((Widget)this.wFilemask);
        this.wFilemask.addModifyListener(this.lsMod);
        FormData fdFilemask = new FormData();
        fdFilemask.left = new FormAttachment(this.middle, 0);
        fdFilemask.top = new FormAttachment((Control)this.wFilename, 2 * this.margin);
        fdFilemask.right = new FormAttachment(100, 0);
        this.wFilemask.setLayoutData((Object)fdFilemask);
        this.wlExcludeFilemask = new Label(wFileComp, 131072);
        this.wlExcludeFilemask.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.ExcludeFilemask.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlExcludeFilemask);
        FormData fdlExcludeFilemask = new FormData();
        fdlExcludeFilemask.left = new FormAttachment(0, 0);
        fdlExcludeFilemask.top = new FormAttachment((Control)this.wFilemask, this.margin);
        fdlExcludeFilemask.right = new FormAttachment(this.middle, -this.margin);
        this.wlExcludeFilemask.setLayoutData((Object)fdlExcludeFilemask);
        this.wExcludeFilemask = new TextVar(this.variables, wFileComp, 18436);
        PropsUi.setLook((Widget)this.wExcludeFilemask);
        this.wExcludeFilemask.addModifyListener(this.lsMod);
        FormData fdExcludeFilemask = new FormData();
        fdExcludeFilemask.left = new FormAttachment(this.middle, 0);
        fdExcludeFilemask.top = new FormAttachment((Control)this.wFilemask, this.margin);
        fdExcludeFilemask.right = new FormAttachment((Control)this.wFilename, 0, 131072);
        this.wExcludeFilemask.setLayoutData((Object)fdExcludeFilemask);
        this.wlFilenameList = new Label(wFileComp, 131072);
        this.wlFilenameList.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FilenameList.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilenameList);
        FormData fdlFilenameList = new FormData();
        fdlFilenameList.left = new FormAttachment(0, 0);
        fdlFilenameList.top = new FormAttachment((Control)this.wExcludeFilemask, this.margin);
        fdlFilenameList.right = new FormAttachment(this.middle, -this.margin);
        this.wlFilenameList.setLayoutData((Object)fdlFilenameList);
        this.wbdFilename = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbdFilename);
        this.wbdFilename.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FilenameRemove.Label", (String[])new String[0]));
        this.wbdFilename.setToolTipText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FilenameRemove.Tooltip", (String[])new String[0]));
        FormData fdbdFilename = new FormData();
        fdbdFilename.right = new FormAttachment(100, 0);
        fdbdFilename.top = new FormAttachment((Control)this.wExcludeFilemask, 40);
        this.wbdFilename.setLayoutData((Object)fdbdFilename);
        this.wbeFilename = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbeFilename);
        this.wbeFilename.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FilenameEdit.Label", (String[])new String[0]));
        this.wbeFilename.setToolTipText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FilenameEdit.Tooltip", (String[])new String[0]));
        FormData fdbeFilename = new FormData();
        fdbeFilename.right = new FormAttachment(100, 0);
        fdbeFilename.top = new FormAttachment((Control)this.wbdFilename, this.margin);
        this.wbeFilename.setLayoutData((Object)fdbeFilename);
        this.wbShowFiles = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbShowFiles);
        this.wbShowFiles.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.ShowFiles.Button", (String[])new String[0]));
        FormData fdbShowFiles = new FormData();
        fdbShowFiles.left = new FormAttachment(this.middle, 0);
        fdbShowFiles.bottom = new FormAttachment(100, 0);
        this.wbShowFiles.setLayoutData((Object)fdbShowFiles);
        ColumnInfo[] colinfo = new ColumnInfo[5];
        colinfo[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.Files.Filename.Column", (String[])new String[0]), 1, false);
        colinfo[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.Files.Wildcard.Column", (String[])new String[0]), 1, false);
        colinfo[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.Files.ExcludeWildcard.Column", (String[])new String[0]), 1, false);
        colinfo[0].setUsingVariables(true);
        colinfo[1].setUsingVariables(true);
        colinfo[1].setToolTip(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.Files.Wildcard.Tooltip", (String[])new String[0]));
        colinfo[2].setUsingVariables(true);
        colinfo[2].setToolTip(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.Files.ExcludeWildcard.Tooltip", (String[])new String[0]));
        colinfo[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.Required.Column", (String[])new String[0]), 2, YES_NO_COMBO);
        colinfo[3].setToolTip(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.Required.Tooltip", (String[])new String[0]));
        colinfo[4] = new ColumnInfo(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.IncludeSubDirs.Column", (String[])new String[0]), 2, YES_NO_COMBO);
        colinfo[4].setToolTip(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.IncludeSubDirs.Tooltip", (String[])new String[0]));
        this.wFilenameList = new TableView(this.variables, wFileComp, 67586, colinfo, 2, this.lsMod, this.props);
        PropsUi.setLook((Widget)this.wFilenameList);
        FormData fdFilenameList = new FormData();
        fdFilenameList.left = new FormAttachment(this.middle, 0);
        fdFilenameList.right = new FormAttachment((Control)this.wbdFilename, -this.margin);
        fdFilenameList.top = new FormAttachment((Control)this.wExcludeFilemask, this.margin);
        fdFilenameList.bottom = new FormAttachment((Control)this.wbShowFiles, -this.margin);
        this.wFilenameList.setLayoutData((Object)fdFilenameList);
        FormData fdFileComp = new FormData();
        fdFileComp.left = new FormAttachment(0, 0);
        fdFileComp.top = new FormAttachment(0, 0);
        fdFileComp.right = new FormAttachment(100, 0);
        fdFileComp.bottom = new FormAttachment(100, 0);
        wFileComp.setLayoutData((Object)fdFileComp);
        wFileComp.layout();
        wFileTab.setControl((Control)wFileComp);
        this.middle = this.props.getMiddlePct();
        CTabItem wContentTab = new CTabItem(this.wTabFolder, 0);
        wContentTab.setFont(GuiResource.getInstance().getFontDefault());
        wContentTab.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.Content.Tab", (String[])new String[0]));
        FormLayout contentLayout = new FormLayout();
        contentLayout.marginWidth = 3;
        contentLayout.marginHeight = 3;
        Composite wContentComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wContentComp);
        wContentComp.setLayout((Layout)contentLayout);
        Group wFileConf = new Group(wContentComp, 32);
        PropsUi.setLook((Widget)wFileConf);
        wFileConf.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FileConf.Label", (String[])new String[0]));
        FormLayout xmlConfgroupLayout = new FormLayout();
        xmlConfgroupLayout.marginWidth = 10;
        xmlConfgroupLayout.marginHeight = 10;
        wFileConf.setLayout((Layout)xmlConfgroupLayout);
        this.wlEncoding = new Label((Composite)wFileConf, 131072);
        this.wlEncoding.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.Encoding.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlEncoding);
        FormData fdlEncoding = new FormData();
        fdlEncoding.left = new FormAttachment(0, 0);
        fdlEncoding.top = new FormAttachment(0, this.margin);
        fdlEncoding.right = new FormAttachment(this.middle, -this.margin);
        this.wlEncoding.setLayoutData((Object)fdlEncoding);
        this.wEncoding = new CCombo((Composite)wFileConf, 2056);
        this.wEncoding.setEditable(true);
        PropsUi.setLook((Widget)this.wEncoding);
        this.wEncoding.addModifyListener(this.lsMod);
        FormData fdEncoding = new FormData();
        fdEncoding.left = new FormAttachment(this.middle, 0);
        fdEncoding.top = new FormAttachment(0, this.margin);
        fdEncoding.right = new FormAttachment(100, 0);
        this.wEncoding.setLayoutData((Object)fdEncoding);
        this.wEncoding.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                LoadFileInputDialog.this.setEncodings();
            }
        });
        Label wlIgnoreEmptyFile = new Label((Composite)wFileConf, 131072);
        wlIgnoreEmptyFile.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.IgnoreEmptyFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIgnoreEmptyFile);
        FormData fdlIgnoreEmptyFile = new FormData();
        fdlIgnoreEmptyFile.left = new FormAttachment(0, 0);
        fdlIgnoreEmptyFile.top = new FormAttachment((Control)this.wEncoding, this.margin);
        fdlIgnoreEmptyFile.right = new FormAttachment(this.middle, -this.margin);
        wlIgnoreEmptyFile.setLayoutData((Object)fdlIgnoreEmptyFile);
        this.wIgnoreEmptyFile = new Button((Composite)wFileConf, 32);
        PropsUi.setLook((Widget)this.wIgnoreEmptyFile);
        this.wIgnoreEmptyFile.setToolTipText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.IgnoreEmptyFile.Tooltip", (String[])new String[0]));
        FormData fdIgnoreEmptyFile = new FormData();
        fdIgnoreEmptyFile.left = new FormAttachment(this.middle, 0);
        fdIgnoreEmptyFile.top = new FormAttachment((Control)wlIgnoreEmptyFile, 0, 0x1000000);
        this.wIgnoreEmptyFile.setLayoutData((Object)fdIgnoreEmptyFile);
        this.wIgnoreEmptyFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoadFileInputDialog.this.input.setChanged();
            }
        });
        Label wlIgnoreMissingPath = new Label((Composite)wFileConf, 131072);
        wlIgnoreMissingPath.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.IgnoreMissingPath.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIgnoreMissingPath);
        FormData fdlIgnoreMissingPath = new FormData();
        fdlIgnoreMissingPath.left = new FormAttachment(0, 0);
        fdlIgnoreMissingPath.top = new FormAttachment((Control)this.wIgnoreEmptyFile, this.margin);
        fdlIgnoreMissingPath.right = new FormAttachment(this.middle, -this.margin);
        wlIgnoreMissingPath.setLayoutData((Object)fdlIgnoreMissingPath);
        this.wIgnoreMissingPath = new Button((Composite)wFileConf, 32);
        PropsUi.setLook((Widget)this.wIgnoreMissingPath);
        this.wIgnoreMissingPath.setToolTipText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.IgnoreMissingPath.Tooltip", (String[])new String[0]));
        FormData fdIgnoreMissingPath = new FormData();
        fdIgnoreMissingPath.left = new FormAttachment(this.middle, 0);
        fdIgnoreMissingPath.top = new FormAttachment((Control)wlIgnoreMissingPath, 0, 0x1000000);
        this.wIgnoreMissingPath.setLayoutData((Object)fdIgnoreMissingPath);
        this.wIgnoreMissingPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoadFileInputDialog.this.input.setChanged();
            }
        });
        Label wlLimit = new Label((Composite)wFileConf, 131072);
        wlLimit.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.Limit.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLimit);
        FormData fdlLimit = new FormData();
        fdlLimit.left = new FormAttachment(0, 0);
        fdlLimit.top = new FormAttachment((Control)this.wIgnoreMissingPath, this.margin);
        fdlLimit.right = new FormAttachment(this.middle, -this.margin);
        wlLimit.setLayoutData((Object)fdlLimit);
        this.wLimit = new Text((Composite)wFileConf, 18436);
        PropsUi.setLook((Widget)this.wLimit);
        this.wLimit.addModifyListener(this.lsMod);
        FormData fdLimit = new FormData();
        fdLimit.left = new FormAttachment(this.middle, 0);
        fdLimit.top = new FormAttachment((Control)this.wIgnoreMissingPath, this.margin);
        fdLimit.right = new FormAttachment(100, 0);
        this.wLimit.setLayoutData((Object)fdLimit);
        FormData fdXmlConf = new FormData();
        fdXmlConf.left = new FormAttachment(0, this.margin);
        fdXmlConf.top = new FormAttachment(0, this.margin);
        fdXmlConf.right = new FormAttachment(100, -this.margin);
        wFileConf.setLayoutData((Object)fdXmlConf);
        Group wAdditionalFields = new Group(wContentComp, 32);
        PropsUi.setLook((Widget)wAdditionalFields);
        wAdditionalFields.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.wAdditionalFields.Label", (String[])new String[0]));
        FormLayout additionalFieldsgroupLayout = new FormLayout();
        additionalFieldsgroupLayout.marginWidth = 10;
        additionalFieldsgroupLayout.marginHeight = 10;
        wAdditionalFields.setLayout((Layout)additionalFieldsgroupLayout);
        this.wlInclFilename = new Label((Composite)wAdditionalFields, 131072);
        this.wlInclFilename.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.InclFilename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlInclFilename);
        FormData fdlInclFilename = new FormData();
        fdlInclFilename.left = new FormAttachment(0, 0);
        fdlInclFilename.top = new FormAttachment((Control)wFileConf, 4 * this.margin);
        fdlInclFilename.right = new FormAttachment(this.middle, -this.margin);
        this.wlInclFilename.setLayoutData((Object)fdlInclFilename);
        this.wInclFilename = new Button((Composite)wAdditionalFields, 32);
        PropsUi.setLook((Widget)this.wInclFilename);
        this.wInclFilename.setToolTipText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.InclFilename.Tooltip", (String[])new String[0]));
        FormData fdInclFilename = new FormData();
        fdInclFilename.left = new FormAttachment(this.middle, 0);
        fdInclFilename.top = new FormAttachment((Control)this.wlInclFilename, 0, 0x1000000);
        this.wInclFilename.setLayoutData((Object)fdInclFilename);
        this.wlInclFilenameField = new Label((Composite)wAdditionalFields, 16384);
        this.wlInclFilenameField.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.InclFilenameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlInclFilenameField);
        FormData fdlInclFilenameField = new FormData();
        fdlInclFilenameField.left = new FormAttachment((Control)this.wInclFilename, this.margin);
        fdlInclFilenameField.top = new FormAttachment((Control)this.wLimit, 4 * this.margin);
        this.wlInclFilenameField.setLayoutData((Object)fdlInclFilenameField);
        this.wInclFilenameField = new TextVar(this.variables, (Composite)wAdditionalFields, 18436);
        PropsUi.setLook((Widget)this.wInclFilenameField);
        this.wInclFilenameField.addModifyListener(this.lsMod);
        FormData fdInclFilenameField = new FormData();
        fdInclFilenameField.left = new FormAttachment((Control)this.wlInclFilenameField, this.margin);
        fdInclFilenameField.top = new FormAttachment((Control)this.wLimit, 4 * this.margin);
        fdInclFilenameField.right = new FormAttachment(100, 0);
        this.wInclFilenameField.setLayoutData((Object)fdInclFilenameField);
        Label wlInclRownum = new Label((Composite)wAdditionalFields, 131072);
        wlInclRownum.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.InclRownum.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlInclRownum);
        FormData fdlInclRownum = new FormData();
        fdlInclRownum.left = new FormAttachment(0, 0);
        fdlInclRownum.top = new FormAttachment((Control)this.wInclFilenameField, this.margin);
        fdlInclRownum.right = new FormAttachment(this.middle, -this.margin);
        wlInclRownum.setLayoutData((Object)fdlInclRownum);
        this.wInclRownum = new Button((Composite)wAdditionalFields, 32);
        PropsUi.setLook((Widget)this.wInclRownum);
        this.wInclRownum.setToolTipText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.InclRownum.Tooltip", (String[])new String[0]));
        FormData fdRownum = new FormData();
        fdRownum.left = new FormAttachment(this.middle, 0);
        fdRownum.top = new FormAttachment((Control)wlInclRownum, 0, 0x1000000);
        this.wInclRownum.setLayoutData((Object)fdRownum);
        this.wlInclRownumField = new Label((Composite)wAdditionalFields, 131072);
        this.wlInclRownumField.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.InclRownumField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlInclRownumField);
        FormData fdlInclRownumField = new FormData();
        fdlInclRownumField.left = new FormAttachment((Control)this.wInclRownum, this.margin);
        fdlInclRownumField.top = new FormAttachment((Control)this.wInclFilenameField, this.margin);
        this.wlInclRownumField.setLayoutData((Object)fdlInclRownumField);
        this.wInclRownumField = new TextVar(this.variables, (Composite)wAdditionalFields, 18436);
        PropsUi.setLook((Widget)this.wInclRownumField);
        this.wInclRownumField.addModifyListener(this.lsMod);
        FormData fdInclRownumField = new FormData();
        fdInclRownumField.left = new FormAttachment((Control)this.wlInclRownumField, this.margin);
        fdInclRownumField.top = new FormAttachment((Control)this.wInclFilenameField, this.margin);
        fdInclRownumField.right = new FormAttachment(100, 0);
        this.wInclRownumField.setLayoutData((Object)fdInclRownumField);
        FormData fdAdditionalFields = new FormData();
        fdAdditionalFields.left = new FormAttachment(0, this.margin);
        fdAdditionalFields.top = new FormAttachment((Control)wFileConf, this.margin);
        fdAdditionalFields.right = new FormAttachment(100, -this.margin);
        wAdditionalFields.setLayoutData((Object)fdAdditionalFields);
        Group wAddFileResult = new Group(wContentComp, 32);
        PropsUi.setLook((Widget)wAddFileResult);
        wAddFileResult.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.wAddFileResult.Label", (String[])new String[0]));
        FormLayout addFileResultgroupLayout = new FormLayout();
        addFileResultgroupLayout.marginWidth = 10;
        addFileResultgroupLayout.marginHeight = 10;
        wAddFileResult.setLayout((Layout)addFileResultgroupLayout);
        this.wlAddResult = new Label((Composite)wAddFileResult, 131072);
        this.wlAddResult.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.AddResult.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlAddResult);
        FormData fdlAddResult = new FormData();
        fdlAddResult.left = new FormAttachment(0, 0);
        fdlAddResult.top = new FormAttachment((Control)wAdditionalFields, this.margin);
        fdlAddResult.right = new FormAttachment(this.middle, -this.margin);
        this.wlAddResult.setLayoutData((Object)fdlAddResult);
        this.wAddResult = new Button((Composite)wAddFileResult, 32);
        PropsUi.setLook((Widget)this.wAddResult);
        this.wAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.AddResult.Tooltip", (String[])new String[0]));
        FormData fdAddResult = new FormData();
        fdAddResult.left = new FormAttachment(this.middle, 0);
        fdAddResult.top = new FormAttachment((Control)this.wlAddResult, 0, 0x1000000);
        this.wAddResult.setLayoutData((Object)fdAddResult);
        this.wAddResult.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoadFileInputDialog.this.input.setChanged();
            }
        });
        FormData fdAddFileResult = new FormData();
        fdAddFileResult.left = new FormAttachment(0, this.margin);
        fdAddFileResult.top = new FormAttachment((Control)wAdditionalFields, this.margin);
        fdAddFileResult.right = new FormAttachment(100, -this.margin);
        wAddFileResult.setLayoutData((Object)fdAddFileResult);
        FormData fdContentComp = new FormData();
        fdContentComp.left = new FormAttachment(0, 0);
        fdContentComp.top = new FormAttachment(0, 0);
        fdContentComp.right = new FormAttachment(100, 0);
        fdContentComp.bottom = new FormAttachment(100, 0);
        wContentComp.setLayoutData((Object)fdContentComp);
        wContentComp.layout();
        wContentTab.setControl((Control)wContentComp);
        CTabItem wFieldsTab = new CTabItem(this.wTabFolder, 0);
        wFieldsTab.setFont(GuiResource.getInstance().getFontDefault());
        wFieldsTab.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.Fields.Tab", (String[])new String[0]));
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = PropsUi.getFormMargin();
        fieldsLayout.marginHeight = PropsUi.getFormMargin();
        Composite wFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        wFieldsComp.setLayout((Layout)fieldsLayout);
        PropsUi.setLook((Widget)wFieldsComp);
        this.wGet = new Button(wFieldsComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.GetFields.Button", (String[])new String[0]));
        this.fdGet = new FormData();
        this.fdGet.left = new FormAttachment(50, 0);
        this.fdGet.bottom = new FormAttachment(100, 0);
        this.wGet.setLayoutData((Object)this.fdGet);
        int FieldsRows = this.input.getInputFields().length;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FieldsTable.Name.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FieldsTable.Element.Column", (String[])new String[0]), 2, LoadFileInputField.ElementTypeDesc, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FieldsTable.Type.Column", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames(), true), new ColumnInfo(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FieldsTable.Format.Column", (String[])new String[0]), 5, 3), new ColumnInfo(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FieldsTable.Length.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FieldsTable.Precision.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FieldsTable.Currency.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FieldsTable.Decimal.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FieldsTable.Group.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FieldsTable.TrimType.Column", (String[])new String[0]), 2, LoadFileInputField.trimTypeDesc, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FieldsTable.Repeat.Column", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)CONST_COMBO_YES, (String[])new String[0]), BaseMessages.getString(PKG, (String)CONST_COMBO_NO, (String[])new String[0])}, true)};
        colinf[0].setUsingVariables(true);
        colinf[0].setToolTip(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FieldsTable.Name.Column.Tooltip", (String[])new String[0]));
        colinfo[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.Required.Column", (String[])new String[0]), 2, YES_NO_COMBO);
        colinfo[2].setToolTip(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.Required.Tooltip", (String[])new String[0]));
        colinfo[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.IncludeSubDirs.Column", (String[])new String[0]), 2, YES_NO_COMBO);
        colinfo[3].setToolTip(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.IncludeSubDirs.Tooltip", (String[])new String[0]));
        this.wFields = new TableView(this.variables, wFieldsComp, 65538, colinf, FieldsRows, this.lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wGet, -this.margin);
        this.wFields.setLayoutData((Object)fdFields);
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, 0);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fdFieldsComp);
        wFieldsComp.layout();
        wFieldsTab.setControl((Control)wFieldsComp);
        this.addAdditionalFieldsTab();
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, this.margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * this.margin);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wGet.addListener(13, e -> this.get());
        SelectionAdapter selA = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LoadFileInputDialog.this.wFilenameList.add(new String[]{LoadFileInputDialog.this.wFilename.getText(), LoadFileInputDialog.this.wFilemask.getText(), LoadFileInputDialog.this.wExcludeFilemask.getText(), LoadFileInputMeta.RequiredFilesCode[0], LoadFileInputMeta.RequiredFilesCode[0]});
                LoadFileInputDialog.this.wFilename.setText("");
                LoadFileInputDialog.this.wFilemask.setText("");
                LoadFileInputDialog.this.wExcludeFilemask.setText("");
                LoadFileInputDialog.this.wFilenameList.removeEmptyRows();
                LoadFileInputDialog.this.wFilenameList.setRowNums();
                LoadFileInputDialog.this.wFilenameList.optWidth(true);
            }
        };
        this.wbaFilename.addSelectionListener((SelectionListener)selA);
        this.wFilename.addSelectionListener(selA);
        this.wbdFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] idx = LoadFileInputDialog.this.wFilenameList.getSelectionIndices();
                LoadFileInputDialog.this.wFilenameList.remove(idx);
                LoadFileInputDialog.this.wFilenameList.removeEmptyRows();
                LoadFileInputDialog.this.wFilenameList.setRowNums();
            }
        });
        this.wbeFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int idx = LoadFileInputDialog.this.wFilenameList.getSelectionIndex();
                if (idx >= 0) {
                    String[] string = LoadFileInputDialog.this.wFilenameList.getItem(idx);
                    LoadFileInputDialog.this.wFilename.setText(string[0]);
                    LoadFileInputDialog.this.wFilemask.setText(string[1]);
                    LoadFileInputDialog.this.wExcludeFilemask.setText(string[2]);
                    LoadFileInputDialog.this.wFilenameList.remove(idx);
                }
                LoadFileInputDialog.this.wFilenameList.removeEmptyRows();
                LoadFileInputDialog.this.wFilenameList.setRowNums();
            }
        });
        this.wbShowFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    LoadFileInputMeta tfii = new LoadFileInputMeta();
                    LoadFileInputDialog.this.getInfo(tfii);
                    FileInputList fileInputList = tfii.getFiles(LoadFileInputDialog.this.variables);
                    String[] files = fileInputList.getFileStrings();
                    if (files != null && files.length > 0) {
                        EnterSelectionDialog esd = new EnterSelectionDialog(LoadFileInputDialog.this.shell, files, BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FilesReadSelection.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FilesReadSelection.DialogMessage", (String[])new String[0]));
                        esd.setViewOnly();
                        esd.open();
                    } else {
                        MessageBox mb = new MessageBox(LoadFileInputDialog.this.shell, 33);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.NoFileFound.DialogMessage", (String[])new String[0]));
                        mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                        mb.open();
                    }
                }
                catch (Exception ex) {
                    new ErrorDialog(LoadFileInputDialog.this.shell, BaseMessages.getString(PKG, (String)"LoadFileInputDialog.ErrorParsingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LoadFileInputDialog.ErrorParsingData.DialogMessage", (String[])new String[0]), ex);
                }
            }
        });
        this.wInclFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoadFileInputDialog.this.setIncludeFilename();
                LoadFileInputDialog.this.input.setChanged();
            }
        });
        this.wInclRownum.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoadFileInputDialog.this.setIncludeRownum();
                LoadFileInputDialog.this.input.setChanged();
            }
        });
        this.wFilename.addModifyListener(e -> this.wFilename.setToolTipText(this.wFilename.getText()));
        this.wbbFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!Utils.isEmpty((CharSequence)LoadFileInputDialog.this.wFilemask.getText()) || !Utils.isEmpty((CharSequence)LoadFileInputDialog.this.wExcludeFilemask.getText())) {
                    BaseDialog.presentDirectoryDialog((Shell)LoadFileInputDialog.this.shell, (TextVar)LoadFileInputDialog.this.wFilename, (IVariables)LoadFileInputDialog.this.variables);
                } else {
                    BaseDialog.presentFileDialog((Shell)LoadFileInputDialog.this.shell, (TextVar)LoadFileInputDialog.this.wFilename, (IVariables)LoadFileInputDialog.this.variables, (String[])new String[]{"*.txt;", "*.csv", "*.TRT", "*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"System.FileType.TextFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FileType.TextAndCSVFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LoadFileInput.FileType.TRTFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true);
                }
            }
        });
        this.wTabFolder.setSelection(0);
        this.getData(this.input);
        this.activateXmlStreamField();
        this.input.setChanged(this.changed);
        this.wFields.optWidth(true);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void setDynamicFilenameField() {
        if (!this.gotPreviousFields) {
            try {
                String field = this.wFilenameField.getText();
                this.wFilenameField.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wFilenameField.setItems(r.getFieldNames());
                }
                if (field != null) {
                    this.wFilenameField.setText(field);
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LoadFileInputDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            this.gotPreviousFields = true;
        }
    }

    private void activateXmlStreamField() {
        this.wlFilenameField.setEnabled(this.wFilenameInField.getSelection());
        this.wFilenameField.setEnabled(this.wFilenameInField.getSelection());
        this.wlFilename.setEnabled(!this.wFilenameInField.getSelection());
        this.wbbFilename.setEnabled(!this.wFilenameInField.getSelection());
        this.wbaFilename.setEnabled(!this.wFilenameInField.getSelection());
        this.wFilename.setEnabled(!this.wFilenameInField.getSelection());
        this.wlFilemask.setEnabled(!this.wFilenameInField.getSelection());
        this.wFilemask.setEnabled(!this.wFilenameInField.getSelection());
        this.wlExcludeFilemask.setEnabled(!this.wFilenameInField.getSelection());
        this.wExcludeFilemask.setEnabled(!this.wFilenameInField.getSelection());
        this.wlFilenameList.setEnabled(!this.wFilenameInField.getSelection());
        this.wbdFilename.setEnabled(!this.wFilenameInField.getSelection());
        this.wbeFilename.setEnabled(!this.wFilenameInField.getSelection());
        this.wbShowFiles.setEnabled(!this.wFilenameInField.getSelection());
        this.wlFilenameList.setEnabled(!this.wFilenameInField.getSelection());
        this.wFilenameList.setEnabled(!this.wFilenameInField.getSelection());
        this.wInclFilename.setEnabled(!this.wFilenameInField.getSelection());
        this.wlInclFilename.setEnabled(!this.wFilenameInField.getSelection());
        if (this.wFilenameInField.getSelection()) {
            this.wInclFilename.setSelection(false);
            this.wlInclFilenameField.setEnabled(false);
            this.wInclFilenameField.setEnabled(false);
        } else {
            this.wlInclFilenameField.setEnabled(this.wInclFilename.getSelection());
            this.wInclFilenameField.setEnabled(this.wInclFilename.getSelection());
        }
        if (this.wFilenameInField.getSelection()) {
            this.wEncoding.setEnabled(false);
            this.wlEncoding.setEnabled(false);
        } else {
            this.wEncoding.setEnabled(true);
            this.wlEncoding.setEnabled(true);
        }
        this.wAddResult.setEnabled(!this.wFilenameInField.getSelection());
        this.wlAddResult.setEnabled(!this.wFilenameInField.getSelection());
        this.wLimit.setEnabled(!this.wFilenameInField.getSelection());
        this.wPreview.setEnabled(!this.wFilenameInField.getSelection());
    }

    private void get() {
        int clearFields = 128;
        int nrInputFields = this.wFields.nrNonEmpty();
        if (nrInputFields > 0) {
            MessageBox mb = new MessageBox(this.shell, 196);
            mb.setMessage(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.ClearFieldList.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.ClearFieldList.DialogTitle", (String[])new String[0]));
            clearFields = mb.open();
        }
        if (clearFields == 64) {
            this.wFields.table.removeAll();
        }
        TableItem item = new TableItem(this.wFields.table, 0);
        item.setText(1, LoadFileInputField.ElementTypeDesc[0]);
        item.setText(2, LoadFileInputField.ElementTypeDesc[0]);
        item.setText(3, "String");
        item = new TableItem(this.wFields.table, 0);
        item.setText(1, LoadFileInputField.ElementTypeDesc[1]);
        item.setText(2, LoadFileInputField.ElementTypeDesc[1]);
        item.setText(3, "Integer");
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
    }

    private void setEncodings() {
        if (!this.gotEncodings) {
            this.gotEncodings = true;
            String encoding = this.wEncoding.getText();
            this.wEncoding.removeAll();
            ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
            for (Charset charSet : values) {
                this.wEncoding.add(charSet.displayName());
            }
            if (!Utils.isEmpty((CharSequence)encoding)) {
                this.wEncoding.setText(encoding);
            }
        }
    }

    public void setIncludeFilename() {
        this.wlInclFilenameField.setEnabled(this.wInclFilename.getSelection());
        this.wInclFilenameField.setEnabled(this.wInclFilename.getSelection());
    }

    public void setIncludeRownum() {
        this.wlInclRownumField.setEnabled(this.wInclRownum.getSelection());
        this.wInclRownumField.setEnabled(this.wInclRownum.getSelection());
    }

    public void getData(LoadFileInputMeta in) {
        int i;
        if (in.getFileName() != null) {
            this.wFilenameList.removeAll();
            for (i = 0; i < in.getFileName().length; ++i) {
                this.wFilenameList.add(new String[]{in.getFileName()[i], in.getFileMask()[i], in.getExcludeFileMask()[i], in.getRequiredFilesDesc(in.getFileRequired()[i]), in.getRequiredFilesDesc(in.getIncludeSubFolders()[i])});
            }
            this.wFilenameList.removeEmptyRows();
            this.wFilenameList.setRowNums();
            this.wFilenameList.optWidth(true);
        }
        this.wInclFilename.setSelection(in.getIncludeFilename());
        this.wInclRownum.setSelection(in.getIncludeRowNumber());
        this.wAddResult.setSelection(in.getAddResultFile());
        this.wIgnoreEmptyFile.setSelection(in.isIgnoreEmptyFile());
        this.wIgnoreMissingPath.setSelection(in.isIgnoreMissingPath());
        this.wFilenameInField.setSelection(in.getFileInFields());
        if (in.getDynamicFilenameField() != null) {
            this.wFilenameField.setText(in.getDynamicFilenameField());
        }
        if (in.getFilenameField() != null) {
            this.wInclFilenameField.setText(in.getFilenameField());
        }
        if (in.getRowNumberField() != null) {
            this.wInclRownumField.setText(in.getRowNumberField());
        }
        this.wLimit.setText("" + in.getRowLimit());
        this.wEncoding.setText(Const.NVL((String)in.getEncoding(), (String)""));
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.Log.GettingFieldsInfo", (String[])new String[0]));
        }
        for (i = 0; i < in.getInputFields().length; ++i) {
            String rep;
            LoadFileInputField field = in.getInputFields()[i];
            if (field == null) continue;
            TableItem item = this.wFields.table.getItem(i);
            String name = field.getName();
            String element = field.getElementTypeDesc();
            String type = field.getTypeDesc();
            String format = field.getFormat();
            String length = "" + field.getLength();
            String prec = "" + field.getPrecision();
            String curr = field.getCurrencySymbol();
            String group = field.getGroupSymbol();
            String decim = field.getDecimalSymbol();
            String trim = field.getTrimTypeDesc();
            String string = rep = field.isRepeated() ? BaseMessages.getString(PKG, (String)CONST_COMBO_YES, (String[])new String[0]) : BaseMessages.getString(PKG, (String)CONST_COMBO_NO, (String[])new String[0]);
            if (name != null) {
                item.setText(1, name);
            }
            if (element != null) {
                item.setText(2, element);
            }
            if (type != null) {
                item.setText(3, type);
            }
            if (format != null) {
                item.setText(4, format);
            }
            if (length != null && !"-1".equals(length)) {
                item.setText(5, length);
            }
            if (prec != null && !"-1".equals(prec)) {
                item.setText(6, prec);
            }
            if (curr != null) {
                item.setText(7, curr);
            }
            if (decim != null) {
                item.setText(8, decim);
            }
            if (group != null) {
                item.setText(9, group);
            }
            if (trim != null) {
                item.setText(10, trim);
            }
            if (rep == null) continue;
            item.setText(11, rep);
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        if (in.getShortFileNameField() != null) {
            this.wShortFileFieldName.setText(in.getShortFileNameField());
        }
        if (in.getPathField() != null) {
            this.wPathFieldName.setText(in.getPathField());
        }
        if (in.isHiddenField() != null) {
            this.wIsHiddenName.setText(in.isHiddenField());
        }
        if (in.getLastModificationDateField() != null) {
            this.wLastModificationTimeName.setText(in.getLastModificationDateField());
        }
        if (in.getUriField() != null) {
            this.wUriName.setText(in.getUriField());
        }
        if (in.getRootUriField() != null) {
            this.wRootUriName.setText(in.getRootUriField());
        }
        if (in.getExtensionField() != null) {
            this.wExtensionFieldName.setText(in.getExtensionField());
        }
        this.setIncludeFilename();
        this.setIncludeRownum();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        try {
            this.getInfo(this.input);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"LoadFileInputDialog.ErrorParsingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LoadFileInputDialog.ErrorParsingData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
        this.dispose();
    }

    private void getInfo(LoadFileInputMeta in) throws HopException {
        this.transformName = this.wTransformName.getText();
        in.setRowLimit(Const.toLong((String)this.wLimit.getText(), (long)0L));
        in.setEncoding(this.wEncoding.getText());
        in.setRowNumberField(this.wInclRownumField.getText());
        in.setAddResultFile(this.wAddResult.getSelection());
        in.setIgnoreEmptyFile(this.wIgnoreEmptyFile.getSelection());
        in.setIgnoreMissingPath(this.wIgnoreMissingPath.getSelection());
        in.setIncludeFilename(this.wInclFilename.getSelection());
        in.setFilenameField(this.wInclFilenameField.getText());
        in.setIncludeRowNumber(this.wInclRownum.getSelection());
        in.setFileInFields(this.wFilenameInField.getSelection());
        in.setDynamicFilenameField(this.wFilenameField.getText());
        int nrFields = this.wFields.nrNonEmpty();
        if (this.wFilenameInField.getSelection()) {
            in.allocate(0, nrFields);
            in.setFileName(new String[0]);
            in.setFileMask(new String[0]);
            in.setExcludeFileMask(new String[0]);
            in.setFileRequired(new String[0]);
            in.setIncludeSubFolders(new String[0]);
        } else {
            in.allocate(this.wFilenameList.getItemCount(), nrFields);
            in.setFileName(this.wFilenameList.getItems(0));
            in.setFileMask(this.wFilenameList.getItems(1));
            in.setExcludeFileMask(this.wFilenameList.getItems(2));
            in.setFileRequired(this.wFilenameList.getItems(3));
            in.setIncludeSubFolders(this.wFilenameList.getItems(4));
        }
        for (int i = 0; i < nrFields; ++i) {
            LoadFileInputField field = new LoadFileInputField();
            TableItem item = this.wFields.getNonEmpty(i);
            field.setName(item.getText(1));
            field.setElementType(LoadFileInputField.getElementTypeByDesc(item.getText(2)));
            field.setType(ValueMetaFactory.getIdForValueMeta((String)item.getText(3)));
            field.setFormat(item.getText(4));
            field.setLength(Const.toInt((String)item.getText(5), (int)-1));
            field.setPrecision(Const.toInt((String)item.getText(6), (int)-1));
            field.setCurrencySymbol(item.getText(7));
            field.setDecimalSymbol(item.getText(8));
            field.setGroupSymbol(item.getText(9));
            field.setTrimType(LoadFileInputField.getTrimTypeByDesc(item.getText(10)));
            field.setRepeated(BaseMessages.getString(PKG, (String)CONST_COMBO_YES, (String[])new String[0]).equalsIgnoreCase(item.getText(11)));
            in.getInputFields()[i] = field;
        }
        in.setShortFileNameField(this.wShortFileFieldName.getText());
        in.setPathField(this.wPathFieldName.getText());
        in.setIsHiddenField(this.wIsHiddenName.getText());
        in.setLastModificationDateField(this.wLastModificationTimeName.getText());
        in.setUriField(this.wUriName.getText());
        in.setRootUriField(this.wRootUriName.getText());
        in.setExtensionField(this.wExtensionFieldName.getText());
    }

    private void preview() {
        try {
            LoadFileInputMeta oneMeta = new LoadFileInputMeta();
            this.getInfo(oneMeta);
            EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"LoadFileInputDialog.NumberRows.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LoadFileInputDialog.NumberRows.DialogMessage", (String[])new String[0]));
            int previewSize = numberDialog.open();
            if (previewSize > 0) {
                oneMeta.setRowLimit(previewSize);
                PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.pipelineMeta.getMetadataProvider(), (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
                PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{previewSize});
                progressDialog.open();
                if (!progressDialog.isCancelled()) {
                    Pipeline pipeline = progressDialog.getPipeline();
                    String loggingText = progressDialog.getLoggingText();
                    if (pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                        EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                        etd.setReadOnly();
                        etd.open();
                    }
                    PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
                    prd.open();
                }
            }
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"LoadFileInputDialog.ErrorPreviewingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LoadFileInputDialog.ErrorPreviewingData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void addAdditionalFieldsTab() {
        CTabItem wAdditionalFieldsTab = new CTabItem(this.wTabFolder, 0);
        wAdditionalFieldsTab.setFont(GuiResource.getInstance().getFontDefault());
        wAdditionalFieldsTab.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.AdditionalFieldsTab.TabTitle", (String[])new String[0]));
        Composite wAdditionalFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wAdditionalFieldsComp);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 3;
        fieldsLayout.marginHeight = 3;
        wAdditionalFieldsComp.setLayout((Layout)fieldsLayout);
        Label wlShortFileFieldName = new Label(wAdditionalFieldsComp, 131072);
        wlShortFileFieldName.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.ShortFileFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlShortFileFieldName);
        FormData fdlShortFileFieldName = new FormData();
        fdlShortFileFieldName.left = new FormAttachment(0, 0);
        fdlShortFileFieldName.top = new FormAttachment((Control)this.wInclRownumField, this.margin);
        fdlShortFileFieldName.right = new FormAttachment(this.middle, -this.margin);
        wlShortFileFieldName.setLayoutData((Object)fdlShortFileFieldName);
        this.wShortFileFieldName = new TextVar(this.variables, wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wShortFileFieldName);
        this.wShortFileFieldName.addModifyListener(this.lsMod);
        FormData fdShortFileFieldName = new FormData();
        fdShortFileFieldName.left = new FormAttachment(this.middle, 0);
        fdShortFileFieldName.right = new FormAttachment(100, -this.margin);
        fdShortFileFieldName.top = new FormAttachment((Control)this.wInclRownumField, this.margin);
        this.wShortFileFieldName.setLayoutData((Object)fdShortFileFieldName);
        Label wlExtensionFieldName = new Label(wAdditionalFieldsComp, 131072);
        wlExtensionFieldName.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.ExtensionFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlExtensionFieldName);
        FormData fdlExtensionFieldName = new FormData();
        fdlExtensionFieldName.left = new FormAttachment(0, 0);
        fdlExtensionFieldName.top = new FormAttachment((Control)this.wShortFileFieldName, this.margin);
        fdlExtensionFieldName.right = new FormAttachment(this.middle, -this.margin);
        wlExtensionFieldName.setLayoutData((Object)fdlExtensionFieldName);
        this.wExtensionFieldName = new TextVar(this.variables, wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wExtensionFieldName);
        this.wExtensionFieldName.addModifyListener(this.lsMod);
        FormData fdExtensionFieldName = new FormData();
        fdExtensionFieldName.left = new FormAttachment(this.middle, 0);
        fdExtensionFieldName.right = new FormAttachment(100, -this.margin);
        fdExtensionFieldName.top = new FormAttachment((Control)this.wShortFileFieldName, this.margin);
        this.wExtensionFieldName.setLayoutData((Object)fdExtensionFieldName);
        Label wlPathFieldName = new Label(wAdditionalFieldsComp, 131072);
        wlPathFieldName.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.PathFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPathFieldName);
        FormData fdlPathFieldName = new FormData();
        fdlPathFieldName.left = new FormAttachment(0, 0);
        fdlPathFieldName.top = new FormAttachment((Control)this.wExtensionFieldName, this.margin);
        fdlPathFieldName.right = new FormAttachment(this.middle, -this.margin);
        wlPathFieldName.setLayoutData((Object)fdlPathFieldName);
        this.wPathFieldName = new TextVar(this.variables, wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wPathFieldName);
        this.wPathFieldName.addModifyListener(this.lsMod);
        FormData fdPathFieldName = new FormData();
        fdPathFieldName.left = new FormAttachment(this.middle, 0);
        fdPathFieldName.right = new FormAttachment(100, -this.margin);
        fdPathFieldName.top = new FormAttachment((Control)this.wExtensionFieldName, this.margin);
        this.wPathFieldName.setLayoutData((Object)fdPathFieldName);
        Label wlIsHiddenName = new Label(wAdditionalFieldsComp, 131072);
        wlIsHiddenName.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.IsHiddenName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIsHiddenName);
        FormData fdlIsHiddenName = new FormData();
        fdlIsHiddenName.left = new FormAttachment(0, 0);
        fdlIsHiddenName.top = new FormAttachment((Control)this.wPathFieldName, this.margin);
        fdlIsHiddenName.right = new FormAttachment(this.middle, -this.margin);
        wlIsHiddenName.setLayoutData((Object)fdlIsHiddenName);
        this.wIsHiddenName = new TextVar(this.variables, wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wIsHiddenName);
        this.wIsHiddenName.addModifyListener(this.lsMod);
        FormData fdIsHiddenName = new FormData();
        fdIsHiddenName.left = new FormAttachment(this.middle, 0);
        fdIsHiddenName.right = new FormAttachment(100, -this.margin);
        fdIsHiddenName.top = new FormAttachment((Control)this.wPathFieldName, this.margin);
        this.wIsHiddenName.setLayoutData((Object)fdIsHiddenName);
        Label wlLastModificationTimeName = new Label(wAdditionalFieldsComp, 131072);
        wlLastModificationTimeName.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.LastModificationTimeName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLastModificationTimeName);
        FormData fdlLastModificationTimeName = new FormData();
        fdlLastModificationTimeName.left = new FormAttachment(0, 0);
        fdlLastModificationTimeName.top = new FormAttachment((Control)this.wIsHiddenName, this.margin);
        fdlLastModificationTimeName.right = new FormAttachment(this.middle, -this.margin);
        wlLastModificationTimeName.setLayoutData((Object)fdlLastModificationTimeName);
        this.wLastModificationTimeName = new TextVar(this.variables, wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wLastModificationTimeName);
        this.wLastModificationTimeName.addModifyListener(this.lsMod);
        FormData fdLastModificationTimeName = new FormData();
        fdLastModificationTimeName.left = new FormAttachment(this.middle, 0);
        fdLastModificationTimeName.right = new FormAttachment(100, -this.margin);
        fdLastModificationTimeName.top = new FormAttachment((Control)this.wIsHiddenName, this.margin);
        this.wLastModificationTimeName.setLayoutData((Object)fdLastModificationTimeName);
        Label wlUriName = new Label(wAdditionalFieldsComp, 131072);
        wlUriName.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.UriName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUriName);
        FormData fdlUriName = new FormData();
        fdlUriName.left = new FormAttachment(0, 0);
        fdlUriName.top = new FormAttachment((Control)this.wLastModificationTimeName, this.margin);
        fdlUriName.right = new FormAttachment(this.middle, -this.margin);
        wlUriName.setLayoutData((Object)fdlUriName);
        this.wUriName = new TextVar(this.variables, wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wUriName);
        this.wUriName.addModifyListener(this.lsMod);
        FormData fdUriName = new FormData();
        fdUriName.left = new FormAttachment(this.middle, 0);
        fdUriName.right = new FormAttachment(100, -this.margin);
        fdUriName.top = new FormAttachment((Control)this.wLastModificationTimeName, this.margin);
        this.wUriName.setLayoutData((Object)fdUriName);
        Label wlRootUriName = new Label(wAdditionalFieldsComp, 131072);
        wlRootUriName.setText(BaseMessages.getString(PKG, (String)"LoadFileInputDialog.RootUriName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRootUriName);
        FormData fdlRootUriName = new FormData();
        fdlRootUriName.left = new FormAttachment(0, 0);
        fdlRootUriName.top = new FormAttachment((Control)this.wUriName, this.margin);
        fdlRootUriName.right = new FormAttachment(this.middle, -this.margin);
        wlRootUriName.setLayoutData((Object)fdlRootUriName);
        this.wRootUriName = new TextVar(this.variables, wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wRootUriName);
        this.wRootUriName.addModifyListener(this.lsMod);
        FormData fdRootUriName = new FormData();
        fdRootUriName.left = new FormAttachment(this.middle, 0);
        fdRootUriName.right = new FormAttachment(100, -this.margin);
        fdRootUriName.top = new FormAttachment((Control)this.wUriName, this.margin);
        this.wRootUriName.setLayoutData((Object)fdRootUriName);
        FormData fdAdditionalFieldsComp = new FormData();
        fdAdditionalFieldsComp.left = new FormAttachment(0, 0);
        fdAdditionalFieldsComp.top = new FormAttachment((Control)this.wTransformName, this.margin);
        fdAdditionalFieldsComp.right = new FormAttachment(100, 0);
        fdAdditionalFieldsComp.bottom = new FormAttachment(100, 0);
        wAdditionalFieldsComp.setLayoutData((Object)fdAdditionalFieldsComp);
        wAdditionalFieldsComp.layout();
        wAdditionalFieldsTab.setControl((Control)wAdditionalFieldsComp);
    }
}

