/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.jdbc.internal.ClickHouseParser;
import com.clickhouse.jdbc.internal.ClickHouseParserBaseListener;
import com.clickhouse.jdbc.internal.SqlParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsedPreparedStatement
extends ClickHouseParserBaseListener {
    private static final Logger LOG = LoggerFactory.getLogger(ParsedPreparedStatement.class);
    private String table;
    private String useDatabase;
    private String[] insertColumns;
    private boolean useFunction;
    private boolean hasErrors;
    private boolean hasResultSet;
    private boolean insert;
    private boolean insertWithSelect;
    private List<String> roles;
    private int argCount;
    private int[] paramPositions = new int[16];
    private int assignValuesListStartPosition = -1;
    private int assignValuesListStopPosition = -1;
    private int assignValuesGroups = -1;

    public void setHasResultSet(boolean hasResultSet) {
        this.hasResultSet = hasResultSet;
    }

    public boolean isHasResultSet() {
        return this.hasResultSet;
    }

    public void setInsert(boolean insert) {
        this.insert = insert;
    }

    public boolean isInsert() {
        return this.insert;
    }

    public void setInsertWithSelect(boolean insertWithSelect) {
        this.insertWithSelect = insertWithSelect;
    }

    public boolean isInsertWithSelect() {
        return this.insertWithSelect;
    }

    public int getArgCount() {
        return this.argCount;
    }

    public String[] getInsertColumns() {
        return this.insertColumns;
    }

    public String getTable() {
        return this.table;
    }

    public int[] getParamPositions() {
        return this.paramPositions;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public int getAssignValuesListStartPosition() {
        return this.assignValuesListStartPosition;
    }

    public int getAssignValuesListStopPosition() {
        return this.assignValuesListStopPosition;
    }

    public void setUseDatabase(String useDatabase) {
        this.useDatabase = useDatabase;
    }

    public String getUseDatabase() {
        return this.useDatabase;
    }

    public void setAssignValuesGroups(int assignValuesGroups) {
        this.assignValuesGroups = assignValuesGroups;
    }

    public int getAssignValuesGroups() {
        return this.assignValuesGroups;
    }

    public boolean isUseFunction() {
        return this.useFunction;
    }

    public void setUseFunction(boolean useFunction) {
        this.useFunction = useFunction;
    }

    public boolean isHasErrors() {
        return this.hasErrors;
    }

    public void setHasErrors(boolean hasErrors) {
        this.hasErrors = hasErrors;
    }

    @Override
    public void enterQueryStmt(ClickHouseParser.QueryStmtContext ctx) {
        ClickHouseParser.QueryContext qCtx = ctx.query();
        if (qCtx != null && (qCtx.selectStmt() != null || qCtx.selectUnionStmt() != null || qCtx.showStmt() != null || qCtx.describeStmt() != null)) {
            this.setHasResultSet(true);
        }
    }

    @Override
    public void enterUseStmt(ClickHouseParser.UseStmtContext ctx) {
        if (ctx.databaseIdentifier() != null) {
            this.setUseDatabase(SqlParser.unquoteIdentifier(ctx.databaseIdentifier().getText()));
        }
    }

    @Override
    public void enterSetRoleStmt(ClickHouseParser.SetRoleStmtContext ctx) {
        if (ctx.NONE() != null) {
            this.setRoles(Collections.emptyList());
        } else {
            ArrayList<String> roles = new ArrayList<String>();
            for (ClickHouseParser.IdentifierContext id : ctx.setRolesList().identifier()) {
                roles.add(SqlParser.unquoteIdentifier(id.getText()));
            }
            this.setRoles(roles);
        }
    }

    @Override
    public void enterColumnExprParam(ClickHouseParser.ColumnExprParamContext ctx) {
        this.appendParameter(ctx.start.getStartIndex());
    }

    @Override
    public void enterColumnExprParamWithCast(ClickHouseParser.ColumnExprParamWithCastContext ctx) {
        this.appendParameter(ctx.start.getStartIndex());
    }

    @Override
    public void visitErrorNode(ErrorNode node) {
        this.setHasErrors(true);
    }

    @Override
    public void enterInsertParameterFuncExpr(ClickHouseParser.InsertParameterFuncExprContext ctx) {
        this.setUseFunction(true);
    }

    @Override
    public void enterAssignmentValuesList(ClickHouseParser.AssignmentValuesListContext ctx) {
        this.assignValuesListStartPosition = ctx.getStart().getStartIndex();
        this.assignValuesListStopPosition = ctx.getStop().getStopIndex();
    }

    @Override
    public void enterInsertParameter(ClickHouseParser.InsertParameterContext ctx) {
        this.appendParameter(ctx.start.getStartIndex());
    }

    @Override
    public void enterFromClause(ClickHouseParser.FromClauseContext ctx) {
        if (ctx.QUERY() != null) {
            this.appendParameter(ctx.QUERY().getSymbol().getStartIndex());
        }
    }

    private void appendParameter(int startIndex) {
        ++this.argCount;
        if (this.argCount > this.paramPositions.length) {
            this.paramPositions = Arrays.copyOf(this.paramPositions, this.paramPositions.length + 10);
        }
        this.paramPositions[this.argCount - 1] = startIndex;
        if (LOG.isTraceEnabled()) {
            LOG.trace("parameter position {}", (Object)startIndex);
        }
    }

    @Override
    public void enterInsertStmt(ClickHouseParser.InsertStmtContext ctx) {
        ClickHouseParser.ColumnsClauseContext columns;
        ClickHouseParser.TableIdentifierContext tableId = ctx.tableIdentifier();
        if (tableId != null) {
            this.table = tableId.identifier().IDENTIFIER().getText();
        }
        if ((columns = ctx.columnsClause()) != null) {
            List<ClickHouseParser.NestedIdentifierContext> names = columns.nestedIdentifier();
            this.insertColumns = new String[names.size()];
            for (int i = 0; i < names.size(); ++i) {
                this.insertColumns[i] = names.get(i).getText();
            }
        }
        this.setInsert(true);
    }

    @Override
    public void enterDataClauseSelect(ClickHouseParser.DataClauseSelectContext ctx) {
        this.setInsertWithSelect(true);
    }

    @Override
    public void enterDataClauseValues(ClickHouseParser.DataClauseValuesContext ctx) {
        this.setAssignValuesGroups(ctx.assignmentValues().size());
    }

    @Override
    public void exitInsertParameterFuncExpr(ClickHouseParser.InsertParameterFuncExprContext ctx) {
        this.setUseFunction(true);
    }
}

