/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.databasejoin;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.databasejoin.DatabaseJoinData;
import org.apache.hop.pipeline.transforms.databasejoin.DatabaseJoinMeta;
import org.apache.hop.pipeline.transforms.databasejoin.ParameterField;
import org.apache.hop.pipeline.transforms.databasejoin.cache.DatabaseCache;

public class DatabaseJoin
extends BaseTransform<DatabaseJoinMeta, DatabaseJoinData> {
    private static final Class<?> PKG = DatabaseJoinMeta.class;
    private final ReentrantLock dbLock = new ReentrantLock();

    public DatabaseJoin(TransformMeta transformMeta, DatabaseJoinMeta meta, DatabaseJoinData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookupValues(IRowMeta rowMeta, Object[] rowData) throws HopException {
        this.dbLock.lock();
        if (this.first) {
            this.first = false;
            ((DatabaseJoinData)this.data).outputRowMeta = rowMeta.clone();
            ((DatabaseJoinMeta)this.meta).getFields(((DatabaseJoinData)this.data).outputRowMeta, this.getTransformName(), new IRowMeta[]{((DatabaseJoinMeta)this.meta).getTableFields((IVariables)this)}, null, (IVariables)this, this.metadataProvider);
            ((DatabaseJoinData)this.data).lookupRowMeta = new RowMeta();
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.CheckingRow", (String[])new String[0]) + rowMeta.getString(rowData));
            }
            ((DatabaseJoinData)this.data).keynrs = new int[((DatabaseJoinMeta)this.meta).getParameters().size()];
            for (int i = 0; i < ((DatabaseJoinData)this.data).keynrs.length; ++i) {
                ParameterField field = ((DatabaseJoinMeta)this.meta).getParameters().get(i);
                ((DatabaseJoinData)this.data).keynrs[i] = rowMeta.indexOfValue(field.getName());
                if (((DatabaseJoinData)this.data).keynrs[i] < 0) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"DatabaseJoin.Exception.FieldNotFound", (String[])new String[]{field.getName()}));
                }
                ((DatabaseJoinData)this.data).lookupRowMeta.addValueMeta(rowMeta.getValueMeta(((DatabaseJoinData)this.data).keynrs[i]).clone());
            }
        }
        try {
            Object[] lookupRowData = new Object[((DatabaseJoinData)this.data).lookupRowMeta.size()];
            for (int i = 0; i < ((DatabaseJoinData)this.data).keynrs.length; ++i) {
                lookupRowData[i] = rowData[((DatabaseJoinData)this.data).keynrs[i]];
            }
            List<Object[]> adds = this.getFromCacheOrFetch(lookupRowData);
            IRowMeta addMeta = ((DatabaseJoinData)this.data).db.getReturnRowMeta();
            int counter = 0;
            for (Object[] add : adds) {
                if (add == null || ((DatabaseJoinMeta)this.meta).getRowLimit() != 0 && counter >= ((DatabaseJoinMeta)this.meta).getRowLimit()) continue;
                ++counter;
                Object[] newRow = RowDataUtil.resizeArray((Object[])rowData, (int)((DatabaseJoinData)this.data).outputRowMeta.size());
                int newIndex = rowMeta.size();
                for (int i = 0; i < addMeta.size(); ++i) {
                    newRow[newIndex++] = add[i];
                }
                this.putRow(((DatabaseJoinData)this.data).outputRowMeta, ((DatabaseJoinData)this.data).outputRowMeta.cloneRow(newRow));
                if (!this.isRowLevel()) continue;
                this.logRowlevel(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.PutoutRow", (String[])new String[0]) + ((DatabaseJoinData)this.data).outputRowMeta.getString(newRow));
            }
            if (counter == 0 && ((DatabaseJoinMeta)this.meta).isOuterJoin()) {
                if (((DatabaseJoinData)this.data).notfound == null) {
                    ((DatabaseJoinData)this.data).notfound = new Object[((DatabaseJoinData)this.data).db.getReturnRowMeta().size()];
                }
                Object[] newRow = RowDataUtil.resizeArray((Object[])rowData, (int)((DatabaseJoinData)this.data).outputRowMeta.size());
                int newIndex = rowMeta.size();
                for (int i = 0; i < ((DatabaseJoinData)this.data).notfound.length; ++i) {
                    newRow[newIndex++] = ((DatabaseJoinData)this.data).notfound[i];
                }
                this.putRow(((DatabaseJoinData)this.data).outputRowMeta, newRow);
            }
        }
        finally {
            this.dbLock.unlock();
        }
    }

    private List<Object[]> getFromCacheOrFetch(Object[] lookupRowData) throws HopDatabaseException {
        if (((DatabaseJoinMeta)this.meta).isCached()) {
            List<Object[]> adds = ((DatabaseJoinData)this.data).cache.getRowsFromCache(((DatabaseJoinData)this.data).lookupRowMeta, lookupRowData);
            if (adds != null) {
                return adds;
            }
            List<Object[]> fromDatabase = this.fetchFromDatabase(lookupRowData);
            ((DatabaseJoinData)this.data).cache.putRowsIntoCache(((DatabaseJoinData)this.data).lookupRowMeta, lookupRowData, fromDatabase);
            return fromDatabase;
        }
        return this.fetchFromDatabase(lookupRowData);
    }

    private List<Object[]> fetchFromDatabase(Object[] lookupRowData) throws HopDatabaseException {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        ResultSet rs = ((DatabaseJoinData)this.data).db.openQuery(((DatabaseJoinData)this.data).pstmt, ((DatabaseJoinData)this.data).lookupRowMeta, lookupRowData);
        Object[] add = ((DatabaseJoinData)this.data).db.getRow(rs);
        while (add != null) {
            result.add(add);
            this.incrementLinesInput();
            add = ((DatabaseJoinData)this.data).db.getRow(rs);
        }
        ((DatabaseJoinData)this.data).db.closeQuery(rs);
        return result;
    }

    public boolean processRow() throws HopException {
        block5: {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            try {
                this.lookupValues(this.getInputRowMeta(), r);
                if (this.checkFeedback(this.getLinesRead()) && this.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (HopException e) {
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage(), e);
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block5;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "DBJOIN001");
            }
        }
        return true;
    }

    public void stopRunning() throws HopException {
        if (this.isStopped() || ((DatabaseJoinData)this.data).isDisposed()) {
            return;
        }
        this.dbLock.lock();
        try {
            if (((DatabaseJoinData)this.data).db != null && ((DatabaseJoinData)this.data).db.getConnection() != null && !((DatabaseJoinData)this.data).isCanceled) {
                ((DatabaseJoinData)this.data).db.cancelStatement((Statement)((DatabaseJoinData)this.data).pstmt);
                this.setStopped(true);
                ((DatabaseJoinData)this.data).isCanceled = true;
            }
        }
        finally {
            this.dbLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init() {
        if (super.init()) {
            if (Utils.isEmpty((CharSequence)((DatabaseJoinMeta)this.meta).getConnection())) {
                this.logError(BaseMessages.getString(PKG, (String)"DatabaseJoin.Init.ConnectionMissing", (String[])new String[]{this.getTransformName()}));
                return false;
            }
            this.dbLock.lock();
            try {
                DatabaseMeta databaseMeta = this.getPipelineMeta().findDatabase(((DatabaseJoinMeta)this.meta).getConnection(), this.variables);
                if (databaseMeta == null) {
                    this.logError(BaseMessages.getString(PKG, (String)"DatabaseJoin.Init.ConnectionMissing", (String[])new String[]{this.getTransformName()}));
                    boolean bl = false;
                    return bl;
                }
                ((DatabaseJoinData)this.data).db = new Database((ILoggingObject)this, (IVariables)this, databaseMeta);
                try {
                    ((DatabaseJoinData)this.data).db.connect();
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.ConnectedToDB", (String[])new String[0]));
                    }
                    String sql = ((DatabaseJoinMeta)this.meta).getSql();
                    if (((DatabaseJoinMeta)this.meta).isReplaceVariables()) {
                        sql = this.resolve(sql);
                    }
                    ((DatabaseJoinData)this.data).pstmt = ((DatabaseJoinData)this.data).db.prepareSql(sql);
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.SQLStatement", (String[])new String[]{sql}));
                    }
                    ((DatabaseJoinData)this.data).db.setQueryLimit(((DatabaseJoinMeta)this.meta).getRowLimit());
                    if (((DatabaseJoinMeta)this.meta).isCached()) {
                        ((DatabaseJoinData)this.data).cache = new DatabaseCache(((DatabaseJoinMeta)this.meta).getCacheSize());
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.DatabaseError", (String[])new String[0]) + e.getMessage(), e);
                    if (((DatabaseJoinData)this.data).db != null) {
                        ((DatabaseJoinData)this.data).db.disconnect();
                    }
                    this.dbLock.unlock();
                }
            }
            finally {
                this.dbLock.unlock();
            }
        }
        return false;
    }

    public void dispose() {
        this.dbLock.lock();
        try {
            if (((DatabaseJoinData)this.data).pstmt != null) {
                ((DatabaseJoinData)this.data).db.closePreparedStatement(((DatabaseJoinData)this.data).pstmt);
                ((DatabaseJoinData)this.data).pstmt = null;
            }
            super.dispose();
        }
        catch (HopDatabaseException e) {
            this.logError("Unexpected error closing statement : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            if (((DatabaseJoinData)this.data).db != null) {
                ((DatabaseJoinData)this.data).db.disconnect();
                ((DatabaseJoinData)this.data).db = null;
            }
            ((DatabaseJoinData)this.data).cache = null;
            this.dbLock.unlock();
        }
    }
}

