/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.parsing;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeParser;
import com.datastax.oss.driver.internal.core.type.DefaultUserDefinedType;
import com.datastax.oss.driver.internal.core.util.DirectedGraph;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class UserDefinedTypeParser {
    private final DataTypeParser dataTypeParser;
    private final InternalDriverContext context;

    public UserDefinedTypeParser(DataTypeParser dataTypeParser, InternalDriverContext context) {
        this.dataTypeParser = dataTypeParser;
        this.context = context;
    }

    public Map<CqlIdentifier, UserDefinedType> parse(Collection<AdminRow> typeRows, CqlIdentifier keyspaceId) {
        if (typeRows.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<CqlIdentifier, UserDefinedType> types = new LinkedHashMap<CqlIdentifier, UserDefinedType>();
        for (AdminRow row : this.topologicalSort(typeRows, keyspaceId)) {
            UserDefinedType type = this.parseType(row, keyspaceId, types);
            types.put(type.getName(), type);
        }
        return ImmutableMap.copyOf(types);
    }

    @VisibleForTesting
    Map<CqlIdentifier, UserDefinedType> parse(CqlIdentifier keyspaceId, AdminRow ... typeRows) {
        return this.parse(Arrays.asList(typeRows), keyspaceId);
    }

    private List<AdminRow> topologicalSort(Collection<AdminRow> typeRows, CqlIdentifier keyspaceId) {
        if (typeRows.size() == 1) {
            AdminRow row = typeRows.iterator().next();
            return Collections.singletonList(row);
        }
        DirectedGraph<AdminRow> graph = new DirectedGraph<AdminRow>(typeRows);
        for (AdminRow dependent : typeRows) {
            for (AdminRow dependency : typeRows) {
                if (dependent == dependency || !this.dependsOn(dependent, dependency, keyspaceId)) continue;
                graph.addEdge(dependency, dependent);
            }
        }
        return graph.topologicalSort();
    }

    private boolean dependsOn(AdminRow dependent, AdminRow dependency, CqlIdentifier keyspaceId) {
        CqlIdentifier dependencyId = CqlIdentifier.fromInternal(dependency.getString("type_name"));
        for (String fieldTypeName : dependent.getListOfString("field_types")) {
            DataType fieldType = this.dataTypeParser.parse(keyspaceId, fieldTypeName, null, this.context);
            if (!this.references(fieldType, dependencyId)) continue;
            return true;
        }
        return false;
    }

    private boolean references(DataType dependent, CqlIdentifier dependency) {
        if (dependent instanceof UserDefinedType) {
            UserDefinedType userType = (UserDefinedType)dependent;
            return userType.getName().equals(dependency);
        }
        if (dependent instanceof ListType) {
            ListType listType = (ListType)dependent;
            return this.references(listType.getElementType(), dependency);
        }
        if (dependent instanceof SetType) {
            SetType setType = (SetType)dependent;
            return this.references(setType.getElementType(), dependency);
        }
        if (dependent instanceof MapType) {
            MapType mapType = (MapType)dependent;
            return this.references(mapType.getKeyType(), dependency) || this.references(mapType.getValueType(), dependency);
        }
        if (dependent instanceof TupleType) {
            TupleType tupleType = (TupleType)dependent;
            for (DataType componentType : tupleType.getComponentTypes()) {
                if (!this.references(componentType, dependency)) continue;
                return true;
            }
        }
        return false;
    }

    private UserDefinedType parseType(AdminRow row, CqlIdentifier keyspaceId, Map<CqlIdentifier, UserDefinedType> userDefinedTypes) {
        CqlIdentifier name = CqlIdentifier.fromInternal(row.getString("type_name"));
        ImmutableList fieldNames = ImmutableList.copyOf((Collection)Lists.transform(row.getListOfString("field_names"), CqlIdentifier::fromInternal));
        List<DataType> fieldTypes = this.dataTypeParser.parse(keyspaceId, row.getListOfString("field_types"), userDefinedTypes, this.context);
        return new DefaultUserDefinedType(keyspaceId, name, false, (List<CqlIdentifier>)fieldNames, fieldTypes, this.context);
    }
}

