/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.laf;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hop.i18n.IMessageHandler;
import org.apache.hop.i18n.LafMessageHandler;

class RemoveAltKeyMessageHandler
implements IMessageHandler {
    private final IMessageHandler defMessageHandler;
    private final Pattern altKeyPattern = Pattern.compile("\\(&[A-Z]\\)(\\.{3})?$");

    public RemoveAltKeyMessageHandler() {
        this(new LafMessageHandler());
    }

    RemoveAltKeyMessageHandler(IMessageHandler messageHandler) {
        this.defMessageHandler = messageHandler;
    }

    @Override
    public String getString(String key) {
        return this.trimAltKey(this.defMessageHandler.getString(key));
    }

    @Override
    public String getString(String packageName, String key) {
        return this.trimAltKey(this.defMessageHandler.getString(packageName, key));
    }

    @Override
    public String getString(String packageName, String key, String ... parameters) {
        return this.trimAltKey(this.defMessageHandler.getString(packageName, key, parameters));
    }

    @Override
    public String getString(String packageName, String key, Class<?> resourceClass, String ... parameters) {
        return this.trimAltKey(this.defMessageHandler.getString(packageName, key, resourceClass, parameters));
    }

    private String trimAltKey(String value) {
        Matcher matcher = this.altKeyPattern.matcher((CharSequence)value);
        if (matcher.find()) {
            value = ((String)value).substring(0, matcher.start());
            if (matcher.group(1) != null) {
                value = (String)value + matcher.group(1);
            }
        }
        return value;
    }
}

