/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.environment;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.config.DescribedVariablesConfigFile;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.config.plugin.ConfigPlugin;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.projects.config.ProjectsConfig;
import org.apache.hop.projects.config.ProjectsConfigSingleton;
import org.apache.hop.projects.environment.LifecycleEnvironment;
import org.apache.hop.projects.project.Project;
import org.apache.hop.projects.project.ProjectConfig;
import org.apache.hop.projects.util.ProjectsUtil;
import picocli.CommandLine;

@ConfigPlugin(id="ManageEnvironmentsOptionPlugin", description="Allows command line editing of the lifecycle environments")
public class ManageEnvironmentsOptionPlugin
implements IConfigOptions {
    public static final String CONST_LIFECYCLE_ENVIRONMENT = "Lifecycle environment '";
    public static final String CONST_ENVIRONMENT = "Environment '";
    @CommandLine.Option(names={"-ec", "--environment-create"}, description={"Create a new project lifecycle environment. Also specify its name, purpose, the project name and the configuration files."})
    private boolean createEnvironment;
    @CommandLine.Option(names={"-e", "--environment"}, description={"The name of the lifecycle environment to manage"})
    private String environmentName;
    @CommandLine.Option(names={"-eu", "--environment-purpose"}, description={"The purpose of the environment: Development, Testing, Production, CI, ..."})
    private String environmentPurpose;
    @CommandLine.Option(names={"-ep", "--environment-project"}, description={"The project for the environment"})
    private String environmentProject;
    @CommandLine.Option(names={"-eg", "--environment-config-files"}, description={"A list of configuration files for this lifecycle environment, comma separated"}, split=",")
    private String[] environmentConfigFiles;
    @CommandLine.Option(names={"-em", "--environment-modify"}, description={"Modify a lifecycle environment"})
    private boolean modifyEnvironment;
    @CommandLine.Option(names={"-ed", "--environment-delete"}, description={"Delete a lifecycle environment"})
    private boolean deleteEnvironment;
    @CommandLine.Option(names={"-el", "--environments-list"}, description={"List the defined lifecycle environments"})
    private boolean listEnvironments;

    public boolean handleOption(ILogChannel log, IHasHopMetadataProvider hasHopMetadataProvider, IVariables variables) throws HopException {
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        try {
            boolean changed = false;
            if (this.createEnvironment) {
                this.createEnvironment(log, config, variables, hasHopMetadataProvider);
                changed = true;
            } else if (this.modifyEnvironment) {
                this.modifyEnvironment(log, config, variables, hasHopMetadataProvider);
                changed = true;
            } else if (this.deleteEnvironment) {
                this.deleteEnvironment(log, config, variables);
                changed = true;
            } else if (this.listEnvironments) {
                this.listEnvironments(log, config, variables);
                changed = true;
            }
            return changed;
        }
        catch (Exception e) {
            throw new HopException("Error handling project lifecycle environments configuration options", (Throwable)e);
        }
    }

    private void listEnvironments(ILogChannel log, ProjectsConfig config, IVariables variables) {
        log.logBasic("Lifecycle environments:");
        List<String> names = config.listEnvironmentNames();
        for (String name : names) {
            LifecycleEnvironment environment = config.findEnvironment(name);
            this.logEnvironmentDetails(log, environment);
        }
    }

    private void logEnvironmentDetails(ILogChannel log, LifecycleEnvironment environment) {
        log.logBasic("  " + environment.getName());
        log.logBasic("    Purpose: " + environment.getPurpose());
        log.logBasic("    Project name: " + environment.getProjectName());
        for (String configurationFile : environment.getConfigurationFiles()) {
            log.logBasic("      Config file: " + configurationFile);
        }
    }

    private void deleteEnvironment(ILogChannel log, ProjectsConfig config, IVariables variables) throws Exception {
        this.validateEnvironmentNameSpecified();
        LifecycleEnvironment environment = config.findEnvironment(this.environmentName);
        if (environment == null) {
            throw new HopException(CONST_LIFECYCLE_ENVIRONMENT + this.environmentName + "' doesn't exist, it can't be deleted");
        }
        config.removeEnvironment(this.environmentName);
        ProjectsConfigSingleton.saveConfig();
        log.logBasic(CONST_LIFECYCLE_ENVIRONMENT + this.environmentName + "' was deleted from Hop configuration file " + HopConfig.getInstance().getConfigFilename());
    }

    private void modifyEnvironment(ILogChannel log, ProjectsConfig config, IVariables variables, IHasHopMetadataProvider hasHopMetadataProvider) throws Exception {
        this.validateEnvironmentNameSpecified();
        LifecycleEnvironment environment = config.findEnvironment(this.environmentName);
        if (environment == null) {
            throw new HopException(CONST_ENVIRONMENT + this.environmentName + "' doesn't exist, it can't be modified");
        }
        if (this.updateEnvironmentDetails(environment)) {
            config.addEnvironment(environment);
            log.logBasic(CONST_LIFECYCLE_ENVIRONMENT + this.environmentName + "' was modified in Hop configuration file " + HopConfig.getInstance().getConfigFilename());
            this.logEnvironmentDetails(log, environment);
            ProjectsConfigSingleton.saveConfig();
        } else {
            log.logBasic(CONST_ENVIRONMENT + this.environmentName + "' was not modified.");
        }
        this.enableProject(log, environment, variables, hasHopMetadataProvider, config);
        this.validateConfigFiles(log, variables, environment);
    }

    private void createEnvironment(ILogChannel log, ProjectsConfig config, IVariables variables, IHasHopMetadataProvider hasHopMetadataProvider) throws Exception {
        this.validateEnvironmentNameSpecified();
        LifecycleEnvironment environment = config.findEnvironment(this.environmentName);
        log.logBasic("Creating environment '" + this.environmentName + "'");
        if (environment != null) {
            throw new HopException(CONST_ENVIRONMENT + this.environmentName + "' already exists.");
        }
        environment = new LifecycleEnvironment();
        environment.setName(this.environmentName);
        this.updateEnvironmentDetails(environment);
        config.addEnvironment(environment);
        ProjectsConfigSingleton.saveConfig();
        log.logBasic(CONST_ENVIRONMENT + this.environmentName + "' was created in Hop configuration file " + HopConfig.getInstance().getConfigFilename());
        this.enableProject(log, environment, variables, hasHopMetadataProvider, config);
        this.validateConfigFiles(log, variables, environment);
        this.logEnvironmentDetails(log, environment);
    }

    private void enableProject(ILogChannel log, LifecycleEnvironment environment, IVariables variables, IHasHopMetadataProvider hasHopMetadataProvider, ProjectsConfig config) throws HopException {
        ProjectConfig projectConfig = config.findProjectConfig(environment.getProjectName());
        if (projectConfig == null) {
            log.logBasic("Warning: referenced project '" + environment.getProjectName() + "' doesn't exist");
        } else {
            Project project = projectConfig.loadProject(variables);
            ProjectsUtil.enableProject(log, environment.getProjectName(), project, variables, environment.getConfigurationFiles(), this.environmentName, hasHopMetadataProvider);
        }
    }

    private void validateConfigFiles(ILogChannel log, IVariables variables, LifecycleEnvironment environment) throws Exception {
        if (environment == null || this.environmentConfigFiles == null) {
            return;
        }
        for (String environmentConfigFilename : environment.getConfigurationFiles()) {
            String realEnvConfFilename = variables.resolve(environmentConfigFilename);
            DescribedVariablesConfigFile variablesConfigFile = new DescribedVariablesConfigFile(realEnvConfFilename);
            if (!HopVfs.getFileObject((String)realEnvConfFilename).exists()) {
                variablesConfigFile.saveToFile();
                log.logBasic("Created empty environment configuration file : " + realEnvConfFilename);
                continue;
            }
            log.logBasic("Found existing environment configuration file: " + realEnvConfFilename);
        }
    }

    private boolean updateEnvironmentDetails(LifecycleEnvironment environment) {
        boolean changed = false;
        if (StringUtils.isNotEmpty((String)this.environmentPurpose)) {
            environment.setPurpose(this.environmentPurpose);
            changed = true;
        }
        if (StringUtils.isNotEmpty((String)this.environmentProject)) {
            environment.setProjectName(this.environmentProject);
            changed = true;
        }
        if (this.environmentConfigFiles != null && this.environmentConfigFiles.length > 0) {
            environment.getConfigurationFiles().clear();
            environment.getConfigurationFiles().addAll(Arrays.asList(this.environmentConfigFiles));
            changed = true;
        }
        return changed;
    }

    private void validateEnvironmentNameSpecified() throws Exception {
        if (StringUtil.isEmpty((String)this.environmentName)) {
            throw new HopException("Please specify the name of the environment to create");
        }
    }

    public boolean isCreateEnvironment() {
        return this.createEnvironment;
    }

    public void setCreateEnvironment(boolean createEnvironment) {
        this.createEnvironment = createEnvironment;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public String getEnvironmentPurpose() {
        return this.environmentPurpose;
    }

    public void setEnvironmentPurpose(String environmentPurpose) {
        this.environmentPurpose = environmentPurpose;
    }

    public String getEnvironmentProject() {
        return this.environmentProject;
    }

    public void setEnvironmentProject(String environmentProject) {
        this.environmentProject = environmentProject;
    }

    public String[] getEnvironmentConfigFiles() {
        return this.environmentConfigFiles;
    }

    public void setEnvironmentConfigFiles(String[] environmentConfigFiles) {
        this.environmentConfigFiles = environmentConfigFiles;
    }

    public boolean isModifyEnvironment() {
        return this.modifyEnvironment;
    }

    public void setModifyEnvironment(boolean modifyEnvironment) {
        this.modifyEnvironment = modifyEnvironment;
    }

    public boolean isDeleteEnvironment() {
        return this.deleteEnvironment;
    }

    public void setDeleteEnvironment(boolean deleteEnvironment) {
        this.deleteEnvironment = deleteEnvironment;
    }

    public boolean isListEnvironments() {
        return this.listEnvironments;
    }

    public void setListEnvironments(boolean listEnvironments) {
        this.listEnvironments = listEnvironments;
    }
}

