/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400PackedDecimal;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import com.ibm.as400.access.SQLDataFactory;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLDecimal
extends SQLDataBase {
    static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private static final BigDecimal default_ = BigDecimal.valueOf(0L);
    private static final BigDecimal BYTE_MAX_VALUE = BigDecimal.valueOf(127L);
    private static final BigDecimal BYTE_MIN_VALUE = BigDecimal.valueOf(-128L);
    private static final BigDecimal SHORT_MAX_VALUE = BigDecimal.valueOf(32767L);
    private static final BigDecimal SHORT_MIN_VALUE = BigDecimal.valueOf(-32768L);
    private static final BigDecimal INTEGER_MAX_VALUE = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal INTEGER_MIN_VALUE = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal LONG_MAX_VALUE = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal LONG_MIN_VALUE = BigDecimal.valueOf(Long.MIN_VALUE);
    static final BigDecimal FLOAT_MAX_VALUE = new BigDecimal(3.4028234663852886E38);
    static final BigDecimal FLOAT_MIN_VALUE = new BigDecimal(1.4E-45f);
    static final BigDecimal DOUBLE_MAX_VALUE = new BigDecimal(Double.MAX_VALUE);
    static final BigDecimal DOUBLE_MIN_VALUE = new BigDecimal(Double.MIN_VALUE);
    private int precision_;
    private int scale_;
    private AS400PackedDecimal typeConverter_;
    private BigDecimal value_;
    private JDProperties properties_;
    private int vrm_;

    SQLDecimal(int precision, int scale, SQLConversionSettings settings, int vrm, JDProperties properties) {
        super(settings);
        this.precision_ = precision;
        this.scale_ = scale;
        this.typeConverter_ = new AS400PackedDecimal(this.precision_, this.scale_);
        this.value_ = default_;
        this.vrm_ = vrm;
        this.properties_ = properties;
    }

    @Override
    public Object clone() {
        return new SQLDecimal(this.precision_, this.scale_, this.settings_, this.vrm_, this.properties_);
    }

    @Override
    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable ccisdConverter, boolean ignoreConversionErrors) throws SQLException {
        block2: {
            try {
                this.value_ = (BigDecimal)this.typeConverter_.toObject(rawBytes, offset);
            }
            catch (NumberFormatException nfe) {
                if (ignoreConversionErrors) break block2;
                JDError.throwSQLException((Object)this, "HY000", nfe);
            }
        }
    }

    @Override
    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        try {
            this.typeConverter_.toBytes(this.value_, rawBytes, offset);
        }
        catch (ExtendedIllegalArgumentException e) {
            JDError.throwSQLException((Object)this, "07006", e);
        }
    }

    @Override
    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        String value;
        BigDecimal bigDecimal = null;
        if (object instanceof String) {
            try {
                value = SQLDataFactory.convertScientificNotation((String)object, this.settings_);
                if (scale >= 0) {
                    value = SQLDataFactory.truncateScale(value, scale);
                }
                bigDecimal = new BigDecimal(value);
            }
            catch (NumberFormatException e) {
                JDError.throwSQLException((Object)this, "07006", e);
                return;
            }
            catch (StringIndexOutOfBoundsException e) {
                JDError.throwSQLException((Object)this, "07006");
                return;
            }
        } else if (object instanceof Number) {
            value = SQLDataFactory.convertScientificNotation(object.toString(), this.settings_);
            if (scale >= 0) {
                value = SQLDataFactory.truncateScale(value, scale);
            }
            bigDecimal = new BigDecimal(value);
        } else if (object instanceof Boolean) {
            bigDecimal = (Boolean)object == true ? BigDecimal.valueOf(1L) : BigDecimal.valueOf(0L);
        } else {
            if (JDTrace.isTraceOn()) {
                if (object == null) {
                    JDTrace.logInformation(this, "Unable to assign null object");
                } else {
                    JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                }
            }
            JDError.throwSQLException((Object)this, "07006");
            return;
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        int otherScale = bigDecimal.scale();
        if (otherScale > this.scale_) {
            this.truncated_ += otherScale - this.scale_;
        }
        this.value_ = bigDecimal.setScale(this.scale_, 1);
        int otherPrecision = SQLDataFactory.getDecimalPrecision(this.value_);
        if (this.precision_ == this.scale_ && this.value_.intValue() == 0) {
            --otherPrecision;
        }
        if (otherPrecision > this.precision_) {
            int digits = otherPrecision - this.precision_;
            this.truncated_ += digits;
            this.value_ = this.value_.doubleValue() > 0.0 ? SQLDataFactory.getMaximumBigDecimal(this.precision_, this.scale_) : SQLDataFactory.getMinimumBigDecimal(this.precision_, this.scale_);
            this.outOfBounds_ = true;
        } else {
            this.truncated_ = 0;
            this.outOfBounds_ = false;
        }
    }

    @Override
    public int getSQLType() {
        return 13;
    }

    @Override
    public String getCreateParameters() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(AS400JDBCDriver.getResource("PRECISION", null));
        buffer.append(",");
        buffer.append(AS400JDBCDriver.getResource("SCALE", null));
        return buffer.toString();
    }

    @Override
    public int getDisplaySize() {
        return this.precision_ + 2;
    }

    @Override
    public String getJavaClassName() {
        return "java.math.BigDecimal";
    }

    @Override
    public String getLiteralPrefix() {
        return null;
    }

    @Override
    public String getLiteralSuffix() {
        return null;
    }

    @Override
    public String getLocalName() {
        return "DECIMAL";
    }

    @Override
    public int getMaximumPrecision() {
        if (this.vrm_ >= JDUtilities.vrm530) {
            return this.properties_.getInt(53);
        }
        return 31;
    }

    @Override
    public int getMaximumScale() {
        if (this.vrm_ >= JDUtilities.vrm530) {
            return this.properties_.getInt(54);
        }
        return 31;
    }

    @Override
    public int getMinimumScale() {
        return 0;
    }

    @Override
    public int getNativeType() {
        return 484;
    }

    @Override
    public int getPrecision() {
        return this.precision_;
    }

    @Override
    public int getRadix() {
        return 10;
    }

    @Override
    public int getScale() {
        return this.scale_;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public String getTypeName() {
        return "DECIMAL";
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public boolean isText() {
        return false;
    }

    @Override
    public int getActualSize() {
        return this.precision_;
    }

    @Override
    public int getTruncated() {
        return this.truncated_;
    }

    @Override
    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    @Override
    public BigDecimal getBigDecimal(int scale) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (scale >= 0) {
            if (scale >= this.value_.scale()) {
                return this.value_.setScale(scale);
            }
            this.truncated_ = this.value_.scale() - scale;
            return this.value_.setScale(scale, 4);
        }
        return this.value_;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Blob getBlob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public boolean getBoolean() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_.compareTo(BigDecimal.valueOf(0L)) != 0;
    }

    @Override
    public byte getByte() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.value_.compareTo(BYTE_MAX_VALUE) > 0 || this.value_.compareTo(BYTE_MIN_VALUE) < 0) {
            int length = this.value_.toBigInteger().toByteArray().length;
            this.truncated_ = length - 1;
            this.outOfBounds_ = true;
        }
        return this.value_.byteValue();
    }

    @Override
    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public double getDouble() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        double d = this.value_.doubleValue();
        if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            int length = this.value_.toBigInteger().toByteArray().length;
            this.truncated_ = length - 8;
            this.outOfBounds_ = true;
        }
        return d;
    }

    @Override
    public float getFloat() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        float f = this.value_.floatValue();
        if (f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY) {
            int length = this.value_.toBigInteger().toByteArray().length;
            this.truncated_ = length - 4;
            this.outOfBounds_ = true;
        }
        return f;
    }

    @Override
    public int getInt() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.value_.compareTo(INTEGER_MAX_VALUE) > 0 || this.value_.compareTo(INTEGER_MIN_VALUE) < 0) {
            int length = this.value_.toBigInteger().toByteArray().length;
            this.truncated_ = length - 4;
            this.outOfBounds_ = true;
        }
        return this.value_.intValue();
    }

    @Override
    public long getLong() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.value_.compareTo(LONG_MAX_VALUE) > 0 || this.value_.compareTo(LONG_MIN_VALUE) < 0) {
            int length = this.value_.toBigInteger().toByteArray().length;
            this.truncated_ = length - 8;
            this.outOfBounds_ = true;
        }
        return this.value_.longValue();
    }

    @Override
    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    @Override
    public short getShort() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.value_.compareTo(SHORT_MAX_VALUE) > 0 || this.value_.compareTo(SHORT_MIN_VALUE) < 0) {
            int length = this.value_.toBigInteger().toByteArray().length;
            this.truncated_ = length - 2;
            this.outOfBounds_ = true;
        }
        return this.value_.shortValue();
    }

    @Override
    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        String stringRep = this.value_.toPlainString();
        int decimal = stringRep.indexOf(46);
        if (decimal == -1) {
            return stringRep;
        }
        return stringRep.substring(0, decimal) + this.settings_.getDecimalSeparator() + stringRep.substring(decimal + 1);
    }

    @Override
    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        String stringRep = this.value_.toString();
        int decimal = stringRep.indexOf(46);
        if (decimal == -1) {
            return stringRep;
        }
        return stringRep.substring(0, decimal) + this.settings_.getDecimalSeparator() + stringRep.substring(decimal + 1);
    }

    @Override
    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public void saveValue() {
        this.savedValue_ = this.value_;
    }
}

