/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ConnectionEvent;
import com.ibm.as400.access.ConnectionListener;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.AS400Credential;

class RefreshAgent
extends Thread
implements ConnectionListener {
    private int refreshInterval_;
    private int maxRefreshes_ = 0;
    private AS400Credential target_ = null;
    private Exception failure_ = null;
    private boolean stop_ = false;

    RefreshAgent() {
        this.setDaemon(true);
        this.setPriority(10);
    }

    RefreshAgent(AS400Credential target, int refreshInterval, int maxRefreshes) {
        this();
        this.setTarget(target);
        this.setRefreshInterval(refreshInterval);
        this.setMaxRefreshes(maxRefreshes);
        String className = target.getClass().getName();
        int dotIndex = className.lastIndexOf(46);
        if (dotIndex >= 0) {
            className = className.substring(dotIndex + 1);
        }
        try {
            this.setName("Refresh" + className);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void connected(ConnectionEvent event) {
    }

    @Override
    public void disconnected(ConnectionEvent event) {
        try {
            AS400 sys = (AS400)event.getSource();
            if (this.isAlive() && !sys.isConnected()) {
                this.stopRefresh();
                if (Trace.isTraceOn()) {
                    Trace.log(3, new StringBuffer("RefreshAgent stopped after system disconnect >> ").append(this.target_.toString()).toString());
                }
            }
        }
        catch (Exception e) {
            Trace.log(2, "RefreshAgent not stopped after system disconnect >> " + this.target_.toString(), (Throwable)e);
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.isAlive()) {
                this.stopRefresh();
            }
        }
        catch (Exception e) {
            Trace.log(2, "RefreshAgent not stopped on finalize >> " + this.target_.toString(), (Throwable)e);
        }
        super.finalize();
    }

    public Throwable getFailure() {
        return this.failure_;
    }

    @Override
    public void run() {
        this.stop_ = false;
        if (Trace.isTraceOn()) {
            Trace.log(3, new StringBuffer("RefreshAgent starting with maximum attempts ").append(this.maxRefreshes_).append(" and refresh interval ").append(this.refreshInterval_).append(" >> ").append(this.target_.toString()).toString());
        }
        this.validatePropertySet("target", this.target_);
        AS400 sys = this.target_.getSystem();
        sys.addConnectionListener(this);
        this.failure_ = null;
        int i = 0;
        while (!(this.stop_ || this.failure_ != null || this.maxRefreshes_ >= 0 && i++ >= this.maxRefreshes_)) {
            try {
                this.target_.refresh();
                if (this.maxRefreshes_ >= 0 && i >= this.maxRefreshes_) continue;
                RefreshAgent.sleep(this.refreshInterval_ * 1000);
            }
            catch (InterruptedException ie) {
                if (this.stop_) {
                    Trace.log(1, "RefreshAgent stopped on interrupt >> " + this.target_.toString());
                    continue;
                }
                Trace.log(2, "RefreshAgent interrupted >> " + this.target_.toString(), (Throwable)ie);
                this.failure_ = ie;
            }
            catch (Exception e) {
                Trace.log(2, "RefreshAgent failed >> " + this.target_.toString(), (Throwable)e);
                this.failure_ = e;
            }
        }
        sys.removeConnectionListener(this);
    }

    void setMaxRefreshes(int max) {
        this.validatePropertyChange("maxRefreshes");
        this.maxRefreshes_ = max;
    }

    void setRefreshInterval(int seconds) {
        this.validatePropertyChange("refreshInterval");
        this.refreshInterval_ = seconds;
    }

    void setTarget(AS400Credential c) {
        this.validatePropertyChange("target");
        this.target_ = c;
    }

    public void stopRefresh() {
        this.stop_ = true;
        if (this.isAlive()) {
            this.interrupt();
        }
    }

    void validatePropertyChange(String propertyName) {
        if (this.isAlive()) {
            Trace.log(2, "Property " + propertyName + " not changed (active=true).");
            throw new ExtendedIllegalStateException(propertyName, 5);
        }
    }

    void validatePropertySet(String propertyName, Object value) {
        if (value == null) {
            Trace.log(2, "Required property " + propertyName + " not set.");
            throw new ExtendedIllegalStateException(4);
        }
    }
}

