/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teampolicies.TeamMemberPolicies;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class TeamGetInfoResult {
    @Nonnull
    protected final String name;
    @Nonnull
    protected final String teamId;
    protected final long numLicensedUsers;
    protected final long numProvisionedUsers;
    protected final long numUsedLicenses;
    @Nonnull
    protected final TeamMemberPolicies policies;

    public TeamGetInfoResult(@Nonnull String name, @Nonnull String teamId, long numLicensedUsers, long numProvisionedUsers, @Nonnull TeamMemberPolicies policies, long numUsedLicenses) {
        if (name == null) {
            throw new IllegalArgumentException("Required value for 'name' is null");
        }
        this.name = name;
        if (teamId == null) {
            throw new IllegalArgumentException("Required value for 'teamId' is null");
        }
        this.teamId = teamId;
        this.numLicensedUsers = numLicensedUsers;
        this.numProvisionedUsers = numProvisionedUsers;
        this.numUsedLicenses = numUsedLicenses;
        if (policies == null) {
            throw new IllegalArgumentException("Required value for 'policies' is null");
        }
        this.policies = policies;
    }

    public TeamGetInfoResult(@Nonnull String name, @Nonnull String teamId, long numLicensedUsers, long numProvisionedUsers, @Nonnull TeamMemberPolicies policies) {
        this(name, teamId, numLicensedUsers, numProvisionedUsers, policies, 0L);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getTeamId() {
        return this.teamId;
    }

    public long getNumLicensedUsers() {
        return this.numLicensedUsers;
    }

    public long getNumProvisionedUsers() {
        return this.numProvisionedUsers;
    }

    @Nonnull
    public TeamMemberPolicies getPolicies() {
        return this.policies;
    }

    public long getNumUsedLicenses() {
        return this.numUsedLicenses;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.name, this.teamId, this.numLicensedUsers, this.numProvisionedUsers, this.numUsedLicenses, this.policies});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            TeamGetInfoResult other = (TeamGetInfoResult)obj;
            return !(this.name != other.name && !this.name.equals(other.name) || this.teamId != other.teamId && !this.teamId.equals(other.teamId) || this.numLicensedUsers != other.numLicensedUsers || this.numProvisionedUsers != other.numProvisionedUsers || this.policies != other.policies && !this.policies.equals(other.policies) || this.numUsedLicenses != other.numUsedLicenses);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<TeamGetInfoResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TeamGetInfoResult value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("name");
            StoneSerializers.string().serialize(value.name, g);
            g.writeFieldName("team_id");
            StoneSerializers.string().serialize(value.teamId, g);
            g.writeFieldName("num_licensed_users");
            StoneSerializers.uInt32().serialize((Long)value.numLicensedUsers, g);
            g.writeFieldName("num_provisioned_users");
            StoneSerializers.uInt32().serialize((Long)value.numProvisionedUsers, g);
            g.writeFieldName("policies");
            TeamMemberPolicies.Serializer.INSTANCE.serialize(value.policies, g);
            g.writeFieldName("num_used_licenses");
            StoneSerializers.uInt32().serialize((Long)value.numUsedLicenses, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public TeamGetInfoResult deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Long f_numUsedLicenses;
            TeamMemberPolicies f_policies;
            Long f_numProvisionedUsers;
            Long f_numLicensedUsers;
            String f_teamId;
            String f_name;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_name = null;
                f_teamId = null;
                f_numLicensedUsers = null;
                f_numProvisionedUsers = null;
                f_policies = null;
                f_numUsedLicenses = 0L;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("name".equals(field)) {
                        f_name = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("team_id".equals(field)) {
                        f_teamId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("num_licensed_users".equals(field)) {
                        f_numLicensedUsers = StoneSerializers.uInt32().deserialize(p);
                        continue;
                    }
                    if ("num_provisioned_users".equals(field)) {
                        f_numProvisionedUsers = StoneSerializers.uInt32().deserialize(p);
                        continue;
                    }
                    if ("policies".equals(field)) {
                        f_policies = (TeamMemberPolicies)TeamMemberPolicies.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("num_used_licenses".equals(field)) {
                        f_numUsedLicenses = StoneSerializers.uInt32().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
                if (f_teamId == null) {
                    throw new JsonParseException(p, "Required field \"team_id\" missing.");
                }
                if (f_numLicensedUsers == null) {
                    throw new JsonParseException(p, "Required field \"num_licensed_users\" missing.");
                }
                if (f_numProvisionedUsers == null) {
                    throw new JsonParseException(p, "Required field \"num_provisioned_users\" missing.");
                }
                if (f_policies == null) {
                    throw new JsonParseException(p, "Required field \"policies\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            TeamGetInfoResult value = new TeamGetInfoResult(f_name, f_teamId, f_numLicensedUsers, f_numProvisionedUsers, f_policies, f_numUsedLicenses);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

