/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.security.token;

import java.util.Optional;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.configuration.Configuration;

@Experimental
public interface DelegationTokenProvider {
    public static final String CONFIG_PREFIX = "security.delegation.token.provider";

    public String serviceName();

    default public String serviceConfigPrefix() {
        return String.format("%s.%s", CONFIG_PREFIX, this.serviceName());
    }

    public void init(Configuration var1) throws Exception;

    public boolean delegationTokensRequired() throws Exception;

    public ObtainedDelegationTokens obtainDelegationTokens() throws Exception;

    public static class ObtainedDelegationTokens {
        private byte[] tokens;
        private Optional<Long> validUntil;

        public ObtainedDelegationTokens(byte[] tokens, Optional<Long> validUntil) {
            this.tokens = tokens;
            this.validUntil = validUntil;
        }

        public byte[] getTokens() {
            return this.tokens;
        }

        public Optional<Long> getValidUntil() {
            return this.validUntil;
        }
    }
}

