/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.xml.xmljoin;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.Stream;
import org.apache.hop.pipeline.transform.stream.StreamIcon;
import org.apache.hop.pipeline.transforms.xml.xmljoin.XmlJoin;
import org.apache.hop.pipeline.transforms.xml.xmljoin.XmlJoinData;

@Transform(id="XMLJoin", image="XJN.svg", name="i18n::XmlJoin.name", description="i18n::XmlJoin.description", categoryDescription="i18n::XmlJoin.category", keywords={"i18n::XmlJoinMeta.keyword"}, documentationUrl="/pipeline/transforms/xmljoin.html")
public class XmlJoinMeta
extends BaseTransformMeta<XmlJoin, XmlJoinData> {
    private static final Class<?> PKG = XmlJoinMeta.class;
    @HopMetadataProperty(injectionKey="COMPLEX_JOIN")
    private boolean complexJoin;
    @HopMetadataProperty(injectionKey="TARGET_XML_TRANSFORM")
    private String targetXmlTransform;
    @HopMetadataProperty(injectionKey="TARGET_XML_FIELD")
    private String targetXmlField;
    @HopMetadataProperty(injectionKey="SOURCE_XML_FIELD")
    private String sourceXmlField;
    @HopMetadataProperty(injectionKey="VALUE_XML_FIELD")
    private String valueXmlField;
    @HopMetadataProperty(injectionKey="TARGET_XPATH")
    private String targetXPath;
    @HopMetadataProperty(injectionKey="SOURCE_XML_TRANSFORM")
    private String sourceXmlTransform;
    @HopMetadataProperty(injectionKey="JOIN_COMPARE_FIELD")
    private String joinCompareField;
    @HopMetadataProperty(injectionKey="ENCODING")
    private String encoding;
    @HopMetadataProperty(injectionKey="OMIT_XML_HEADER")
    private boolean omitXmlHeader;
    @HopMetadataProperty(injectionKey="OMIT_NULL_VALUES")
    private boolean omitNullValues;

    public Object clone() {
        XmlJoinMeta retval = (XmlJoinMeta)((Object)super.clone());
        return retval;
    }

    public void setDefault() {
        this.encoding = "UTF-8";
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaString v = new ValueMetaString(variables.resolve(this.getValueXmlField()));
        v.setOrigin(name);
        try {
            IRowMeta sourceRowMeta;
            List<String> targetFieldNames = null;
            IRowMeta targetRowMeta = info[0];
            if (targetRowMeta != null) {
                targetFieldNames = Arrays.asList(targetRowMeta.getFieldNames());
            }
            if ((sourceRowMeta = info[1]) != null) {
                for (String fieldName : sourceRowMeta.getFieldNames()) {
                    if (targetFieldNames != null && targetFieldNames.contains(fieldName)) continue;
                    row.removeValueMeta(fieldName);
                }
            }
        }
        catch (HopValueException hopValueException) {
            // empty catch block
        }
        row.addValueMeta((IValueMeta)v);
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (this.targetXmlTransform == null || this.targetXmlTransform.length() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.TargetXMLTransformNotSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.TargetXMLTransformSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.targetXmlField == null || this.targetXmlField.length() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.TargetXMLFieldNotSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.TargetXMLFieldSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.sourceXmlTransform == null || this.sourceXmlTransform.length() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.SourceXMLTransformNotSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.SourceXMLTransformSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.sourceXmlField == null || this.sourceXmlField.length() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.SourceXMLFieldNotSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.SourceXMLFieldSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.valueXmlField == null || this.valueXmlField.length() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.ResultFieldNotSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.ResultFieldSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.targetXPath == null || this.targetXPath.length() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.TargetXPathNotSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.TargetXPathSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            boolean targetTransformFound = false;
            boolean sourceTransformFound = false;
            for (int i = 0; i < input.length; ++i) {
                if (this.targetXmlTransform != null && this.targetXmlTransform.equals(input[i])) {
                    targetTransformFound = true;
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.TargetXMLTransformFound", (String[])new String[]{this.targetXmlTransform}), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                if (this.sourceXmlTransform == null || !this.sourceXmlTransform.equals(input[i])) continue;
                sourceTransformFound = true;
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.SourceXMLTransformFound", (String[])new String[]{this.sourceXmlTransform}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            if (!targetTransformFound) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.TargetXMLTransformNotFound", (String[])new String[]{this.targetXmlTransform}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            if (!sourceTransformFound) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.SourceXMLTransformNotFound", (String[])new String[]{this.sourceXmlTransform}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XmlJoin.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public ITransformIOMeta getTransformIOMeta() {
        ITransformIOMeta ioMeta = super.getTransformIOMeta(false);
        if (ioMeta == null) {
            ioMeta = new TransformIOMeta(true, true, false, false, false, false);
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"XmlJoinMeta.InfoStream.TargetInputStream.Description", (String[])new String[0]), StreamIcon.INFO, null));
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"XmlJoinMeta.InfoStream.SourceInputStream.Description", (String[])new String[0]), StreamIcon.INFO, null));
            this.setTransformIOMeta(ioMeta);
        }
        return ioMeta;
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        List infoStreams = this.getTransformIOMeta().getInfoStreams();
        for (IStream stream : infoStreams) {
            stream.setTransformMeta(TransformMeta.findTransform(transforms, (String)stream.getSubject()));
        }
    }

    public void resetTransformIoMeta() {
    }

    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    @Generated
    public boolean isComplexJoin() {
        return this.complexJoin;
    }

    @Generated
    public String getTargetXmlTransform() {
        return this.targetXmlTransform;
    }

    @Generated
    public String getTargetXmlField() {
        return this.targetXmlField;
    }

    @Generated
    public String getSourceXmlField() {
        return this.sourceXmlField;
    }

    @Generated
    public String getValueXmlField() {
        return this.valueXmlField;
    }

    @Generated
    public String getTargetXPath() {
        return this.targetXPath;
    }

    @Generated
    public String getSourceXmlTransform() {
        return this.sourceXmlTransform;
    }

    @Generated
    public String getJoinCompareField() {
        return this.joinCompareField;
    }

    @Generated
    public String getEncoding() {
        return this.encoding;
    }

    @Generated
    public boolean isOmitXmlHeader() {
        return this.omitXmlHeader;
    }

    @Generated
    public boolean isOmitNullValues() {
        return this.omitNullValues;
    }

    @Generated
    public void setComplexJoin(boolean complexJoin) {
        this.complexJoin = complexJoin;
    }

    @Generated
    public void setTargetXmlTransform(String targetXmlTransform) {
        this.targetXmlTransform = targetXmlTransform;
    }

    @Generated
    public void setTargetXmlField(String targetXmlField) {
        this.targetXmlField = targetXmlField;
    }

    @Generated
    public void setSourceXmlField(String sourceXmlField) {
        this.sourceXmlField = sourceXmlField;
    }

    @Generated
    public void setValueXmlField(String valueXmlField) {
        this.valueXmlField = valueXmlField;
    }

    @Generated
    public void setTargetXPath(String targetXPath) {
        this.targetXPath = targetXPath;
    }

    @Generated
    public void setSourceXmlTransform(String sourceXmlTransform) {
        this.sourceXmlTransform = sourceXmlTransform;
    }

    @Generated
    public void setJoinCompareField(String joinCompareField) {
        this.joinCompareField = joinCompareField;
    }

    @Generated
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Generated
    public void setOmitXmlHeader(boolean omitXmlHeader) {
        this.omitXmlHeader = omitXmlHeader;
    }

    @Generated
    public void setOmitNullValues(boolean omitNullValues) {
        this.omitNullValues = omitNullValues;
    }
}

