/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util;

import java.text.ParseException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.core5.util.TimeValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestTimeValue {
    TestTimeValue() {
    }

    private void checkToDays(long value, TimeUnit timeUnit) {
        Assertions.assertEquals((long)timeUnit.toDays(value), (long)TimeValue.of((long)value, (TimeUnit)timeUnit).toDays());
    }

    private void checkToHours(long value, TimeUnit timeUnit) {
        Assertions.assertEquals((long)timeUnit.toHours(value), (long)TimeValue.of((long)value, (TimeUnit)timeUnit).toHours());
    }

    private void checkToMicroseconds(long value, TimeUnit timeUnit) {
        Assertions.assertEquals((long)timeUnit.toMicros(value), (long)TimeValue.of((long)value, (TimeUnit)timeUnit).toMicroseconds());
    }

    private void checkToMilliseconds(long value, TimeUnit timeUnit) {
        Assertions.assertEquals((long)timeUnit.toMillis(value), (long)TimeValue.of((long)value, (TimeUnit)timeUnit).toMilliseconds());
    }

    private void checkToMinutes(long value, TimeUnit timeUnit) {
        Assertions.assertEquals((long)timeUnit.toMinutes(value), (long)TimeValue.of((long)value, (TimeUnit)timeUnit).toMinutes());
    }

    private void checkToNanoseconds(long value, TimeUnit timeUnit) {
        Assertions.assertEquals((long)timeUnit.toNanos(value), (long)TimeValue.of((long)value, (TimeUnit)timeUnit).toNanoseconds());
    }

    private void checkToSeconds(long value, TimeUnit timeUnit) {
        Assertions.assertEquals((long)timeUnit.toSeconds(value), (long)TimeValue.of((long)value, (TimeUnit)timeUnit).toSeconds());
    }

    private void test(long value) {
        for (TimeUnit timeUnit : TimeUnit.values()) {
            this.checkToDays(value, timeUnit);
            this.checkToHours(value, timeUnit);
            this.checkToMinutes(value, timeUnit);
            this.checkToSeconds(value, timeUnit);
            this.checkToMilliseconds(value, timeUnit);
            this.checkToMicroseconds(value, timeUnit);
            this.checkToNanoseconds(value, timeUnit);
        }
    }

    @Test
    void test0() {
        this.test(0L);
    }

    @Test
    void test1() {
        this.test(1L);
    }

    @Test
    void testConvert() {
        Assertions.assertEquals((long)0L, (long)TimeValue.ofMilliseconds((long)0L).convert(TimeUnit.DAYS));
        Assertions.assertEquals((long)1000L, (long)TimeValue.ofSeconds((long)1L).convert(TimeUnit.MILLISECONDS));
    }

    @Test
    void testDivide() {
        Assertions.assertEquals((long)0L, (long)TimeValue.ofMilliseconds((long)0L).divide(2L).toDays());
        Assertions.assertEquals((long)0L, (long)TimeValue.ofMilliseconds((long)0L).divide(2L).toHours());
        Assertions.assertEquals((long)0L, (long)TimeValue.ofMilliseconds((long)0L).divide(2L).toMicroseconds());
        Assertions.assertEquals((long)0L, (long)TimeValue.ofMilliseconds((long)0L).divide(2L).toMilliseconds());
        Assertions.assertEquals((long)0L, (long)TimeValue.ofMilliseconds((long)0L).divide(2L).toMinutes());
        Assertions.assertEquals((long)0L, (long)TimeValue.ofMilliseconds((long)0L).divide(2L).toNanoseconds());
        Assertions.assertEquals((long)0L, (long)TimeValue.ofMilliseconds((long)0L).divide(2L).toSeconds());
        Assertions.assertEquals((int)0, (int)TimeValue.ofMilliseconds((long)0L).divide(2L).toMillisecondsIntBound());
        Assertions.assertEquals((int)0, (int)TimeValue.ofMilliseconds((long)0L).divide(2L).toSecondsIntBound());
        Assertions.assertEquals((long)50L, (long)TimeValue.ofMilliseconds((long)100L).divide(2L).toMilliseconds());
        Assertions.assertEquals((long)0L, (long)TimeValue.ofMinutes((long)1L).divide(2L).toSeconds());
        Assertions.assertEquals((long)30L, (long)TimeValue.ofMinutes((long)1L).divide(2L, TimeUnit.SECONDS).toSeconds());
        Assertions.assertEquals((long)30000L, (long)TimeValue.ofMinutes((long)1L).divide(2L, TimeUnit.MILLISECONDS).toMilliseconds());
    }

    @Test
    void testDivideBy0() {
        Assertions.assertThrows(ArithmeticException.class, () -> TimeValue.ofMilliseconds((long)0L).divide(0L));
    }

    private void testFactory(TimeUnit timeUnit) {
        Assertions.assertEquals((Object)((Object)timeUnit), (Object)((Object)TimeValue.of((long)1L, (TimeUnit)timeUnit).getTimeUnit()));
        Duration duration = Duration.of(1L, TimeValue.toChronoUnit((TimeUnit)timeUnit));
        this.assertConvertion(duration);
    }

    @Test
    void testFactoryForDays() {
        this.testFactory(TimeUnit.DAYS);
    }

    @Test
    void testFactoryForDuration() {
        this.assertConvertion(Duration.ZERO);
        this.assertConvertion(Duration.ofDays(1L));
        this.assertConvertion(Duration.ofHours(1L));
        this.assertConvertion(Duration.ofMillis(1L));
        this.assertConvertion(Duration.ofNanos(1L));
        this.assertConvertion(Duration.ofSeconds(1L));
        this.assertConvertion(Duration.ofSeconds(1L, 1L));
    }

    private void assertConvertion(Duration duration) {
        Assertions.assertEquals((Object)duration, (Object)TimeValue.of((Duration)duration).toDuration());
    }

    @Test
    void testFactoryForHours() {
        this.testFactory(TimeUnit.HOURS);
    }

    @Test
    void testFactoryForMicroseconds() {
        this.testFactory(TimeUnit.MICROSECONDS);
    }

    @Test
    void testFactoryForMilliseconds() {
        this.testFactory(TimeUnit.MILLISECONDS);
    }

    @Test
    void testFactoryForMinutes() {
        this.testFactory(TimeUnit.MINUTES);
    }

    @Test
    void testFactoryForNanoseconds() {
        this.testFactory(TimeUnit.NANOSECONDS);
    }

    @Test
    void testFactoryForSeconds() {
        this.testFactory(TimeUnit.SECONDS);
    }

    @Test
    void testMin() {
        TimeValue nanos1 = TimeValue.ofNanoseconds((long)1L);
        TimeValue micros1 = TimeValue.ofMicroseconds((long)1L);
        TimeValue millis1 = TimeValue.ofMilliseconds((long)1L);
        TimeValue seconds1 = TimeValue.ofSeconds((long)1L);
        TimeValue minutes1 = TimeValue.ofMinutes((long)1L);
        TimeValue hours1 = TimeValue.ofHours((long)1L);
        TimeValue days1 = TimeValue.ofDays((long)1L);
        Assertions.assertEquals((Object)TimeValue.ZERO_MILLISECONDS, (Object)TimeValue.ZERO_MILLISECONDS.min(nanos1));
        Assertions.assertEquals((Object)TimeValue.ZERO_MILLISECONDS, (Object)TimeValue.ZERO_MILLISECONDS.min(micros1));
        Assertions.assertEquals((Object)TimeValue.ZERO_MILLISECONDS, (Object)TimeValue.ZERO_MILLISECONDS.min(millis1));
        Assertions.assertEquals((Object)TimeValue.ZERO_MILLISECONDS, (Object)TimeValue.ZERO_MILLISECONDS.min(seconds1));
        Assertions.assertEquals((Object)TimeValue.ZERO_MILLISECONDS, (Object)TimeValue.ZERO_MILLISECONDS.min(minutes1));
        Assertions.assertEquals((Object)TimeValue.ZERO_MILLISECONDS, (Object)TimeValue.ZERO_MILLISECONDS.min(hours1));
        Assertions.assertEquals((Object)TimeValue.ZERO_MILLISECONDS, (Object)TimeValue.ZERO_MILLISECONDS.min(days1));
        Assertions.assertEquals((Object)nanos1, (Object)nanos1.min(nanos1));
        Assertions.assertEquals((Object)nanos1, (Object)nanos1.min(micros1));
        Assertions.assertEquals((Object)nanos1, (Object)nanos1.min(millis1));
        Assertions.assertEquals((Object)nanos1, (Object)nanos1.min(seconds1));
        Assertions.assertEquals((Object)nanos1, (Object)nanos1.min(minutes1));
        Assertions.assertEquals((Object)nanos1, (Object)nanos1.min(hours1));
        Assertions.assertEquals((Object)nanos1, (Object)nanos1.min(days1));
        Assertions.assertEquals((Object)nanos1, (Object)micros1.min(nanos1));
        Assertions.assertEquals((Object)micros1, (Object)micros1.min(micros1));
        Assertions.assertEquals((Object)micros1, (Object)micros1.min(millis1));
        Assertions.assertEquals((Object)micros1, (Object)micros1.min(seconds1));
        Assertions.assertEquals((Object)micros1, (Object)micros1.min(minutes1));
        Assertions.assertEquals((Object)micros1, (Object)micros1.min(hours1));
        Assertions.assertEquals((Object)micros1, (Object)micros1.min(days1));
        Assertions.assertEquals((Object)nanos1, (Object)millis1.min(nanos1));
        Assertions.assertEquals((Object)micros1, (Object)millis1.min(micros1));
        Assertions.assertEquals((Object)millis1, (Object)millis1.min(millis1));
        Assertions.assertEquals((Object)millis1, (Object)millis1.min(seconds1));
        Assertions.assertEquals((Object)millis1, (Object)millis1.min(minutes1));
        Assertions.assertEquals((Object)millis1, (Object)millis1.min(hours1));
        Assertions.assertEquals((Object)millis1, (Object)millis1.min(days1));
        Assertions.assertEquals((Object)nanos1, (Object)seconds1.min(nanos1));
        Assertions.assertEquals((Object)micros1, (Object)seconds1.min(micros1));
        Assertions.assertEquals((Object)millis1, (Object)seconds1.min(millis1));
        Assertions.assertEquals((Object)seconds1, (Object)seconds1.min(seconds1));
        Assertions.assertEquals((Object)seconds1, (Object)seconds1.min(minutes1));
        Assertions.assertEquals((Object)seconds1, (Object)seconds1.min(hours1));
        Assertions.assertEquals((Object)seconds1, (Object)seconds1.min(days1));
        Assertions.assertEquals((Object)nanos1, (Object)minutes1.min(nanos1));
        Assertions.assertEquals((Object)micros1, (Object)minutes1.min(micros1));
        Assertions.assertEquals((Object)millis1, (Object)minutes1.min(millis1));
        Assertions.assertEquals((Object)seconds1, (Object)minutes1.min(seconds1));
        Assertions.assertEquals((Object)minutes1, (Object)minutes1.min(minutes1));
        Assertions.assertEquals((Object)minutes1, (Object)minutes1.min(hours1));
        Assertions.assertEquals((Object)minutes1, (Object)minutes1.min(days1));
        Assertions.assertEquals((Object)nanos1, (Object)hours1.min(nanos1));
        Assertions.assertEquals((Object)micros1, (Object)hours1.min(micros1));
        Assertions.assertEquals((Object)millis1, (Object)hours1.min(millis1));
        Assertions.assertEquals((Object)seconds1, (Object)hours1.min(seconds1));
        Assertions.assertEquals((Object)minutes1, (Object)hours1.min(minutes1));
        Assertions.assertEquals((Object)hours1, (Object)hours1.min(hours1));
        Assertions.assertEquals((Object)hours1, (Object)hours1.min(days1));
        Assertions.assertEquals((Object)nanos1, (Object)days1.min(nanos1));
        Assertions.assertEquals((Object)micros1, (Object)days1.min(micros1));
        Assertions.assertEquals((Object)millis1, (Object)days1.min(millis1));
        Assertions.assertEquals((Object)seconds1, (Object)days1.min(seconds1));
        Assertions.assertEquals((Object)minutes1, (Object)days1.min(minutes1));
        Assertions.assertEquals((Object)hours1, (Object)days1.min(hours1));
        Assertions.assertEquals((Object)days1, (Object)days1.min(days1));
    }

    @Test
    void testMaxInt() {
        this.test(Integer.MAX_VALUE);
    }

    @Test
    void testMaxLong() {
        this.test(Long.MAX_VALUE);
    }

    @Test
    void testNegative1() {
        this.test(-1L);
    }

    @Test
    void testToString() {
        Assertions.assertEquals((Object)"9223372036854775807 SECONDS", (Object)TimeValue.ofSeconds((long)Long.MAX_VALUE).toString());
        Assertions.assertEquals((Object)"0 MILLISECONDS", (Object)TimeValue.ZERO_MILLISECONDS.toString());
    }

    @Test
    void testFromString() throws ParseException {
        TimeValue maxSeconds = TimeValue.ofSeconds((long)Long.MAX_VALUE);
        Assertions.assertEquals((Object)maxSeconds, (Object)TimeValue.parse((String)"9223372036854775807 SECONDS"));
        Assertions.assertEquals((Object)maxSeconds, (Object)TimeValue.parse((String)"9223372036854775807 SECONDS"));
        Assertions.assertEquals((Object)maxSeconds, (Object)TimeValue.parse((String)" 9223372036854775807 SECONDS "));
        Assertions.assertEquals((Object)maxSeconds, (Object)TimeValue.parse((String)"9223372036854775807 Seconds"));
        Assertions.assertEquals((Object)maxSeconds, (Object)TimeValue.parse((String)"9223372036854775807  Seconds"));
        Assertions.assertEquals((Object)maxSeconds, (Object)TimeValue.parse((String)"9223372036854775807\tSeconds"));
        Assertions.assertEquals((Object)TimeValue.ZERO_MILLISECONDS, (Object)TimeValue.parse((String)"0 MILLISECONDS"));
        Assertions.assertEquals((Object)TimeValue.ofMilliseconds((long)1L), (Object)TimeValue.parse((String)"1 MILLISECOND"));
    }

    @Test
    void testToDuration() throws ParseException {
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)TimeValue.parse((String)"9223372036854775807 SECONDS").toDuration().getSeconds());
    }

    @Test
    void testEqualsAndHashCode() {
        TimeValue tv1 = TimeValue.ofMilliseconds((long)1000L);
        TimeValue tv2 = TimeValue.ofMilliseconds((long)1001L);
        TimeValue tv3 = TimeValue.ofMilliseconds((long)1000L);
        TimeValue tv4 = TimeValue.ofSeconds((long)1L);
        TimeValue tv5 = TimeValue.ofSeconds((long)1000L);
        MatcherAssert.assertThat((Object)tv1.equals((Object)tv1), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)tv1.equals(null), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)tv1.equals((Object)tv2), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)tv1.equals((Object)tv3), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)tv1.equals((Object)tv4), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)tv4.equals((Object)tv1), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)tv1.equals((Object)tv5), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)(tv1.hashCode() == tv2.hashCode() ? 1 : 0), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)(tv1.hashCode() == tv3.hashCode() ? 1 : 0), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)(tv1.hashCode() == tv4.hashCode() ? 1 : 0), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)(tv4.hashCode() == tv1.hashCode() ? 1 : 0), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)(tv1.hashCode() == tv5.hashCode() ? 1 : 0), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    void testCompareTo() {
        TimeValue tv1 = TimeValue.ofMilliseconds((long)1000L);
        TimeValue tv2 = TimeValue.ofMilliseconds((long)1001L);
        TimeValue tv3 = TimeValue.ofMilliseconds((long)1000L);
        TimeValue tv4 = TimeValue.ofSeconds((long)1L);
        TimeValue tv5 = TimeValue.ofSeconds((long)60L);
        TimeValue tv6 = TimeValue.ofMinutes((long)1L);
        MatcherAssert.assertThat((Object)(tv1.compareTo(tv1) == 0 ? 1 : 0), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)(tv1.compareTo(tv2) < 0 ? 1 : 0), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)(tv1.compareTo(tv3) == 0 ? 1 : 0), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)(tv1.compareTo(tv4) == 0 ? 1 : 0), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)(tv1.compareTo(tv5) < 0 ? 1 : 0), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)(tv6.compareTo(tv5) == 0 ? 1 : 0), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)(tv6.compareTo(tv4) > 0 ? 1 : 0), (Matcher)CoreMatchers.equalTo((Object)true));
        Assertions.assertThrows(NullPointerException.class, () -> tv1.compareTo(null));
    }
}

