/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.deployment.uri;

import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;

class GridUriDeploymentUriParser {
    private final String input;
    @GridToStringExclude
    private String encoded;

    GridUriDeploymentUriParser(String input) {
        assert (input != null);
        this.input = input;
        this.encoded = input;
    }

    String parse() {
        int n = this.input.length();
        int p = this.scan(0, n, "/?#", ":");
        if (p > 0 && this.at(p, n, ':') && this.at(++p, n, '/')) {
            int q;
            if (this.at(p, n, '/') && this.at(p + 1, n, '/') && (q = this.scan(p += 2, n, "", "/?#")) > p) {
                p = q;
            }
            q = this.scan(p, n, "", "?#");
            StringBuilder buf = new StringBuilder(this.input.substring(0, p));
            buf.append(this.encodePath(this.input.substring(p, q)));
            buf.append(this.input.substring(q, n));
            this.encoded = buf.toString();
        }
        return this.encoded;
    }

    private int scan(int start, int end, String err, String stop) {
        int p;
        for (p = start; p < end; ++p) {
            char c = this.input.charAt(p);
            if (err.indexOf(c) >= 0) {
                return -1;
            }
            if (stop.indexOf(c) >= 0) break;
        }
        return p;
    }

    private boolean at(int start, int end, char c) {
        return start < end && this.input.charAt(start) == c;
    }

    private String encodePath(String path) {
        StringBuilder buf = new StringBuilder(path.length());
        block5: for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            switch (c) {
                case ' ': {
                    buf.append("%20");
                    continue block5;
                }
                case '%': {
                    buf.append("%25");
                    continue block5;
                }
                case ';': {
                    buf.append("%3B");
                    continue block5;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public String toString() {
        return S.toString(GridUriDeploymentUriParser.class, (Object)this);
    }
}

